/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.shell.cli.sh.AbstractCommandIntegrationTestWithGrpc;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.StringPrintStream;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.thirdparty.com.google.common.collect.ObjectArrays;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class PeerCommandIntegrationTest<CLUSTER extends MiniRaftCluster>
extends AbstractCommandIntegrationTestWithGrpc
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public PeerCommandIntegrationTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.WARN);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
    }

    @Test
    public void testPeerAddRemoveCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestPeerRemoveCommand);
        this.runWithNewCluster(3, this::runTestPeerAddCommand);
    }

    void runTestPeerRemoveCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        RaftServer.Division toRemove = (RaftServer.Division)cluster.getFollowers().get(0);
        RaftPeer[] peers = new RaftPeer[]{((RaftServer.Division)cluster.getFollowers().get(1)).getPeer(), leader.getPeer()};
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertTrue((boolean)cluster.getFollowers().contains(toRemove));
        int ret = shell.run(new String[]{"peer", "remove", "-peers", address, "-peerId", toRemove.getPeer().getId().toString()});
        Assertions.assertEquals((int)0, (int)ret);
        RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, (RaftPeer[])peers, (int)1, null);
    }

    void runTestPeerAddCommand(MiniRaftCluster cluster) throws Exception {
        this.LOG.info("Start testMultiGroup" + cluster.printServers());
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        Object[] peers = cluster.getPeers().toArray(new RaftPeer[0]);
        RaftPeer[] newPeers = cluster.addNewPeers((int)1, (boolean)true, (boolean)true).newPeers;
        RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, (RaftPeer[])peers, (int)0, null);
        StringBuilder sb = new StringBuilder();
        for (RaftPeer raftPeer : peers) {
            sb.append(raftPeer.getAdminAddress());
            sb.append(",");
        }
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        int ret = shell.run(new String[]{"peer", "add", "-peers", sb.toString(), "-address", newPeers[0].getAdminAddress(), "-peerId", newPeers[0].getId().toString()});
        Assertions.assertEquals((int)0, (int)ret);
        RaftServerTestUtil.waitAndCheckNewConf((MiniRaftCluster)cluster, (RaftPeer[])((RaftPeer[])ObjectArrays.concat((Object[])peers, (Object)newPeers[0])), (int)0, null);
    }

    @Test
    public void testPeerSetPriorityCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestPeerSetPriorityCommand);
    }

    void runTestPeerSetPriorityCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        String address = this.getClusterAddress(cluster);
        RaftServer.Division newLeader = (RaftServer.Division)cluster.getFollowers().get(0);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertTrue((boolean)cluster.getFollowers().contains(newLeader));
        int ret = shell.run(new String[]{"peer", "setPriority", "-peers", address, "-addressPriority", newLeader.getPeer().getAddress() + "|" + 2});
        Assertions.assertEquals((int)0, (int)ret);
        JavaUtils.attempt(() -> Assertions.assertEquals((Object)cluster.getLeader().getId(), (Object)newLeader.getId()), (int)10, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS), (String)"testPeerSetPriorityCommand", (Logger)this.LOG);
    }
}

