/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.File;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.shell.cli.sh.AbstractCommandIntegrationTestWithGrpc;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.StringPrintStream;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class SnapshotCommandIntegrationTest<CLUSTER extends MiniRaftCluster>
extends AbstractCommandIntegrationTestWithGrpc
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public SnapshotCommandIntegrationTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.WARN);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.WARN);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((String)"8KB"));
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)false);
        RaftServerConfigKeys.Snapshot.setCreationGap((RaftProperties)prop, (long)20L);
    }

    @Test
    public void testSnapshotCreateCommand() throws Exception {
        this.runWithNewCluster(3, this::runTestSnapshotCreateCommand);
        this.runWithNewCluster(3, this::runTestSnapshotCreateCommandOnSpecificServer);
    }

    void runTestSnapshotCreateCommand(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assertions.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
        }
        String address = this.getClusterAddress(cluster);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        int ret = shell.run(new String[]{"snapshot", "create", "-peers", address, "-peerId", leader.getPeer().getId().toString()});
        Assertions.assertEquals((int)0, (int)ret);
        String[] str = out.toString().trim().split(" ");
        int snapshotIndex = Integer.parseInt(str[str.length - 1]);
        this.LOG.info("snapshotIndex = {}", (Object)snapshotIndex);
        File snapshotFile = SimpleStateMachine4Testing.get((RaftServer.Division)leader).getStateMachineStorage().getSnapshotFile(leader.getInfo().getCurrentTerm(), (long)snapshotIndex);
        Assertions.assertTrue((boolean)snapshotFile.exists());
    }

    void runTestSnapshotCreateCommandOnSpecificServer(MiniRaftCluster cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assertions.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
        }
        String address = this.getClusterAddress(cluster);
        StringPrintStream out = new StringPrintStream();
        RatisShell shell = new RatisShell(out.getPrintStream());
        Assertions.assertEquals((int)2, (int)cluster.getFollowers().size());
        int ret = shell.run(new String[]{"snapshot", "create", "-peers", address, "-peerId", ((RaftServer.Division)cluster.getFollowers().get(0)).getId().toString()});
        Assertions.assertEquals((int)0, (int)ret);
        String[] str = out.toString().trim().split(" ");
        int snapshotIndex = Integer.parseInt(str[str.length - 1]);
        this.LOG.info("snapshotIndex = {}", (Object)snapshotIndex);
        File snapshotFile = SimpleStateMachine4Testing.get((RaftServer.Division)((RaftServer.Division)cluster.getFollowers().get(0))).getStateMachineStorage().getSnapshotFile(((RaftServer.Division)cluster.getFollowers().get(0)).getInfo().getCurrentTerm(), (long)snapshotIndex);
        Assertions.assertTrue((boolean)snapshotFile.exists());
    }
}

