/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.ratis.BaseTest;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.shell.cli.sh.command.AbstractParentCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.shell.cli.sh.command.ElectionCommand;
import org.apache.ratis.shell.cli.sh.command.GroupCommand;
import org.apache.ratis.shell.cli.sh.command.LocalCommand;
import org.apache.ratis.shell.cli.sh.command.PeerCommand;
import org.apache.ratis.shell.cli.sh.command.SnapshotCommand;
import org.apache.ratis.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class TestRatisShell
extends BaseTest {
    static final PrintStream OUT = System.out;
    static final Class<?>[] ARG_CLASSES = new Class[]{Context.class};

    static void assertCommand(String message, Command expected, Command computed) {
        Assertions.assertEquals(expected.getClass(), computed.getClass(), (String)message);
        Assertions.assertEquals((Object)expected.getCommandName(), (Object)computed.getCommandName(), (String)message);
    }

    static void assertCommands(List<Command> expected, List<Command> computed) {
        Assertions.assertEquals((int)expected.size(), (int)computed.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestRatisShell.assertCommand("Command " + i, expected.get(i), computed.get(i));
        }
    }

    @Test
    public void testFullParentCommandList() throws Exception {
        ArrayList<Command> expected = new ArrayList<Command>(TestRatisShell.loadCommands(RatisShell.class.getPackage().getName() + ".command"));
        Collections.sort(expected);
        try (RatisShell shell = new RatisShell(OUT);){
            ArrayList<Command> computed = new ArrayList<Command>(shell.getCommands());
            Collections.sort(computed);
            TestRatisShell.assertCommands(expected, computed);
        }
    }

    @Test
    public void testFullPeerCommandList() {
        TestRatisShell.runTestFullCommandList(PeerCommand::new);
    }

    @Test
    public void testFullGroupCommandList() {
        TestRatisShell.runTestFullCommandList(GroupCommand::new);
    }

    @Test
    public void testFullElectionCommandList() {
        TestRatisShell.runTestFullCommandList(ElectionCommand::new);
    }

    @Test
    public void testFullSnapshotCommandList() {
        TestRatisShell.runTestFullCommandList(SnapshotCommand::new);
    }

    @Test
    public void testFullLocalCommandList() {
        TestRatisShell.runTestFullCommandList(LocalCommand::new);
    }

    static void runTestFullCommandList(Function<Context, AbstractParentCommand> parentCommandConstructor) {
        AbstractParentCommand parent = parentCommandConstructor.apply(new Context(OUT));
        ArrayList<Command> computed = new ArrayList<Command>(parent.getSubCommands().values());
        Collections.sort(computed);
        Assertions.assertFalse((boolean)computed.isEmpty());
        Package pkg = ((Command)computed.iterator().next()).getClass().getPackage();
        ArrayList<Command> expected = new ArrayList<Command>(TestRatisShell.loadCommands(pkg));
        Collections.sort(expected);
        TestRatisShell.assertCommands(expected, computed);
    }

    static Collection<Command> loadCommands(Package pkg) {
        return TestRatisShell.loadCommands(pkg.getName());
    }

    static Collection<Command> loadCommands(String pkgName) {
        return TestRatisShell.oldLoadCommands(pkgName, ARG_CLASSES, new Object[]{new Context(OUT)}).values();
    }

    static Map<String, Command> oldLoadCommands(String pkgName, Class<?>[] classArgs, Object[] objectArgs) {
        HashMap<String, Command> commandsMap = new HashMap<String, Command>();
        Reflections reflections = new Reflections(pkgName, new Scanner[0]);
        for (Class cls : reflections.getSubTypesOf(Command.class)) {
            if (!cls.getPackage().getName().equals(pkgName) || Modifier.isAbstract(cls.getModifiers())) continue;
            Command cmd = (Command)ReflectionUtils.newInstance((Class)cls, (Class[])classArgs, (Object[])objectArgs);
            commandsMap.put(cmd.getCommandName(), cmd);
        }
        return commandsMap;
    }
}

