/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.security.SecurityTestUtils;
import org.apache.ratis.shell.cli.sh.RatisShell;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestSecureRatisShell
extends BaseTest {
    private static final Parameters SERVER_PARAMETERS = new Parameters();
    private static final Parameters CLIENT_PARAMETERS = new Parameters();

    public TestSecureRatisShell() {
        Slf4jUtils.setLogLevel((Logger)NettyUtils.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testRatisShell() throws Exception {
        String[] ids = new String[]{"s0"};
        RaftProperties properties = new RaftProperties();
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)TimeDuration.ONE_MINUTE);
        GrpcConfigKeys.TLS.setEnabled((RaftProperties)properties, (boolean)true);
        GrpcConfigKeys.TLS.setMutualAuthnEnabled((RaftProperties)properties, (boolean)true);
        try (MiniRaftClusterWithGrpc cluster = new MiniRaftClusterWithGrpc(ids, properties, SERVER_PARAMETERS);){
            cluster.start();
            this.runTestRatisShell(cluster, true);
            this.runTestRatisShell(cluster, false);
        }
    }

    void runTestRatisShell(MiniRaftClusterWithGrpc cluster, boolean secure) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
             RatisShell shell = TestSecureRatisShell.newRatisShell(out, cluster.getProperties(), secure);){
            shell.run(new String[]{"group", "info", "-peers", TestSecureRatisShell.toCliArg(cluster.getPeers())});
            String output = out.toString();
            this.LOG.info("output (secure? {}):\n{}", (Object)secure, (Object)output);
            String gid = cluster.getGroup().getGroupId().getUuid().toString();
            if (secure) {
                Assertions.assertTrue((boolean)output.contains(gid), () -> gid + " not found for secure shell");
            } else {
                Assertions.assertTrue((boolean)output.contains("Failed to get group ID"), (String)"Unexpected output for unsecure shell");
            }
        }
    }

    static RatisShell newRatisShell(OutputStream out, RaftProperties properties, boolean secure) {
        PrintStream printStream = new PrintStream(out, true);
        if (!secure) {
            return new RatisShell(printStream);
        }
        return RatisShell.newBuilder().setPrintStream(printStream).setProperties(properties).setParameters(CLIENT_PARAMETERS).build();
    }

    static String toCliArg(List<RaftPeer> peers) {
        StringBuilder b = new StringBuilder();
        for (RaftPeer peer : peers) {
            b.append(peer.getAdminAddress()).append(",");
        }
        return b.substring(0, b.length() - 1);
    }

    static {
        TrustManager emptyTrustManager = SecurityTestUtils.emptyTrustManager();
        try {
            KeyManager serverKeyManager = SecurityTestUtils.getKeyManager(SecurityTestUtils::getServerKeyStore);
            GrpcTlsConfig serverConfig = new GrpcTlsConfig(serverKeyManager, emptyTrustManager, true);
            GrpcConfigKeys.Server.setTlsConf((Parameters)SERVER_PARAMETERS, (GrpcTlsConfig)serverConfig);
            GrpcConfigKeys.Admin.setTlsConf((Parameters)SERVER_PARAMETERS, (GrpcTlsConfig)serverConfig);
            GrpcConfigKeys.Client.setTlsConf((Parameters)SERVER_PARAMETERS, (GrpcTlsConfig)serverConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to init SERVER_PARAMETERS", e);
        }
        try {
            KeyManager clientKeyManager = SecurityTestUtils.getKeyManager(SecurityTestUtils::getClientKeyStore);
            GrpcTlsConfig clientConfig = new GrpcTlsConfig(clientKeyManager, emptyTrustManager, true);
            GrpcConfigKeys.Admin.setTlsConf((Parameters)CLIENT_PARAMETERS, (GrpcTlsConfig)clientConfig);
            GrpcConfigKeys.Client.setTlsConf((Parameters)CLIENT_PARAMETERS, (GrpcTlsConfig)clientConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to init CLIENT_PARAMETERS", e);
        }
    }
}

