/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestStateMachine
extends BaseTest
implements MiniRaftClusterWithSimulatedRpc.FactoryGet {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testTransactionContextIsPassedBack() throws Throwable {
        this.runTestTransactionContextIsPassedBack(false);
    }

    @Test
    public void testTransactionContextIsPassedBackUseMemory() throws Throwable {
        this.runTestTransactionContextIsPassedBack(true);
    }

    void runTestTransactionContextIsPassedBack(boolean useMemory) throws Throwable {
        RaftProperties properties = new RaftProperties();
        properties.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SMTransactionContext.class, StateMachine.class);
        RaftServerConfigKeys.Log.setUseMemory((RaftProperties)properties, (boolean)useMemory);
        try (MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)this.getFactory().newCluster(3, properties);){
            cluster.start();
            TestStateMachine.runTestTransactionContextIsPassedBack((MiniRaftCluster)cluster);
        }
    }

    static void runTestTransactionContextIsPassedBack(MiniRaftCluster cluster) throws Throwable {
        int numTrx = 100;
        RaftTestUtil.SimpleMessage[] messages = RaftTestUtil.SimpleMessage.create((int)numTrx);
        try (RaftClient client = cluster.createClient();){
            for (RaftTestUtil.SimpleMessage message : messages) {
                client.io().send((Message)message);
            }
        }
        Thread.sleep(cluster.getTimeoutMax().toLong(TimeUnit.MILLISECONDS) + 100L);
        for (RaftServer.Division raftServer : cluster.iterateDivisions()) {
            SMTransactionContext sm = SMTransactionContext.get(raftServer);
            sm.rethrowIfException();
            Assertions.assertEquals((long)numTrx, (long)sm.numApplied.get());
        }
        RaftServer.Division raftServer = cluster.getLeader();
        SMTransactionContext sm = SMTransactionContext.get(raftServer);
        ArrayList<Long> ll = new ArrayList<Long>(sm.applied);
        Collections.sort(ll);
        Assertions.assertEquals((int)ll.size(), (int)numTrx, (String)((Object)ll).toString());
        for (int i = 0; i < numTrx; ++i) {
            Assertions.assertEquals((Long)Long.valueOf(i + 1), (Long)((Long)ll.get(i)), (String)((Object)ll).toString());
        }
    }

    @Test
    public void testStateMachineRegistry() throws Throwable {
        ConcurrentHashMap<RaftGroupId, SimpleStateMachine4Testing> registry = new ConcurrentHashMap<RaftGroupId, SimpleStateMachine4Testing>();
        registry.put(RaftGroupId.randomId(), new SimpleStateMachine4Testing());
        registry.put(RaftGroupId.randomId(), new SMTransactionContext());
        try (MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)this.newCluster(0);){
            cluster.setStateMachineRegistry(registry::get);
            RaftPeerId id = RaftPeerId.valueOf((String)"s0");
            cluster.putNewServer(id, null, true);
            cluster.start();
            for (RaftGroupId gid : registry.keySet()) {
                RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)gid, (Iterable)cluster.getPeers());
                this.LOG.info("add new group: " + newGroup);
                RaftClient client = cluster.createClient(newGroup);
                Throwable throwable = null;
                try {
                    for (RaftPeer p : newGroup.getPeers()) {
                        client.getGroupManagementApi(p.getId()).add(newGroup);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            RaftServerProxy server = cluster.getServer(id);
            for (Map.Entry e : registry.entrySet()) {
                Assertions.assertSame(e.getValue(), (Object)server.getDivision((RaftGroupId)e.getKey()).getStateMachine());
            }
        }
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    static class SMTransactionContext
    extends SimpleStateMachine4Testing {
        AtomicReference<Throwable> throwable = new AtomicReference<Object>(null);
        AtomicLong transactions = new AtomicLong(0L);
        AtomicBoolean isLeader = new AtomicBoolean(false);
        AtomicLong numApplied = new AtomicLong(0L);
        ConcurrentLinkedQueue<Long> applied = new ConcurrentLinkedQueue();

        SMTransactionContext() {
        }

        public static SMTransactionContext get(RaftServer.Division s) {
            return (SMTransactionContext)s.getStateMachine();
        }

        public TransactionContext startTransaction(RaftClientRequest request) {
            this.isLeader.set(true);
            return TransactionContext.newBuilder().setStateMachine((StateMachine)this).setClientRequest(request).setStateMachineContext((Object)this.transactions.incrementAndGet()).build();
        }

        public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
            try {
                Assertions.assertNotNull((Object)trx.getLogEntry());
                Assertions.assertNotNull((Object)trx.getStateMachineLogEntry());
                Object context = trx.getStateMachineContext();
                if (this.isLeader.get()) {
                    Assertions.assertNotNull((Object)trx.getClientRequest());
                    Assertions.assertNotNull((Object)context);
                    Assertions.assertTrue((boolean)(context instanceof Long));
                    Long val = (Long)context;
                    Assertions.assertTrue((val <= this.transactions.get() ? 1 : 0) != 0);
                    this.applied.add(val);
                } else {
                    Assertions.assertNull((Object)trx.getClientRequest());
                    Assertions.assertNull((Object)context);
                }
                this.numApplied.incrementAndGet();
            }
            catch (Exception e) {
                this.throwable.set(e);
            }
            return CompletableFuture.completedFuture(null);
        }

        void rethrowIfException() throws Throwable {
            Throwable t = this.throwable.get();
            if (t != null) {
                throw t;
            }
        }
    }
}

