/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.DataBlockingQueue;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TestDataQueue;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataBlockingQueue {
    static final Logger LOG = LoggerFactory.getLogger(TestDataBlockingQueue.class);
    final SizeInBytes byteLimit = SizeInBytes.valueOf((long)100L);
    final int elementLimit = 10;
    final DataBlockingQueue<Long> q = new DataBlockingQueue(null, this.byteLimit, 10, Long::longValue);
    final TimeDuration slow = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    final TimeDuration fast = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);

    @Test
    @Timeout(value=1L)
    public void testElementLimit() {
        TestDataQueue.runTestElementLimit(this.q);
    }

    @Test
    @Timeout(value=1L)
    public void testByteLimit() {
        TestDataQueue.runTestByteLimit(this.q);
    }

    @Test
    @Timeout(value=10L)
    public void testSlowOfferFastPoll() throws Exception {
        TestDataBlockingQueue.runTestBlockingCalls(this.slow, this.fast, this.q);
    }

    @Test
    @Timeout(value=10L)
    public void testFastOfferSlowPoll() throws Exception {
        TestDataBlockingQueue.runTestBlockingCalls(this.fast, this.slow, this.q);
    }

    static void assertOfferPull(long offering, long polled, long elementLimit) {
        Assertions.assertTrue((offering >= polled ? 1 : 0) != 0);
        Assertions.assertTrue((offering - polled <= elementLimit + 1L ? 1 : 0) != 0);
    }

    static void runTestBlockingCalls(TimeDuration offerSleepTime, TimeDuration pollSleepTime, DataBlockingQueue<Long> q) throws Exception {
        Assertions.assertTrue((boolean)q.isEmpty());
        ExitUtils.disableSystemExit();
        int elementLimit = q.getElementLimit();
        TimeDuration timeout = (TimeDuration)CollectionUtils.min((Comparable)offerSleepTime, (Comparable)pollSleepTime);
        AtomicLong offeringValue = new AtomicLong();
        AtomicLong polledValue = new AtomicLong();
        int endValue = 30;
        Thread pollThread = new Thread(() -> {
            try {
                while (polledValue.get() < 30L) {
                    pollSleepTime.sleep();
                    Long polled = (Long)q.poll(timeout);
                    if (polled != null) {
                        Assertions.assertEquals((long)polledValue.incrementAndGet(), (long)polled.intValue());
                        LOG.info("polled {}", (Object)polled);
                    }
                    TestDataBlockingQueue.assertOfferPull(offeringValue.get(), polledValue.get(), elementLimit);
                }
            }
            catch (Exception e) {
                ExitUtils.terminate((int)-2, (String)"pollThread failed", (Throwable)e, null);
            }
        });
        Thread offerThread = new Thread(() -> {
            try {
                offeringValue.incrementAndGet();
                while (offeringValue.get() <= 30L) {
                    offerSleepTime.sleep();
                    boolean offered = q.offer((Object)offeringValue.get(), timeout);
                    if (offered) {
                        LOG.info("offered {}", (Object)offeringValue.getAndIncrement());
                    }
                    TestDataBlockingQueue.assertOfferPull(offeringValue.get(), polledValue.get(), elementLimit);
                }
            }
            catch (Exception e) {
                ExitUtils.terminate((int)-1, (String)"offerThread failed", (Throwable)e, null);
            }
        });
        pollThread.start();
        offerThread.start();
        offerThread.join();
        pollThread.join();
        Assertions.assertEquals((long)31L, (long)offeringValue.get());
        Assertions.assertEquals((long)30L, (long)polledValue.get());
        Assertions.assertTrue((boolean)q.isEmpty());
        ExitUtils.assertNotTerminated();
    }
}

