/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.ratis.util.DataQueue;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.TriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDataQueue {
    final SizeInBytes byteLimit = SizeInBytes.valueOf((long)100L);
    final int elementLimit = 5;
    final DataQueue<Long> q = new DataQueue(null, this.byteLimit, 5, Long::longValue);

    static <T> TriConsumer<T, TimeDuration, TimeoutException> getTimeoutHandler(boolean expctedTimeout) {
        return (element, time, exception) -> {
            if (!expctedTimeout) {
                throw new AssertionError("Unexpected timeout to get element " + element + " in " + time, (Throwable)exception);
            }
        };
    }

    static void assertSizes(long expectedNumElements, long expectedNumBytes, DataQueue<?> q) {
        Assertions.assertEquals((long)expectedNumElements, (long)q.getNumElements());
        Assertions.assertEquals((long)expectedNumBytes, (long)q.getNumBytes());
    }

    @Test
    @Timeout(value=1L)
    public void testElementLimit() {
        TestDataQueue.runTestElementLimit(this.q);
    }

    static void runTestElementLimit(DataQueue<Long> q) {
        TestDataQueue.assertSizes(0L, 0L, q);
        int elementLimit = q.getElementLimit();
        long numBytes = 0L;
        for (long i2 = 0L; i2 < (long)elementLimit; ++i2) {
            Assertions.assertEquals((long)i2, (long)q.getNumElements());
            Assertions.assertEquals((long)numBytes, (long)q.getNumBytes());
            boolean offered = q.offer((Object)i2);
            Assertions.assertTrue((boolean)offered);
            TestDataQueue.assertSizes(i2 + 1L, numBytes += i2, q);
        }
        boolean offered = q.offer((Object)0L);
        Assertions.assertFalse((boolean)offered);
        TestDataQueue.assertSizes(elementLimit, numBytes, q);
        List polled = q.pollList(100L, (i, timeout) -> i, TestDataQueue.getTimeoutHandler(false));
        Assertions.assertEquals((int)elementLimit, (int)polled.size());
        for (int i3 = 0; i3 < polled.size(); ++i3) {
            Assertions.assertEquals((int)i3, (int)((Long)polled.get(i3)).intValue());
        }
        TestDataQueue.assertSizes(0L, 0L, q);
    }

    @Test
    @Timeout(value=1L)
    public void testByteLimit() {
        TestDataQueue.runTestByteLimit(this.q);
    }

    static void runTestByteLimit(DataQueue<Long> q) {
        TestDataQueue.assertSizes(0L, 0L, q);
        long byteLimit = q.getByteLimit();
        try {
            q.offer((Object)(byteLimit + 1L));
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        long halfBytes = byteLimit / 2L;
        boolean offered = q.offer((Object)halfBytes);
        Assertions.assertTrue((boolean)offered);
        TestDataQueue.assertSizes(1L, halfBytes, q);
        offered = q.offer((Object)(halfBytes + 1L));
        Assertions.assertFalse((boolean)offered);
        TestDataQueue.assertSizes(1L, halfBytes, q);
        offered = q.offer((Object)halfBytes);
        Assertions.assertTrue((boolean)offered);
        TestDataQueue.assertSizes(2L, byteLimit, q);
        offered = q.offer((Object)1L);
        Assertions.assertFalse((boolean)offered);
        TestDataQueue.assertSizes(2L, byteLimit, q);
        offered = q.offer((Object)0L);
        Assertions.assertTrue((boolean)offered);
        TestDataQueue.assertSizes(3L, byteLimit, q);
        List polled = q.pollList(100L, (i, timeout) -> i, TestDataQueue.getTimeoutHandler(false));
        Assertions.assertEquals((int)3, (int)polled.size());
        Assertions.assertEquals((long)halfBytes, (long)((Long)polled.get(0)).intValue());
        Assertions.assertEquals((long)halfBytes, (long)((Long)polled.get(1)).intValue());
        Assertions.assertEquals((int)0, (int)((Long)polled.get(2)).intValue());
        TestDataQueue.assertSizes(0L, 0L, q);
    }

    @Test
    @Timeout(value=1L)
    public void testIteratorAndRemove() {
        TestDataQueue.runTestIteratorAndRemove(this.q);
    }

    static void runTestIteratorAndRemove(DataQueue<Long> q) {
        TestDataQueue.assertSizes(0L, 0L, q);
        int elementLimit = q.getElementLimit();
        int numElements = 0;
        long numBytes = 0L;
        for (long i = 0L; i < (long)elementLimit; ++i) {
            boolean offered = q.offer((Object)i);
            Assertions.assertTrue((boolean)offered);
            TestDataQueue.assertSizes(++numElements, numBytes += i, q);
        }
        Iterator i = q.iterator();
        for (long expected = 0L; expected < (long)elementLimit; ++expected) {
            Assertions.assertEquals((long)expected, (long)((Long)i.next()));
        }
        ArrayList<Long> toRemoves = new ArrayList<Long>(elementLimit);
        for (long i2 = 0L; i2 < (long)elementLimit; ++i2) {
            toRemoves.add(i2);
        }
        Collections.shuffle(toRemoves);
        for (Long r : toRemoves) {
            q.remove((Object)r);
            TestDataQueue.assertSizes(--numElements, numBytes -= r.longValue(), q);
        }
        TestDataQueue.assertSizes(0L, 0L, q);
    }

    @Test
    @Timeout(value=1L)
    public void testTimeout() {
        int i2;
        TestDataQueue.assertSizes(0L, 0L, this.q);
        long numBytes = 0L;
        for (long i3 = 0L; i3 < 5L; ++i3) {
            Assertions.assertEquals((long)i3, (long)this.q.getNumElements());
            Assertions.assertEquals((long)numBytes, (long)this.q.getNumBytes());
            boolean offered = this.q.offer((Object)i3);
            Assertions.assertTrue((boolean)offered);
            TestDataQueue.assertSizes(i3 + 1L, numBytes += i3, this.q);
        }
        List polled = this.q.pollList(0L, (i, timeout) -> i, TestDataQueue.getTimeoutHandler(false));
        Assertions.assertTrue((boolean)polled.isEmpty());
        TestDataQueue.assertSizes(5L, numBytes, this.q);
        int halfElements = 2;
        List polled2 = this.q.pollList(100L, (i, timeout) -> {
            if (i == 2L) {
                throw new TimeoutException("i=" + i);
            }
            return i;
        }, TestDataQueue.getTimeoutHandler(true));
        Assertions.assertEquals((int)2, (int)polled2.size());
        for (i2 = 0; i2 < polled2.size(); ++i2) {
            Assertions.assertEquals((int)i2, (int)((Long)polled2.get(i2)).intValue());
            numBytes -= (long)i2;
        }
        TestDataQueue.assertSizes(3L, numBytes, this.q);
        polled2 = this.q.pollList(100L, (i, timeout) -> i, TestDataQueue.getTimeoutHandler(false));
        Assertions.assertEquals((int)3, (int)polled2.size());
        for (i2 = 0; i2 < polled2.size(); ++i2) {
            Assertions.assertEquals((int)(2 + i2), (int)((Long)polled2.get(i2)).intValue());
        }
        TestDataQueue.assertSizes(0L, 0L, this.q);
    }
}

