/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.apache.ratis.BaseTest;
import org.apache.ratis.util.ExitUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;

public class TestExitUtils
extends BaseTest {
    @Test
    @Timeout(value=1L)
    public void testUncaughtException() throws Exception {
        Assertions.assertFalse((boolean)ExitUtils.isTerminated());
        Assertions.assertFalse((boolean)ExitUtils.clear());
        Thread t = new Thread(null, () -> {
            throw new AssertionError((Object)"Testing");
        }, "testThread");
        t.start();
        t.join();
        Assertions.assertTrue((boolean)ExitUtils.isTerminated());
        Assertions.assertTrue((boolean)ExitUtils.clear());
    }

    @Test
    @Timeout(value=1L)
    public void testExitStatus() {
        Assertions.assertFalse((boolean)ExitUtils.isTerminated());
        Assertions.assertFalse((boolean)ExitUtils.clear());
        int status = -1;
        try {
            ExitUtils.terminate((int)-1, (String)"testExitStatus", (Logger)this.LOG);
            Assertions.fail();
        }
        catch (ExitUtils.ExitException e) {
            Assertions.assertEquals((int)-1, (int)e.getStatus());
        }
        Assertions.assertTrue((boolean)ExitUtils.isTerminated());
        Assertions.assertTrue((boolean)ExitUtils.clear());
    }
}

