/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.function.TriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestLifeCycle {
    @Test
    @Timeout(value=1L)
    public void testIsValid() {
        EnumMap successors = new EnumMap(LifeCycle.State.class);
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.NEW, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.STARTING, LifeCycle.State.CLOSED});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.STARTING, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.NEW, LifeCycle.State.RUNNING, LifeCycle.State.CLOSING, LifeCycle.State.EXCEPTION});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.RUNNING, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.CLOSING, LifeCycle.State.PAUSING, LifeCycle.State.EXCEPTION});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.PAUSING, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.PAUSED, LifeCycle.State.CLOSING, LifeCycle.State.EXCEPTION});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.PAUSED, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.STARTING, LifeCycle.State.CLOSING});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.EXCEPTION, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.CLOSING});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.CLOSING, successors, (LifeCycle.State[])new LifeCycle.State[]{LifeCycle.State.CLOSED});
        LifeCycle.State.put((LifeCycle.State)LifeCycle.State.CLOSED, successors, (LifeCycle.State[])new LifeCycle.State[0]);
        List<LifeCycle.State> states = Arrays.asList(LifeCycle.State.values());
        states.forEach(from -> states.forEach(to -> Assertions.assertEquals((Object)((List)successors.get(from)).contains(to), (Object)LifeCycle.State.isValid((LifeCycle.State)from, (LifeCycle.State)to), (String)(from + " -> " + to))));
    }

    @Test
    public void validTransitions() {
        TestLifeCycle.testValidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> Assertions.assertTrue((boolean)subject.compareAndTransition(from, to))));
        TestLifeCycle.testValidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.transition(to)));
        TestLifeCycle.testValidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> Assertions.assertEquals((Object)to, (Object)subject.transitionAndGet(any -> to))));
        TestLifeCycle.testValidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.transitionIfNotEqual(to)));
        TestLifeCycle.testValidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> Assertions.assertTrue((boolean)subject.transitionIfValid(to))));
    }

    private static void testValidTransition(TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State> op) {
        LifeCycle subject = new LifeCycle((Object)"subject");
        for (LifeCycle.State to : new LifeCycle.State[]{LifeCycle.State.STARTING, LifeCycle.State.RUNNING, LifeCycle.State.PAUSING, LifeCycle.State.PAUSED, LifeCycle.State.CLOSING, LifeCycle.State.CLOSED}) {
            LifeCycle.State from = subject.getCurrentState();
            op.accept((Object)from, (Object)subject, (Object)to);
            Assertions.assertEquals((Object)to, (Object)subject.getCurrentState());
        }
    }

    @Test
    public void invalidTransitions() {
        TestLifeCycle.testInvalidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.compareAndTransition(from, to)), true);
        TestLifeCycle.testInvalidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.transition(to)), true);
        TestLifeCycle.testInvalidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.transitionIfNotEqual(to)), true);
        TestLifeCycle.testInvalidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> Assertions.assertFalse((boolean)subject.transitionIfValid(to))), false);
        TestLifeCycle.testInvalidTransition((TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State>)((TriConsumer)(from, subject, to) -> subject.transitionAndGet(any -> to)), true);
    }

    private static void testInvalidTransition(TriConsumer<LifeCycle.State, LifeCycle, LifeCycle.State> op, boolean shouldThrow) {
        LifeCycle subject = new LifeCycle((Object)"subject");
        for (LifeCycle.State to : new LifeCycle.State[]{LifeCycle.State.RUNNING, LifeCycle.State.EXCEPTION, LifeCycle.State.CLOSING}) {
            LifeCycle.State from = subject.getCurrentState();
            try {
                op.accept((Object)from, (Object)subject, (Object)to);
                Assertions.assertFalse((boolean)shouldThrow);
            }
            catch (IllegalStateException e) {
                Assertions.assertTrue((boolean)shouldThrow);
                Assertions.assertEquals((Object)from, (Object)subject.getCurrentState(), (String)"Should be in original state");
            }
        }
    }
}

