/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.LongStream;
import org.apache.ratis.util.LongMinMax;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestMinMax {
    @Test
    @Timeout(value=1L)
    public void testMinMax() {
        int count;
        TestMinMax.runTestMinMax(LongStream.empty());
        TestMinMax.runTestMinMax(LongStream.iterate(0L, n -> n).limit(10L));
        for (count = 1; count < 10; ++count) {
            TestMinMax.runTestMinMax(LongStream.iterate(1L, n -> n + 1L).limit(count));
        }
        for (count = 1; count < 10; ++count) {
            TestMinMax.runTestMinMax(LongStream.iterate(0L, _dummy -> ThreadLocalRandom.current().nextLong()).limit(count));
        }
    }

    static void runTestMinMax(LongStream stream) {
        List list = stream.collect(ArrayList::new, List::add, List::addAll);
        LongMinMax longMinMax = TestMinMax.toLongStream(list).collect(LongMinMax::new, LongMinMax::accumulate, LongMinMax::combine);
        if (longMinMax.isInitialized()) {
            Assertions.assertEquals((long)TestMinMax.toLongStream(list).min().getAsLong(), (long)longMinMax.getMin());
            Assertions.assertEquals((long)TestMinMax.toLongStream(list).max().getAsLong(), (long)longMinMax.getMax());
        } else {
            Assertions.assertEquals((Object)OptionalLong.empty(), (Object)TestMinMax.toLongStream(list).min());
            Assertions.assertEquals((Object)OptionalLong.empty(), (Object)TestMinMax.toLongStream(list).max());
        }
    }

    static LongStream toLongStream(List<Long> list) {
        return list.stream().mapToLong(Long::longValue);
    }
}

