/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.apache.ratis.BaseTest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.PeerProxyMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;

public class TestPeerProxyMap
extends BaseTest {
    @Test
    @Timeout(value=10L)
    public void testCloseDeadLock() throws Exception {
        PeerProxyMap map = new PeerProxyMap("test", x$0 -> new DummyProxy((RaftPeer)x$0));
        RaftPeerId id = RaftPeerId.valueOf((String)"s0");
        RaftPeer peer = RaftPeer.newBuilder().setId(id).build();
        map.computeIfAbsent(peer);
        DummyProxy proxy = (DummyProxy)map.getProxy(id);
        Thread t = new Thread(() -> {
            DummyProxy dummyProxy = proxy;
            synchronized (dummyProxy) {
                this.LOG.info("Acquired lock");
                try {
                    HUNDRED_MILLIS.sleep();
                    this.LOG.info("Try getProxy");
                    DummyProxy newProxy = (DummyProxy)map.getProxy(id);
                    Assertions.assertNotSame((Object)proxy, (Object)newProxy);
                }
                catch (Exception e) {
                    this.setFirstException(e);
                }
                this.LOG.info("Will release lock");
            }
        });
        t.start();
        map.resetProxy(id);
        t.join();
    }

    @Test
    @Timeout(value=1L)
    public void testStackTrace() {
        RaftPeerId id = RaftPeerId.valueOf((String)"s0");
        RaftPeer peer = RaftPeer.newBuilder().setId(id).build();
        try (PeerProxyMap map = new PeerProxyMap("test", ExceptionProxy::new);){
            ExceptionProxy ignored = (ExceptionProxy)map.computeIfAbsent(peer).get();
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (IOException e) {
            TestPeerProxyMap.assertThrowable((String)"closeProxy", (Throwable)e, AnnotatedConnectException.class, (Logger)this.LOG, (Class[])new Class[]{ConnectException.class});
            Assertions.assertEquals((int)0, (int)e.getStackTrace().length);
        }
    }

    private static class ExceptionProxy
    implements Closeable {
        private final RaftPeer peer;

        ExceptionProxy(RaftPeer peer) {
            this.peer = peer;
        }

        @Override
        public void close() throws IOException {
            throw new AnnotatedConnectException(new ConnectException("Failed to connect to " + this.peer.getId()), null);
        }

        public String toString() {
            return this.peer.getId().toString();
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        private static final long serialVersionUID = 3901958112696433556L;

        AnnotatedConnectException(ConnectException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + remoteAddress);
            this.initCause(exception);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    class DummyProxy
    implements Closeable {
        private final RaftPeer peer;

        DummyProxy(RaftPeer peer) {
            this.peer = peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TestPeerProxyMap.this.LOG.info("{}: close before lock", (Object)this);
            DummyProxy dummyProxy = this;
            synchronized (dummyProxy) {
                TestPeerProxyMap.this.LOG.info("{}: close in lock", (Object)this);
            }
        }

        public String toString() {
            return this.peer.toString();
        }
    }
}

