/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ratis.BaseTest;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Preconditions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestPreconditions
extends BaseTest {
    @Test
    @Timeout(value=1L)
    public void testAssertUnique() {
        Set empty = Collections.emptySet();
        Preconditions.assertUnique(empty);
        Preconditions.assertUnique(empty, empty);
        Set<Integer> one = Collections.singleton(1);
        Preconditions.assertUnique(one);
        Preconditions.assertUnique(empty, one);
        this.testFailureCase("add [1] to [1]", () -> Preconditions.assertUnique((Iterable)one, (Iterable)one), IllegalStateException.class, new Class[0]);
        List<Integer> three = Arrays.asList(1, 2, 3);
        this.testFailureCase("add [1, 2, 3] to [1]", () -> Preconditions.assertUnique((Iterable)three, (Iterable)one), IllegalStateException.class, new Class[0]);
        this.testFailureCase("add [1] to [1, 2, 3]", () -> Preconditions.assertUnique((Iterable)one, (Iterable)three), IllegalStateException.class, new Class[0]);
        List<Integer> duplicated = Arrays.asList(3, 2, 3);
        this.testFailureCase("check [3, 2, 3]", () -> Preconditions.assertUnique((Iterable)duplicated), IllegalStateException.class, new Class[0]);
        this.testFailureCase("add [1] to [3, 2, 3]", () -> Preconditions.assertUnique((Iterable)duplicated, (Iterable)one), IllegalStateException.class, new Class[0]);
        this.testFailureCase("add [3, 2, 3] to [1]", () -> Preconditions.assertUnique((Iterable)one, (Iterable)duplicated), IllegalStateException.class, new Class[0]);
        Preconditions.assertUnique(three, Arrays.asList(4, 5, 6));
    }

    @Test
    @Timeout(value=1L)
    public void testAssertNull() {
        HashMap map = new HashMap();
        String key = "abc1234";
        CollectionUtils.putNew((Object)"abc1234", (Object)"abc1234", map, () -> "m");
        Preconditions.assertTrue((boolean)map.containsKey("abc1234"));
        Throwable e = this.testFailureCase("put abc1234 again", () -> {
            String cfr_ignored_0 = (String)CollectionUtils.putNew((Object)"abc1234", (Object)"abc1234", (Map)map, () -> "m");
        }, IllegalStateException.class, new Class[0]);
        Preconditions.assertTrue((boolean)e.getMessage().contains("abc1234"));
    }
}

