/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.util.ReferenceCountedObject;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestReferenceCountedObject {
    static void assertValues(AtomicInteger retained, int expectedRetained, AtomicInteger released, int expectedReleased) {
        Assertions.assertEquals((int)expectedRetained, (int)retained.get(), (String)"retained");
        Assertions.assertEquals((int)expectedReleased, (int)released.get(), (String)"retained");
    }

    static void assertRelease(ReferenceCountedObject<?> ref, AtomicInteger retained, int expectedRetained, AtomicInteger released, int expectedReleased) {
        boolean returned = ref.release();
        TestReferenceCountedObject.assertValues(retained, expectedRetained, released, expectedReleased);
        Assertions.assertEquals((Object)(expectedRetained == expectedReleased ? 1 : 0), (Object)returned);
    }

    @Test
    @Timeout(value=1L)
    public void testWrap() {
        String value = "testWrap";
        AtomicInteger retained = new AtomicInteger();
        AtomicInteger released = new AtomicInteger();
        ReferenceCountedObject ref = ReferenceCountedObject.wrap((Object)"testWrap", retained::getAndIncrement, released::getAndIncrement);
        TestReferenceCountedObject.assertValues(retained, 0, released, 0);
        try {
            ref.get();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        TestReferenceCountedObject.assertValues(retained, 0, released, 0);
        Assertions.assertEquals((Object)"testWrap", (Object)ref.retain());
        TestReferenceCountedObject.assertValues(retained, 1, released, 0);
        try (UncheckedAutoCloseableSupplier auto = ref.retainAndReleaseOnClose();){
            String got = (String)auto.get();
            Assertions.assertEquals((Object)"testWrap", (Object)got);
            Assertions.assertSame((Object)got, (Object)auto.get());
            TestReferenceCountedObject.assertValues(retained, 2, released, 0);
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        TestReferenceCountedObject.assertValues(retained, 2, released, 1);
        UncheckedAutoCloseableSupplier notClosing = ref.retainAndReleaseOnClose();
        Assertions.assertEquals((Object)"testWrap", (Object)notClosing.get());
        TestReferenceCountedObject.assertValues(retained, 3, released, 1);
        TestReferenceCountedObject.assertRelease(ref, retained, 3, released, 2);
        UncheckedAutoCloseableSupplier auto = ref.retainAndReleaseOnClose();
        Assertions.assertEquals((Object)"testWrap", (Object)auto.get());
        TestReferenceCountedObject.assertValues(retained, 4, released, 2);
        auto.close();
        TestReferenceCountedObject.assertValues(retained, 4, released, 3);
        auto.close();
        TestReferenceCountedObject.assertValues(retained, 4, released, 3);
        TestReferenceCountedObject.assertRelease(ref, retained, 4, released, 4);
        try {
            ref.get();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try {
            ref.retain();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try (UncheckedAutoCloseableSupplier ignore = ref.retainAndReleaseOnClose();){
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try {
            ref.release();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
    }

    @Test
    @Timeout(value=1L)
    public void testReleaseWithoutRetaining() {
        ReferenceCountedObject ref = ReferenceCountedObject.wrap((Object)"");
        try {
            ref.release();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try {
            ref.get();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try {
            ref.retain();
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
        try (UncheckedAutoCloseableSupplier ignore = ref.retainAndReleaseOnClose();){
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            e.printStackTrace(System.out);
        }
    }
}

