/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.TimeoutException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.util.ResourceSemaphore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestResourceSemaphore
extends BaseTest {
    @Test
    @Timeout(value=5L)
    public void testGroup() throws InterruptedException, TimeoutException {
        boolean FAILED_IN_ELEMENT_LIMIT = false;
        boolean FAILED_IN_BYTE_SIZE_LIMIT = true;
        ResourceSemaphore.Group g = new ResourceSemaphore.Group(new int[]{3, 1});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        TestResourceSemaphore.assertAcquire(g, -1, 1, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, 1, 1, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, 1, 0, 1);
        TestResourceSemaphore.assertUsed(g, 1, 1);
        TestResourceSemaphore.assertAcquire(g, -1, 1, 0);
        TestResourceSemaphore.assertUsed(g, 2, 1);
        TestResourceSemaphore.assertAcquire(g, -1, 1, 0);
        TestResourceSemaphore.assertUsed(g, 3, 1);
        TestResourceSemaphore.assertAcquire(g, 0, 1, 0);
        TestResourceSemaphore.assertUsed(g, 3, 1);
        g.release(new int[]{1, 1});
        TestResourceSemaphore.assertUsed(g, 2, 0);
        g.release(new int[]{2, 0});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        g.release(new int[]{0, 0});
        TestResourceSemaphore.assertUsed(g, 0, 0);
        g.acquire(new int[]{1, 1});
        TestResourceSemaphore.assertUsed(g, 1, 1);
        Thread t = new Thread(TestResourceSemaphore.acquire(g, 1, 1));
        t.start();
        RaftTestUtil.waitFor(() -> Thread.State.WAITING == t.getState(), (int)100, (int)1000);
        TestResourceSemaphore.assertUsed(g, 2, 1);
        g.release(new int[]{0, 1});
        RaftTestUtil.waitFor(() -> Thread.State.TERMINATED == t.getState(), (int)100, (int)1000);
        TestResourceSemaphore.assertUsed(g, 2, 1);
        Thread t1 = new Thread(TestResourceSemaphore.acquire(g, 1, 1));
        t1.start();
        RaftTestUtil.waitFor(() -> Thread.State.WAITING == t1.getState(), (int)100, (int)1000);
        TestResourceSemaphore.assertUsed(g, 3, 1);
        t1.interrupt();
        RaftTestUtil.waitFor(() -> Thread.State.TERMINATED == t1.getState(), (int)100, (int)1000);
        TestResourceSemaphore.assertUsed(g, 2, 1);
        g.release(new int[]{2, 1});
        this.testFailureCase("release over limit-0", () -> g.release(new int[]{1, 0}), IllegalStateException.class, new Class[0]);
        this.testFailureCase("release over limit-1", () -> g.release(new int[]{0, 1}), IllegalStateException.class, new Class[0]);
    }

    static void assertUsed(ResourceSemaphore.Group g, int ... expected) {
        Assertions.assertEquals((int)expected.length, (int)g.resourceSize());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((int)expected[i], (int)g.get(i).used());
        }
    }

    static void assertAcquire(ResourceSemaphore.Group g, int expected, int ... permits) {
        int computed = g.tryAcquire(permits);
        Assertions.assertEquals((int)expected, (int)computed);
    }

    static Runnable acquire(ResourceSemaphore.Group g, int ... permits) {
        return () -> {
            try {
                g.acquire(permits);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        };
    }
}

