/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestTimeDuration {
    public TestTimeDuration() {
        Slf4jUtils.setLogLevel((Logger)TimeDuration.LOG, (Level)Level.DEBUG);
    }

    @Test
    @Timeout(value=1L)
    public void testAbbreviation() {
        Arrays.asList(TimeUnit.values()).forEach(a -> Assertions.assertNotNull((Object)TimeDuration.Abbreviation.valueOf((String)a.name())));
        Assertions.assertEquals((int)TimeUnit.values().length, (int)TimeDuration.Abbreviation.values().length);
        List allSymbols = Arrays.stream(TimeDuration.Abbreviation.values()).map(TimeDuration.Abbreviation::getSymbols).flatMap(Collection::stream).collect(Collectors.toList());
        Arrays.asList(TimeUnit.values()).forEach(unit -> allSymbols.stream().map(s -> "0" + s).forEach(s -> Assertions.assertEquals((long)0L, (long)TimeDuration.parse((String)s, (TimeUnit)((Object)unit)), (String)s)));
    }

    @Test
    @Timeout(value=1L)
    public void testParse() {
        Assertions.assertEquals((long)1L, (long)TimeDuration.parse((String)"1_000_000 ns", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10L, (long)TimeDuration.parse((String)"10_000_000 nanos", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)100L, (long)TimeDuration.parse((String)"100_000_000 nanosecond", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1000L, (long)TimeDuration.parse((String)"1_000_000_000 nanoseconds", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1L, (long)TimeDuration.parse((String)"1000 us", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10L, (long)TimeDuration.parse((String)"10000 \u03bcs", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)100L, (long)TimeDuration.parse((String)"100000 micros", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1000L, (long)TimeDuration.parse((String)"1000000 microsecond", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10000L, (long)TimeDuration.parse((String)"10000000 microseconds", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1L, (long)TimeDuration.parse((String)"1 ms", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10L, (long)TimeDuration.parse((String)"10 msec", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)100L, (long)TimeDuration.parse((String)"100 millis", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1000L, (long)TimeDuration.parse((String)"1000 millisecond", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10000L, (long)TimeDuration.parse((String)"10000 milliseconds", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1000L, (long)TimeDuration.parse((String)"1 s", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)10000L, (long)TimeDuration.parse((String)"10 sec", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)100000L, (long)TimeDuration.parse((String)"100 second", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)1000000L, (long)TimeDuration.parse((String)"1000 seconds", (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)60L, (long)TimeDuration.parse((String)"1 m", (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((long)600L, (long)TimeDuration.parse((String)"10 min", (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((long)6000L, (long)TimeDuration.parse((String)"100 minutes", (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((long)60000L, (long)TimeDuration.parse((String)"1000 minutes", (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((long)60L, (long)TimeDuration.parse((String)"1 h", (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((long)600L, (long)TimeDuration.parse((String)"10 hr", (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((long)6000L, (long)TimeDuration.parse((String)"100 hour", (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((long)60000L, (long)TimeDuration.parse((String)"1000 hours", (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((long)24L, (long)TimeDuration.parse((String)"1 d", (TimeUnit)TimeUnit.HOURS));
        Assertions.assertEquals((long)240L, (long)TimeDuration.parse((String)"10 day", (TimeUnit)TimeUnit.HOURS));
        Assertions.assertEquals((long)2400L, (long)TimeDuration.parse((String)"100 days", (TimeUnit)TimeUnit.HOURS));
    }

    @Test
    @Timeout(value=1L)
    public void testRoundUp() {
        long nanosPerSecond = 1000000000L;
        TimeDuration oneSecond = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertEquals((long)-1000000000L, (long)oneSecond.roundUpNanos(-1000000001L));
        Assertions.assertEquals((long)-1000000000L, (long)oneSecond.roundUpNanos(-1000000000L));
        Assertions.assertEquals((long)0L, (long)oneSecond.roundUpNanos(-999999999L));
        Assertions.assertEquals((long)0L, (long)oneSecond.roundUpNanos(-1L));
        Assertions.assertEquals((long)0L, (long)oneSecond.roundUpNanos(0L));
        Assertions.assertEquals((long)1000000000L, (long)oneSecond.roundUpNanos(1L));
        Assertions.assertEquals((long)1000000000L, (long)oneSecond.roundUpNanos(999999999L));
        Assertions.assertEquals((long)1000000000L, (long)oneSecond.roundUpNanos(1000000000L));
        Assertions.assertEquals((long)2000000000L, (long)oneSecond.roundUpNanos(1000000001L));
    }

    @Test
    @Timeout(value=1L)
    public void testTo() {
        TimeDuration oneSecond = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
        TestTimeDuration.assertTo(1000L, "1000ms", oneSecond, TimeUnit.MILLISECONDS);
        TimeDuration nanos = TestTimeDuration.assertTo(1000000000L, "1000000000ns", oneSecond, TimeUnit.NANOSECONDS);
        TestTimeDuration.assertTo(1000L, "1000ms", nanos, TimeUnit.MILLISECONDS);
        TestTimeDuration.assertTo(0L, "0.0167min", oneSecond, TimeUnit.MINUTES);
        TestTimeDuration.assertTo(0L, "0.0167min", nanos, TimeUnit.MINUTES);
        TimeDuration millis = TimeDuration.valueOf((long)1999L, (TimeUnit)TimeUnit.MILLISECONDS);
        TestTimeDuration.assertTo(1L, "1.9990s", millis, TimeUnit.SECONDS);
        TestTimeDuration.assertTo(0L, "0.0333min", millis, TimeUnit.MINUTES);
    }

    static TimeDuration assertTo(long expected, String expectedString, TimeDuration timeDuration, TimeUnit toUnit) {
        TimeDuration computed = timeDuration.to(toUnit);
        Assertions.assertEquals((long)expected, (long)computed.getDuration());
        Assertions.assertEquals((Object)((Object)toUnit), (Object)((Object)computed.getUnit()));
        Assertions.assertEquals((Object)expectedString, (Object)timeDuration.toString(toUnit, 4));
        return computed;
    }

    @Test
    @Timeout(value=1L)
    public void testAddAndSubtract() {
        TimeDuration oneSecond = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
        TimeDuration tenSecond = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS);
        TimeDuration d = oneSecond.subtract(oneSecond);
        Assertions.assertEquals((long)0L, (long)d.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)d.getUnit()));
        TimeDuration sum = d.add(oneSecond);
        Assertions.assertEquals((long)1L, (long)sum.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)sum.getUnit()));
        d = tenSecond.subtract(oneSecond);
        Assertions.assertEquals((long)9L, (long)d.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)d.getUnit()));
        sum = d.add(oneSecond);
        Assertions.assertEquals((long)10L, (long)sum.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)sum.getUnit()));
        d = oneSecond.subtract(tenSecond);
        Assertions.assertEquals((long)-9L, (long)d.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)d.getUnit()));
        sum = d.add(tenSecond);
        Assertions.assertEquals((long)1L, (long)sum.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)sum.getUnit()));
        TimeDuration oneMS = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        TimeDuration d2 = oneSecond.subtract(oneMS);
        Assertions.assertEquals((long)999L, (long)d2.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)d2.getUnit()));
        TimeDuration sum2 = d2.add(oneSecond);
        Assertions.assertEquals((long)1999L, (long)sum2.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)sum2.getUnit()));
        d2 = oneMS.subtract(oneSecond);
        Assertions.assertEquals((long)-999L, (long)d2.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)d2.getUnit()));
        sum2 = d2.add(oneSecond);
        Assertions.assertEquals((long)1L, (long)sum2.getDuration());
        Assertions.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)sum2.getUnit()));
    }

    @Test
    @Timeout(value=1L)
    public void testNegate() {
        TestTimeDuration.assertNegate(0L);
        TestTimeDuration.assertNegate(1L);
        TestTimeDuration.assertNegate(-1L);
        TestTimeDuration.assertNegate(Long.MAX_VALUE);
        Assertions.assertEquals((Object)TimeDuration.valueOf((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS), (Object)TimeDuration.valueOf((long)Long.MIN_VALUE, (TimeUnit)TimeUnit.SECONDS).negate());
    }

    private static void assertNegate(long n) {
        Assertions.assertEquals((Object)TimeDuration.valueOf((long)(-n), (TimeUnit)TimeUnit.SECONDS), (Object)TimeDuration.valueOf((long)n, (TimeUnit)TimeUnit.SECONDS).negate());
        Assertions.assertEquals((Object)TimeDuration.valueOf((long)n, (TimeUnit)TimeUnit.SECONDS), (Object)TimeDuration.valueOf((long)(-n), (TimeUnit)TimeUnit.SECONDS).negate());
    }

    @Test
    @Timeout(value=1L)
    public void testMultiply() {
        TestTimeDuration.assertMultiply(0.0, TimeDuration.ONE_SECOND, TimeDuration.valueOf((long)0L, (TimeUnit)TimeUnit.SECONDS));
        TestTimeDuration.assertMultiply(0.001, TimeDuration.ONE_SECOND, TimeDuration.ONE_MILLISECOND);
        TestTimeDuration.assertMultiply(1.6666666666666667E-5, TimeDuration.ONE_MINUTE, TimeDuration.ONE_MILLISECOND);
        TestTimeDuration.assertMultiply(100.0, TimeDuration.valueOf((long)0xCCCCCCCCCCCCCCCL, (TimeUnit)TimeUnit.NANOSECONDS), TimeDuration.valueOf((long)92233720368547758L, (TimeUnit)TimeUnit.MICROSECONDS));
        TestTimeDuration.assertMultiply(1.0E-30, TimeDuration.valueOf((long)1000000000000000000L, (TimeUnit)TimeUnit.DAYS), TimeDuration.valueOf((long)86L, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    private static void assertMultiply(double multiplier, TimeDuration t, TimeDuration expected) {
        TestTimeDuration.assertMultiply(t, multiplier, expected);
        TestTimeDuration.assertMultiply(t.negate(), -multiplier, expected);
        TestTimeDuration.assertMultiply(t.negate(), multiplier, expected.negate());
        TestTimeDuration.assertMultiply(t, -multiplier, expected.negate());
    }

    private static void assertMultiply(TimeDuration t, double multiplier, TimeDuration expected) {
        TimeDuration computed = t.multiply(multiplier);
        TimeDuration.LOG.info("assertMultiply: {} x {} = {} ?= {}\n\n", new Object[]{t, multiplier, computed, expected});
        Assertions.assertEquals((Object)((Object)expected.getUnit()), (Object)((Object)computed.getUnit()));
        long d = Math.abs(computed.getDuration() - expected.getDuration());
        Assertions.assertTrue(((double)d <= (double)Math.abs(expected.getDuration()) * 0.001 ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=1L)
    public void testHigherLower() {
        TimeUnit[] units = new TimeUnit[]{TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS};
        for (int i = 1; i < units.length; ++i) {
            TestTimeDuration.assertHigherLower(units[i - 1], units[i]);
        }
        Assertions.assertSame((Object)((Object)TimeUnit.NANOSECONDS), (Object)((Object)TimeDuration.lowerUnit((TimeUnit)TimeUnit.NANOSECONDS)));
        Assertions.assertSame((Object)((Object)TimeUnit.DAYS), (Object)((Object)TimeDuration.higherUnit((TimeUnit)TimeUnit.DAYS)));
    }

    @Test
    @Timeout(value=1L)
    public void testCompareTo() {
        TestTimeDuration.assertTimeDurationCompareTo(TimeDuration.ONE_MINUTE, TimeDuration.ONE_SECOND);
        TimeDuration fifteenSecond = TimeDuration.valueOf((long)15L, (TimeUnit)TimeUnit.SECONDS);
        TestTimeDuration.assertTimeDurationCompareTo(TimeDuration.ONE_DAY, fifteenSecond);
        TestTimeDuration.assertTimeDurationEquals(TimeDuration.ONE_MINUTE, fifteenSecond.multiply(4.0));
        TestTimeDuration.assertTimeDurationEquals(TimeDuration.ONE_DAY, TimeDuration.ONE_MINUTE.multiply(60.0).multiply(24.0));
    }

    static void assertTimeDurationEquals(TimeDuration left, TimeDuration right) {
        Assertions.assertEquals((int)0, (int)left.compareTo(right));
        Assertions.assertEquals((int)0, (int)right.compareTo(left));
        Assertions.assertEquals((Object)left, (Object)right);
        Assertions.assertEquals((Object)right, (Object)left);
    }

    static void assertTimeDurationCompareTo(TimeDuration larger, TimeDuration smaller) {
        Assertions.assertTrue((smaller.compareTo(larger) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((larger.compareTo(smaller) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)smaller, (Object)TimeDuration.min((TimeDuration)smaller, (TimeDuration)larger));
        Assertions.assertEquals((Object)smaller, (Object)TimeDuration.min((TimeDuration)larger, (TimeDuration)smaller));
        Assertions.assertEquals((Object)larger, (Object)TimeDuration.max((TimeDuration)smaller, (TimeDuration)larger));
        Assertions.assertEquals((Object)larger, (Object)TimeDuration.max((TimeDuration)larger, (TimeDuration)smaller));
        TimeDuration diff = larger.add(smaller.negate());
        Assertions.assertTrue((boolean)diff.isPositive());
        Assertions.assertTrue((boolean)diff.isNonNegative());
        Assertions.assertFalse((boolean)diff.isNegative());
        Assertions.assertFalse((boolean)diff.isNonPositive());
    }

    private static void assertHigherLower(TimeUnit lower, TimeUnit higher) {
        Assertions.assertSame((Object)((Object)lower), (Object)((Object)TimeDuration.lowerUnit((TimeUnit)higher)));
        Assertions.assertSame((Object)((Object)higher), (Object)((Object)TimeDuration.higherUnit((TimeUnit)lower)));
    }
}

