/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.ratis.BaseTest;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestTimeoutScheduler
extends BaseTest {
    public TestTimeoutScheduler() {
        Slf4jUtils.setLogLevel((Logger)TimeoutScheduler.LOG, (Level)Level.TRACE);
    }

    @Test
    @Timeout(value=1L)
    public void testSingleTask() throws Exception {
        TimeoutScheduler scheduler = TimeoutScheduler.newInstance();
        TimeDuration grace = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        scheduler.setGracePeriod(grace);
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        ErrorHandler errorHandler = new ErrorHandler();
        AtomicBoolean fired = new AtomicBoolean(false);
        scheduler.onTimeout(TimeDuration.valueOf((long)250L, (TimeUnit)TimeUnit.MILLISECONDS), () -> {
            Assertions.assertFalse((boolean)fired.get());
            fired.set(true);
        }, (Consumer)errorHandler);
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)fired.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)fired.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired.get());
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        errorHandler.assertNoError();
        scheduler.setGracePeriod(grace);
    }

    @Test
    @Timeout(value=1L)
    public void testMultipleTasks() throws Exception {
        TimeoutScheduler scheduler = TimeoutScheduler.newInstance();
        TimeDuration grace = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        scheduler.setGracePeriod(grace);
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        ErrorHandler errorHandler = new ErrorHandler();
        AtomicBoolean[] fired = new AtomicBoolean[3];
        for (int i = 0; i < fired.length; ++i) {
            AtomicBoolean f = fired[i] = new AtomicBoolean(false);
            scheduler.onTimeout(TimeDuration.valueOf((long)(100 * i + 50), (TimeUnit)TimeUnit.MILLISECONDS), () -> {
                Assertions.assertFalse((boolean)f.get());
                f.set(true);
            }, (Consumer)errorHandler);
            Assertions.assertTrue((boolean)scheduler.hasScheduler());
        }
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired[0].get());
        Assertions.assertFalse((boolean)fired[1].get());
        Assertions.assertFalse((boolean)fired[2].get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired[0].get());
        Assertions.assertTrue((boolean)fired[1].get());
        Assertions.assertFalse((boolean)fired[2].get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired[0].get());
        Assertions.assertTrue((boolean)fired[1].get());
        Assertions.assertTrue((boolean)fired[2].get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired[0].get());
        Assertions.assertTrue((boolean)fired[1].get());
        Assertions.assertTrue((boolean)fired[2].get());
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        errorHandler.assertNoError();
    }

    @Test
    @Timeout(value=1L)
    public void testExtendingGracePeriod() throws Exception {
        TimeoutScheduler scheduler = TimeoutScheduler.newInstance();
        TimeDuration grace = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        scheduler.setGracePeriod(grace);
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        ErrorHandler errorHandler = new ErrorHandler();
        AtomicBoolean fired = new AtomicBoolean(false);
        scheduler.onTimeout(TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS), () -> {
            Assertions.assertFalse((boolean)fired.get());
            fired.set(true);
        }, (Consumer)errorHandler);
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)fired.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        AtomicBoolean fired2 = new AtomicBoolean(false);
        scheduler.onTimeout(TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS), () -> {
            Assertions.assertFalse((boolean)fired2.get());
            fired2.set(true);
        }, (Consumer)errorHandler);
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)fired2.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired2.get());
        Assertions.assertTrue((boolean)scheduler.hasScheduler());
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)fired2.get());
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        errorHandler.assertNoError();
    }

    @Test
    @Timeout(value=1L)
    public void testRestartingScheduler() throws Exception {
        TimeoutScheduler scheduler = TimeoutScheduler.newInstance();
        TimeDuration grace = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        scheduler.setGracePeriod(grace);
        Assertions.assertFalse((boolean)scheduler.hasScheduler());
        ErrorHandler errorHandler = new ErrorHandler();
        for (int i = 0; i < 2; ++i) {
            AtomicBoolean fired = new AtomicBoolean(false);
            scheduler.onTimeout(TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS), () -> {
                Assertions.assertFalse((boolean)fired.get());
                fired.set(true);
            }, (Consumer)errorHandler);
            Assertions.assertTrue((boolean)scheduler.hasScheduler());
            Thread.sleep(100L);
            Assertions.assertFalse((boolean)fired.get());
            Assertions.assertTrue((boolean)scheduler.hasScheduler());
            Thread.sleep(100L);
            Assertions.assertTrue((boolean)fired.get());
            Assertions.assertTrue((boolean)scheduler.hasScheduler());
            Thread.sleep(100L);
            Assertions.assertTrue((boolean)fired.get());
            Assertions.assertFalse((boolean)scheduler.hasScheduler());
        }
        errorHandler.assertNoError();
    }

    @Test
    @Timeout(value=10L)
    public void testShutdown() throws Exception {
        TimeoutScheduler scheduler = TimeoutScheduler.newInstance();
        Assertions.assertEquals((Object)TimeoutScheduler.DEFAULT_GRACE_PERIOD, (Object)scheduler.getGracePeriod());
        ErrorHandler errorHandler = new ErrorHandler();
        int numTasks = 100;
        for (int i = 0; i < 100; ++i) {
            scheduler.onTimeout(HUNDRED_MILLIS, () -> {}, (Consumer)errorHandler);
        }
        HUNDRED_MILLIS.sleep();
        HUNDRED_MILLIS.sleep();
        JavaUtils.attempt(() -> Assertions.assertEquals((int)1, (int)scheduler.getTaskCount()), (int)10, (TimeDuration)HUNDRED_MILLIS, (String)"only 1 shutdown task is scheduled", (Logger)this.LOG);
        TimeDuration oneMillis = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        for (int i = 0; i < 100; ++i) {
            scheduler.onTimeout(oneMillis, () -> {}, (Consumer)errorHandler);
            oneMillis.sleep();
            oneMillis.sleep();
        }
        HUNDRED_MILLIS.sleep();
        JavaUtils.attempt(() -> Assertions.assertEquals((int)1, (int)scheduler.getTaskCount()), (int)10, (TimeDuration)HUNDRED_MILLIS, (String)"only 1 shutdown task is scheduled", (Logger)this.LOG);
        errorHandler.assertNoError();
    }

    static class ErrorHandler
    implements Consumer<RuntimeException> {
        private final AtomicBoolean hasError = new AtomicBoolean(false);

        ErrorHandler() {
        }

        @Override
        public void accept(RuntimeException e) {
            this.hasError.set(true);
            TimeoutScheduler.LOG.error("Failed", (Throwable)e);
        }

        void assertNoError() {
            Assertions.assertFalse((boolean)this.hasError.get());
        }
    }
}

