/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TraditionalBinaryPrefix;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTraditionalBinaryPrefix {
    @Test
    @Timeout(value=1L)
    public void testTraditionalBinaryPrefix() {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            Assertions.assertEquals((long)0L, (long)TraditionalBinaryPrefix.string2long((String)(0 + s)));
            Assertions.assertEquals((long)m, (long)TraditionalBinaryPrefix.string2long((String)(1 + s)));
            m *= 1024L;
        }
        Assertions.assertEquals((long)0L, (long)TraditionalBinaryPrefix.string2long((String)"0"));
        Assertions.assertEquals((long)1024L, (long)TraditionalBinaryPrefix.string2long((String)"1k"));
        Assertions.assertEquals((long)-1024L, (long)TraditionalBinaryPrefix.string2long((String)"-1k"));
        Assertions.assertEquals((long)1259520L, (long)TraditionalBinaryPrefix.string2long((String)"1_230K"));
        Assertions.assertEquals((long)-1259520L, (long)TraditionalBinaryPrefix.string2long((String)"-1_230K"));
        Assertions.assertEquals((long)0x6400000L, (long)TraditionalBinaryPrefix.string2long((String)"100m"));
        Assertions.assertEquals((long)-104857600L, (long)TraditionalBinaryPrefix.string2long((String)"-100M"));
        Assertions.assertEquals((long)956703965184L, (long)TraditionalBinaryPrefix.string2long((String)"891g"));
        Assertions.assertEquals((long)-956703965184L, (long)TraditionalBinaryPrefix.string2long((String)"-891G"));
        Assertions.assertEquals((long)501377302265856L, (long)TraditionalBinaryPrefix.string2long((String)"456t"));
        Assertions.assertEquals((long)-501377302265856L, (long)TraditionalBinaryPrefix.string2long((String)"-456T"));
        Assertions.assertEquals((long)0x28000000000000L, (long)TraditionalBinaryPrefix.string2long((String)"10p"));
        Assertions.assertEquals((long)-11258999068426240L, (long)TraditionalBinaryPrefix.string2long((String)"-10P"));
        Assertions.assertEquals((long)0x1000000000000000L, (long)TraditionalBinaryPrefix.string2long((String)"1e"));
        Assertions.assertEquals((long)-1152921504606846976L, (long)TraditionalBinaryPrefix.string2long((String)"-1E"));
        String tooLargeNumStr = "10e";
        try {
            TraditionalBinaryPrefix.string2long((String)tooLargeNumStr);
            Assertions.fail((String)("Test passed for a number " + tooLargeNumStr + " too large"));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)(tooLargeNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String tooSmallNumStr = "-10e";
        try {
            TraditionalBinaryPrefix.string2long((String)tooSmallNumStr);
            Assertions.fail((String)("Test passed for a number " + tooSmallNumStr + " too small"));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)(tooSmallNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String invalidFormatNumStr = "10kb";
        char invalidPrefix = 'b';
        try {
            TraditionalBinaryPrefix.string2long((String)invalidFormatNumStr);
            Assertions.fail((String)("Test passed for a number " + invalidFormatNumStr + " has invalid format"));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)("Invalid size prefix '" + invalidPrefix + "' in '" + invalidFormatNumStr + "'. Allowed prefixes are k, m, g, t, p, e (case insensitive)"), (Object)e.getMessage());
        }
        Assertions.assertEquals((Object)"0", (Object)TraditionalBinaryPrefix.long2String((long)0L, null, (int)2));
        for (int decimalPlace = 0; decimalPlace < 2; ++decimalPlace) {
            int n = 1;
            while ((long)n < TraditionalBinaryPrefix.KILO.getValue()) {
                Assertions.assertEquals((Object)(n + ""), (Object)TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace));
                Assertions.assertEquals((Object)(-n + ""), (Object)TraditionalBinaryPrefix.long2String((long)(-n), null, (int)decimalPlace));
                ++n;
            }
            Assertions.assertEquals((Object)"1 K", (Object)TraditionalBinaryPrefix.long2String((long)1024L, null, (int)decimalPlace));
            Assertions.assertEquals((Object)"-1 K", (Object)TraditionalBinaryPrefix.long2String((long)-1024L, null, (int)decimalPlace));
        }
        Assertions.assertEquals((Object)"8.00 E", (Object)TraditionalBinaryPrefix.long2String((long)Long.MAX_VALUE, null, (int)2));
        Assertions.assertEquals((Object)"8.00 E", (Object)TraditionalBinaryPrefix.long2String((long)0x7FFFFFFFFFFFFFFEL, null, (int)2));
        Assertions.assertEquals((Object)"-8 E", (Object)TraditionalBinaryPrefix.long2String((long)Long.MIN_VALUE, null, (int)2));
        Assertions.assertEquals((Object)"-8.00 E", (Object)TraditionalBinaryPrefix.long2String((long)-9223372036854775807L, null, (int)2));
        String[] zeros = new String[]{" ", ".0 ", ".00 "};
        for (int decimalPlace = 0; decimalPlace < zeros.length; ++decimalPlace) {
            String trailingZeros = zeros[decimalPlace];
            for (int e = 11; e < 63; ++e) {
                TraditionalBinaryPrefix p = TraditionalBinaryPrefix.values()[e / 10 - 1];
                long n = 1L << e;
                String expected = n / p.getValue() + " " + p.getSymbol();
                Assertions.assertEquals((Object)expected, (Object)TraditionalBinaryPrefix.long2String((long)n, null, (int)2), (String)("n=" + n));
                n = (1L << e) + 1L;
                expected = n / p.getValue() + trailingZeros + p.getSymbol();
                Assertions.assertEquals((Object)expected, (Object)TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace), (String)("n=" + n));
                n = (1L << e) - 1L;
                expected = (n + 1L) / p.getValue() + trailingZeros + p.getSymbol();
                Assertions.assertEquals((Object)expected, (Object)TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace), (String)("n=" + n));
            }
        }
        Assertions.assertEquals((Object)"1.50 K", (Object)TraditionalBinaryPrefix.long2String((long)1536L, null, (int)2));
        Assertions.assertEquals((Object)"1.5 K", (Object)TraditionalBinaryPrefix.long2String((long)1536L, null, (int)1));
        Assertions.assertEquals((Object)"1.50 M", (Object)TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)2));
        Assertions.assertEquals((Object)"2 M", (Object)TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)0));
        Assertions.assertEquals((Object)"3 G", (Object)TraditionalBinaryPrefix.long2String((long)0xC0000000L, null, (int)2));
        Assertions.assertEquals((Object)"0 B", (Object)TestTraditionalBinaryPrefix.byteDescription(0L));
        Assertions.assertEquals((Object)"-100 B", (Object)TestTraditionalBinaryPrefix.byteDescription(-100L));
        Assertions.assertEquals((Object)"1 KB", (Object)TestTraditionalBinaryPrefix.byteDescription(1024L));
        Assertions.assertEquals((Object)"1.50 KB", (Object)TestTraditionalBinaryPrefix.byteDescription(1536L));
        Assertions.assertEquals((Object)"1.50 MB", (Object)TestTraditionalBinaryPrefix.byteDescription(0x180000L));
        Assertions.assertEquals((Object)"3 GB", (Object)TestTraditionalBinaryPrefix.byteDescription(0xC0000000L));
    }

    private static String byteDescription(long len) {
        return TraditionalBinaryPrefix.long2String((long)len, (String)"B", (int)2);
    }

    @Test
    @Timeout(value=1L)
    public void testUnderscore() {
        SizeInBytes value = SizeInBytes.valueOf((String)"1_000_000_000_000_000");
        Assertions.assertEquals((long)1000000000000000L, (long)value.getSize());
    }
}

