/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.com.google.flatbuffers.grpc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.ratis.thirdparty.com.google.flatbuffers.Table;
import org.apache.ratis.thirdparty.io.grpc.Drainable;
import org.apache.ratis.thirdparty.io.grpc.KnownLength;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;

public class FlatbuffersUtils {
    public static <T extends Table> MethodDescriptor.Marshaller<T> marshaller(final Class<T> clazz, final FBExtactor<T> extractor) {
        return new MethodDescriptor.ReflectableMarshaller<T>(){

            @Override
            public Class<T> getMessageClass() {
                return clazz;
            }

            @Override
            public InputStream stream(T value) {
                return new FBInputStream(((Table)value).getByteBuffer());
            }

            @Override
            public T parse(InputStream stream) {
                try {
                    return extractor.extract(stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static class FBInputStream
    extends InputStream
    implements Drainable,
    KnownLength {
        private final ByteBuffer buffer;
        private final int size;
        @Nullable
        private ByteArrayInputStream inputStream;

        FBInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
            this.size = buffer.remaining();
        }

        private void makeStreamIfNotAlready() {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(this.buffer.array(), this.buffer.position(), this.size);
            }
        }

        @Override
        public int drainTo(OutputStream target) throws IOException {
            target.write(this.buffer.array(), this.buffer.position(), this.size);
            return this.size;
        }

        @Override
        public int read() throws IOException {
            this.makeStreamIfNotAlready();
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.makeStreamIfNotAlready();
            if (this.inputStream == null) {
                if (len >= this.size) {
                    System.arraycopy(this.buffer.array(), this.buffer.position(), b, off, this.size);
                    return this.size;
                }
                this.makeStreamIfNotAlready();
                return this.inputStream.read(b, off, len);
            }
            return this.inputStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream == null ? this.size : this.inputStream.available();
        }
    }

    public static abstract class FBExtactor<T extends Table> {
        T extract(InputStream stream) throws IOException {
            if (stream instanceof KnownLength) {
                int size = stream.available();
                ByteBuffer buffer = ByteBuffer.allocate(size);
                stream.read(buffer.array());
                return this.extract(buffer);
            }
            throw new RuntimeException("The class " + stream.getClass().getCanonicalName() + " does not extend from KnownLength ");
        }

        public abstract T extract(ByteBuffer var1);
    }
}

