/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.netty.handler.ssl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import org.apache.ratis.thirdparty.io.netty.util.internal.ObjectUtil;

public final class FingerprintTrustManagerFactoryBuilder {
    private final String algorithm;
    private final List<String> fingerprints = new ArrayList<String>();

    FingerprintTrustManagerFactoryBuilder(String algorithm) {
        this.algorithm = ObjectUtil.checkNotNull(algorithm, "algorithm");
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(CharSequence ... fingerprints) {
        ObjectUtil.checkNotNull(fingerprints, "fingerprints");
        return this.fingerprints(Arrays.asList(fingerprints));
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(Iterable<? extends CharSequence> fingerprints) {
        ObjectUtil.checkNotNull(fingerprints, "fingerprints");
        for (CharSequence charSequence : fingerprints) {
            if (charSequence == null) {
                throw new IllegalArgumentException("One of the fingerprints is null");
            }
            this.fingerprints.add(charSequence.toString());
        }
        return this;
    }

    public FingerprintTrustManagerFactory build() {
        if (this.fingerprints.isEmpty()) {
            throw new IllegalStateException("No fingerprints provided");
        }
        return new FingerprintTrustManagerFactory(this.algorithm, FingerprintTrustManagerFactory.toFingerprintArray(this.fingerprints));
    }
}

