/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferEncodingStream;
import org.acplt.oncrpc.XdrHttpDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class OncRpcHttpClient
extends OncRpcClient {
    private String hostname;
    private int httpPort;
    private String cgiHandlerPath;
    private String oncrpcHostname;
    private int oncrpcProtocol;
    private HttpClientConnection httpClient;
    private XdrBufferEncodingStream sendingXdr;
    private XdrHttpDecodingStream receivingXdr;

    public OncRpcHttpClient(String hostname, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port) throws OncRpcException, IOException {
        this(hostname, 80, cgiHandlerPath, oncrpcHostname, program, version, port, 6);
    }

    public OncRpcHttpClient(String hostname, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        this(hostname, 80, cgiHandlerPath, oncrpcHostname, program, version, port, protocol);
    }

    public OncRpcHttpClient(String hostname, int httpPort, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        super(null, program, version, -1, -42);
        this.httpPort = httpPort;
        this.cgiHandlerPath = cgiHandlerPath;
        this.oncrpcHostname = oncrpcHostname;
        this.oncrpcProtocol = protocol;
        this.port = port;
        this.hostname = hostname;
        this.httpClient = new HttpClientConnection(hostname, httpPort);
        this.sendingXdr = new XdrBufferEncodingStream(8192);
        this.receivingXdr = new XdrHttpDecodingStream(this.httpClient);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws OncRpcException {
        Object var2_6;
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
        if (this.sendingXdr != null) {
            try {
                try {
                    this.sendingXdr.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.sendingXdr = null;
                throw throwable;
            }
            {
                var2_6 = null;
                this.sendingXdr = null;
            }
        }
        if (this.receivingXdr == null) return;
        try {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            var2_6 = null;
            this.receivingXdr = null;
            throw throwable;
        }
        {
            var2_6 = null;
            this.receivingXdr = null;
            return;
        }
    }

    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        int refreshesLeft = 1;
        while (refreshesLeft >= 0) {
            block18: {
                this.nextXid();
                OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
                OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
                try {
                    this.sendingXdr.beginEncoding(null, 0);
                    callHeader.xdrEncode(this.sendingXdr);
                    params.xdrEncode(this.sendingXdr);
                    this.sendingXdr.endEncoding();
                }
                catch (IOException e) {
                    throw new OncRpcException(3, e.getLocalizedMessage());
                }
                StringBuffer prefix = new StringBuffer(512);
                prefix.append("CALL ");
                prefix.append(this.oncrpcHostname);
                if (this.port > 0) {
                    prefix.append(":");
                    prefix.append(this.port);
                }
                prefix.append(" ");
                prefix.append(this.oncrpcProtocol);
                prefix.append(" ");
                prefix.append("TEA/1.0");
                prefix.append("\r\n");
                prefix.append("\r\n");
                int contentLength = this.sendingXdr.getXdrLength();
                int lineCount = (contentLength + 47) / 48;
                int realLength = prefix.length() + (contentLength + 2) / 3 * 4 + lineCount * 2;
                byte[] xdrData = this.sendingXdr.getXdrData();
                try {
                    this.httpClient.beginPostRequest(this.cgiHandlerPath, "text/plain", realLength);
                    String s2 = prefix.toString();
                    this.httpClient.writeContentBytes(s2.getBytes(), 0, s2.length());
                    byte[] lines = new byte[6600];
                    int xdrOffset = 0;
                    int offset = 0;
                    while (contentLength >= 48) {
                        if (offset >= 6600) {
                            this.httpClient.writeContentBytes(lines, 0, offset);
                            offset = 0;
                        }
                        offset += Base64.encode((byte[])xdrData, (int)xdrOffset, (int)48, (byte[])lines, (int)offset);
                        lines[offset++] = 13;
                        lines[offset++] = 10;
                        xdrOffset += 48;
                        contentLength -= 48;
                    }
                    if (contentLength > 0) {
                        if (offset >= 6600) {
                            this.httpClient.writeContentBytes(lines, 0, offset);
                            offset = 0;
                        }
                        offset += Base64.encode((byte[])xdrData, (int)xdrOffset, (int)contentLength, (byte[])lines, (int)offset);
                        lines[offset++] = 13;
                        lines[offset++] = 10;
                    }
                    if (offset > 0) {
                        this.httpClient.writeContentBytes(lines, 0, offset);
                    }
                    this.httpClient.endPostRequest();
                }
                catch (IOException e) {
                    throw new OncRpcException(3, e.getLocalizedMessage());
                }
                try {
                    this.receivingXdr.beginDecoding();
                    int responseCode = this.httpClient.getResponseCode();
                    if (responseCode < 200 || responseCode >= 300) {
                        throw new OncRpcException(16, "HTTP tunnel response error " + responseCode);
                    }
                    replyHeader.xdrDecode(this.receivingXdr);
                    if (replyHeader.messageId != callHeader.messageId) {
                        this.receivingXdr.endDecoding();
                        throw new OncRpcException(44);
                    }
                    if (!replyHeader.successfullyAccepted()) {
                        this.receivingXdr.endDecoding();
                        if (refreshesLeft <= 0 || replyHeader.replyStatus != 1 || replyHeader.rejectStatus != 1 || !this.auth.canRefreshCred()) {
                            throw replyHeader.newException();
                        }
                        break block18;
                    }
                    result.xdrDecode(this.receivingXdr);
                    this.receivingXdr.endDecoding();
                    return;
                }
                catch (InterruptedIOException e) {
                    throw new OncRpcTimeoutException();
                }
                catch (IOException e) {
                    throw new OncRpcException(4, e.getLocalizedMessage());
                }
            }
            --refreshesLeft;
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.sendingXdr.setCharacterEncoding(characterEncoding);
        this.receivingXdr.setCharacterEncoding(characterEncoding);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

