package org.apache.ratis.thirdparty.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.SubtypeOf;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.TargetLocations;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * A literal value. Programmers should rarely write this type.
 *
 * @checker_framework.manual #index-checker Index Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@SubtypeOf(LTEqLengthOf.class)
public @interface UpperBoundLiteral {

  /**
   * Returns the value of the literal.
   *
   * @return the value of the literal
   */
  int value();
}
