package org.apache.ratis.thirdparty.org.checkerframework.common.returnsreceiver.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.DefaultFor;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.InvisibleQualifier;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.LiteralKind;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.QualifierForLiterals;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.SubtypeOf;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The top type for the Returns Receiver Checker's type system. Values of the annotated type might
 * be the receiver ({@code this}) or might not. Programmers should rarely write this type.
 *
 * @checker_framework.manual #returns-receiver-checker Returns Receiver Checker
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf({})
@DefaultQualifierInHierarchy
@QualifierForLiterals(LiteralKind.NULL)
@DefaultFor(value = TypeUseLocation.LOWER_BOUND)
@InvisibleQualifier
public @interface UnknownThis {}
