/*
 * Copyright 2019 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ratis.thirdparty.io.grpc;

/**
 * Internal accessor for {@link CallOptions}.
 */
@Internal
public final class InternalCallOptions {
  private InternalCallOptions() {}

  /**
   * Gets the waitForReady bit or {@code null} if it was never set.
   */
  public static Boolean getWaitForReady(CallOptions callOptions) {
    return callOptions.getWaitForReady();
  }
}
