package org.apache.ratis.thirdparty.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.SubtypeOf;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.TargetLocations;
import org.apache.ratis.thirdparty.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type in the Upper Bound type system. Programmers should rarely write this type.
 *
 * @checker_framework.manual #index-checker Index Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@SubtypeOf({LTOMLengthOf.class, UpperBoundLiteral.class})
public @interface UpperBoundBottom {}
