/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;

public final class ParseRatisLog {
    private final File file;
    private final Function<RaftProtos.StateMachineLogEntryProto, String> smLogToString;
    private long numConfEntries;
    private long numMetadataEntries;
    private long numStateMachineEntries;
    private long numInvalidEntries;

    private ParseRatisLog(File f, Function<RaftProtos.StateMachineLogEntryProto, String> smLogToString) {
        this.file = f;
        this.smLogToString = smLogToString;
        this.numConfEntries = 0L;
        this.numMetadataEntries = 0L;
        this.numStateMachineEntries = 0L;
        this.numInvalidEntries = 0L;
    }

    public void dumpSegmentFile() throws IOException {
        LogSegmentPath pi = LogSegmentPath.matchLogSegment((Path)this.file.toPath());
        if (pi == null) {
            System.out.println("Invalid segment file");
            return;
        }
        System.out.println("Processing Raft Log file: " + this.file.getAbsolutePath() + " size:" + this.file.length());
        int entryCount = LogSegment.readSegmentFile((File)this.file, (LogSegmentStartEnd)pi.getStartEnd(), (RaftServerConfigKeys.Log.CorruptionPolicy)RaftServerConfigKeys.Log.CorruptionPolicy.EXCEPTION, null, this::processLogEntry);
        System.out.println("Num Total Entries: " + entryCount);
        System.out.println("Num Conf Entries: " + this.numConfEntries);
        System.out.println("Num Metadata Entries: " + this.numMetadataEntries);
        System.out.println("Num StateMachineEntries Entries: " + this.numStateMachineEntries);
        System.out.println("Num Invalid Entries: " + this.numInvalidEntries);
    }

    private void processLogEntry(RaftProtos.LogEntryProto proto) {
        if (proto.hasConfigurationEntry()) {
            ++this.numConfEntries;
        } else if (proto.hasMetadataEntry()) {
            ++this.numMetadataEntries;
        } else if (proto.hasStateMachineLogEntry()) {
            ++this.numStateMachineEntries;
        } else {
            System.out.println("Found invalid entry" + proto.toString());
            ++this.numInvalidEntries;
        }
        String str = LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)proto, this.smLogToString);
        System.out.println(str);
    }

    public static class Builder {
        private File file = null;
        private Function<RaftProtos.StateMachineLogEntryProto, String> smLogToString = null;

        public Builder setSegmentFile(File segmentFile) {
            this.file = segmentFile;
            return this;
        }

        public Builder setSMLogToString(Function<RaftProtos.StateMachineLogEntryProto, String> smLogToStr) {
            this.smLogToString = smLogToStr;
            return this;
        }

        public ParseRatisLog build() {
            return new ParseRatisLog(this.file, this.smLogToString);
        }
    }
}

