/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.TxnManager;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class TxnMgrProxy
implements TransactionManager,
Administrable,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final TxnManager backend;
    final Uuid proxyID;

    static TxnMgrProxy create(TxnManager txnMgr, Uuid id) {
        if (txnMgr instanceof RemoteMethodControl) {
            return new ConstrainableTxnMgrProxy(txnMgr, id, null);
        }
        return new TxnMgrProxy(txnMgr, id);
    }

    private TxnMgrProxy(TxnManager txnMgr, Uuid id) {
        if (txnMgr == null || id == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.backend = txnMgr;
        this.proxyID = id;
    }

    public TransactionManager.Created create(long lease) throws LeaseDeniedException, RemoteException {
        return this.backend.create(lease);
    }

    public void join(long id, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.backend.join(id, part, crashCount);
    }

    public int getState(long id) throws UnknownTransactionException, RemoteException {
        return this.backend.getState(id);
    }

    public void commit(long id) throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.backend.commit(id);
    }

    public void commit(long id, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.backend.commit(id, waitFor);
    }

    public void abort(long id) throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.backend.abort(id);
    }

    public void abort(long id, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.backend.abort(id, waitFor);
    }

    public Object getAdmin() throws RemoteException {
        return this.backend.getAdmin();
    }

    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare((Object)this, (Object)o);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.backend == null) {
            throw new InvalidObjectException("TxnMgrProxy.readObject failure - backend field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("TxnMgrProxy.proxyID failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize TxnMgrProxy instance");
    }

    static final class ConstrainableTxnMgrProxy
    extends TxnMgrProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableTxnMgrProxy(TxnManager txnMgr, Uuid id, MethodConstraints methodConstraints) {
            super(ConstrainableTxnMgrProxy.constrainServer(txnMgr, methodConstraints), id);
        }

        private static TxnManager constrainServer(TxnManager txnMgr, MethodConstraints methodConstraints) {
            return (TxnManager)((RemoteMethodControl)txnMgr).setConstraints(methodConstraints);
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableTxnMgrProxy(this.backend, this.proxyID, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.backend).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.backend);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.backend instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableTxnMgrProxy.readObject failure - backend does not implement constrainable functionality ");
            }
        }
    }
}

