/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantAbortRecord;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class AbortJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = 5;
    static final Logger logger = TxnManagerImpl.participantLogger;

    public AbortJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle[] handles) {
        super(pool, wm);
        if (log == null) {
            throw new IllegalArgumentException("AbortJob: AbortJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handles == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (handles.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = handles;
    }

    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            tmp[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return tmp;
    }

    Object doWork(TaskManager.Task who, Object param) {
        ParticipantHandle handle = (ParticipantHandle)param;
        TransactionParticipant par = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "AbortJob:doWork aborting handle: {0}", handle);
        }
        int vote = 0;
        vote = handle.getPrepState();
        switch (vote) {
            case 4: 
            case 6: {
                return new Integer(6);
            }
        }
        if (par == null) {
            par = handle.getPreParedParticipant();
        }
        try {
            if (this.attempt(who) > this.maxtries) {
                return new Integer(6);
            }
        }
        catch (JobException je) {
            return null;
        }
        if (par == null) {
            return null;
        }
        Integer response = null;
        try {
            par.abort(this.tr.mgr, this.tr.id);
            response = new Integer(6);
        }
        catch (TransactionException bte) {
            response = new Integer(6);
        }
        catch (NoSuchObjectException nsoe) {
            response = new Integer(6);
        }
        catch (ConnectException ce) {
        }
        catch (UnknownHostException uhe) {
            response = new Integer(6);
        }
        catch (ConnectIOException cioe) {
        }
        catch (MarshalException me) {
            response = new Integer(6);
        }
        catch (AccessException ae) {
            response = new Integer(6);
        }
        catch (ActivateFailedException afe) {
            response = new Integer(6);
        }
        catch (RemoteException re) {
        }
        catch (RuntimeException rte) {
            response = new Integer(6);
        }
        if (response != null) {
            handle.setPrepState(6);
            try {
                this.log.write(new ParticipantAbortRecord(handle));
            }
            catch (LogException le) {
                // empty catch block
            }
            return response;
        }
        return null;
    }

    Object computeResult() throws JobException {
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int tmp = 0;
        int count = 0;
        for (int i = 0; i < this.results.length; ++i) {
            tmp = (Integer)this.results[i];
            if (tmp != 6) continue;
            ++count;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "AbortJob:computeResult {0} participants ABORTED", new Integer(count));
        }
        return new Integer(6);
    }
}

