/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.constants.TxnConstants;
import com.sun.jini.mahalo.StorableObject;
import com.sun.jini.mahalo.TxnManagerImpl;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.security.ProxyPreparer;

class ParticipantHandle
implements Serializable,
TransactionConstants {
    static final long serialVersionUID = -1776073824495304317L;
    private transient TransactionParticipant preparedPart;
    private StorableObject storedpart;
    private long crashcount;
    private int prepstate;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    ParticipantHandle(TransactionParticipant preparedPart, long crashcount) throws RemoteException {
        block3: {
            this.crashcount = 0L;
            if (preparedPart == null) {
                throw new NullPointerException("TransactionParticipant argument cannot be null");
            }
            try {
                this.storedpart = new StorableObject(preparedPart);
                this.preparedPart = preparedPart;
                this.crashcount = crashcount;
            }
            catch (RemoteException re) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block3;
                persistenceLogger.log(Level.WARNING, "Cannot store the TransactionParticipant", re);
            }
        }
        this.prepstate = 1;
    }

    long getCrashCount() {
        return this.crashcount;
    }

    synchronized TransactionParticipant getPreParedParticipant() {
        return this.preparedPart;
    }

    void restoreTransientState(ProxyPreparer recoveredListenerPreparer) throws RemoteException {
        if (recoveredListenerPreparer == null) {
            throw new NullPointerException("Preparer argument cannot be null");
        }
        this.preparedPart = (TransactionParticipant)recoveredListenerPreparer.prepareProxy(this.storedpart.get());
    }

    StorableObject getStoredPart() {
        return this.storedpart;
    }

    synchronized void setPrepState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("ParticipantHandle: setPrepState: cannot set to " + TxnConstants.getName(state));
            }
        }
        this.prepstate = state;
    }

    synchronized int getPrepState() {
        return this.prepstate;
    }

    public int hashCode() {
        return this.preparedPart.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (that.getClass() != this.getClass()) {
            return false;
        }
        ParticipantHandle h = (ParticipantHandle)that;
        return this.preparedPart.equals(h.preparedPart);
    }
}

