/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.mahalo.TxnMgrAdminProxy;
import com.sun.jini.mahalo.TxnMgrProxy;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private final RemoteMethodControl serverProxy;
    private final Uuid proxyID;

    ProxyVerifier(TxnManager serverProxy, Uuid proxyID) {
        if (!(serverProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("No verifier available for non-constrainable service");
        }
        if (!(serverProxy instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        if (proxyID == null) {
            throw new IllegalArgumentException("Proxy id cannot be null");
        }
        this.serverProxy = (RemoteMethodControl)serverProxy;
        this.proxyID = proxyID;
    }

    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        RemoteMethodControl otherServerProxy;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ProxyVerifier.class.getName(), "isTrustedObject", new Object[]{obj, ctx});
        }
        if (obj == null || ctx == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        Uuid inputProxyID = null;
        if (obj instanceof TxnMgrProxy.ConstrainableTxnMgrProxy) {
            otherServerProxy = (RemoteMethodControl)((TxnMgrProxy)obj).backend;
            inputProxyID = ((ReferentUuid)obj).getReferentUuid();
        } else {
            if (obj instanceof ConstrainableLandlordLease) {
                LandlordProxyVerifier lpv = new LandlordProxyVerifier((Landlord)this.serverProxy, this.proxyID);
                return lpv.isTrustedObject(obj, ctx);
            }
            if (obj instanceof TxnMgrAdminProxy.ConstrainableTxnMgrAdminProxy) {
                otherServerProxy = (RemoteMethodControl)((TxnMgrAdminProxy)obj).server;
                inputProxyID = ((ReferentUuid)obj).getReferentUuid();
            } else if (obj instanceof TxnManager && obj instanceof RemoteMethodControl) {
                otherServerProxy = (RemoteMethodControl)obj;
                inputProxyID = this.proxyID;
            } else {
                logger.log(Level.FINEST, "Object {0} is not a supported type", obj);
                return false;
            }
        }
        if (inputProxyID != null && !this.proxyID.equals((Object)inputProxyID)) {
            return false;
        }
        MethodConstraints mc = otherServerProxy.getConstraints();
        TrustEquivalence trusted = (TrustEquivalence)this.serverProxy.setConstraints(mc);
        boolean result = trusted.checkTrustEquivalence((Object)otherServerProxy);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ProxyVerifier.class.getName(), "isTrustedObject", result);
        }
        return result;
    }
}

