/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public class StorableObject
implements Serializable {
    private MarshalledObject bytes;
    private transient Object obj;
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = -3793675220968988873L;

    public StorableObject(Object obj) throws RemoteException {
        try {
            this.bytes = new MarshalledObject<Object>(obj);
            this.obj = obj;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IOException e) {
            StorableObject.fatalError("can't encode object", e);
        }
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    public boolean equals(Object that) {
        try {
            if (that instanceof StorableObject) {
                return this.get().equals(((StorableObject)that).get());
            }
            return this.get().equals(that);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Object get() throws RemoteException {
        try {
            if (this.obj == null) {
                this.obj = this.bytes.get();
            }
            return this.obj;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IOException e) {
            StorableObject.fatalError("can't decode object", e);
        }
        catch (ClassNotFoundException e) {
            StorableObject.fatalError("can't decode object", e);
        }
        StorableObject.fatalError("how did we get here?", null);
        return null;
    }

    private static void fatalError(String msg, Throwable e) throws RemoteException {
        System.err.println(msg);
        if (e != null) {
            e.printStackTrace(System.err);
        }
        throw new RemoteException(msg, e);
    }
}

