/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.constants.TimeConstants;
import com.sun.jini.constants.TxnConstants;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.AbortJob;
import com.sun.jini.mahalo.AbortRecord;
import com.sun.jini.mahalo.CommitJob;
import com.sun.jini.mahalo.CommitRecord;
import com.sun.jini.mahalo.InternalManagerException;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.PrepareAndCommitJob;
import com.sun.jini.mahalo.PrepareJob;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;

class TxnManagerTransaction
implements TransactionConstants,
TimeConstants,
LeasedResource {
    static final long serialVersionUID = -2088463193687796098L;
    private static final boolean[][] states = new boolean[][]{{false, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, true, false, false, true, true}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, true, false}, {false, false, false, false, false, false, true}};
    private List parts = new Vector();
    private final ServerTransaction str;
    private int trstate;
    private long expires;
    private LogManager logmgr;
    private TaskManager threadpool;
    private WakeupManager wm;
    private TxnSettler settler;
    private Job job;
    private Uuid uuid;
    private Object leaseLock = new Object();
    private Object jobLock = new Object();
    private Object stateLock = new Object();
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger transactionsLogger = TxnManagerImpl.transactionsLogger;

    TxnManagerTransaction(TransactionManager mgr, LogManager logmgr, long id, TaskManager threadpool, WakeupManager wm, TxnSettler settler, Uuid uuid) {
        if (logmgr == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: log manager must be non-null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: transaction manager must be non-null");
        }
        if (threadpool == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: threadpool must be non-null");
        }
        if (wm == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: wakeup manager must be non-null");
        }
        if (settler == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: settler must be non-null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: uuid must be non-null");
        }
        this.threadpool = threadpool;
        this.wm = wm;
        this.logmgr = logmgr;
        this.str = new ServerTransaction(mgr, id);
        this.settler = settler;
        this.uuid = uuid;
        this.trstate = 1;
    }

    void add(ParticipantHandle handle) throws InternalManagerException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "add", handle);
        }
        if (handle == null) {
            throw new NullPointerException("ParticipantHolder: add: cannot add null handle");
        }
        try {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Adding ParticipantHandle: {0}", handle);
            }
            this.parts.add(handle);
        }
        catch (Exception e) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "Unable to add ParticipantHandle", e);
            }
            throw new InternalManagerException("TxnManagerTransaction: add: " + e.getMessage());
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "add");
        }
    }

    void modifyParticipant(ParticipantHandle handle, int state) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyParticipant", new Object[]{handle, new Integer(state)});
        }
        ParticipantHandle ph = null;
        if (handle == null) {
            throw new NullPointerException("ParticipantHolder: modifyParticipant: cannot modify null handle");
        }
        if (this.parts.contains(ph)) {
            ph = (ParticipantHandle)this.parts.get(this.parts.indexOf(handle));
        }
        if (ph == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
            }
            return;
        }
        ph.setPrepState(state);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean modifyTxnState(int state) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyTxnState", new Integer(state));
        }
        boolean result = false;
        Object object = this.stateLock;
        synchronized (object) {
            switch (state) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    result = states[this.trstate][state];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TxnManagerTransaction: modifyTxnState: invalid state");
                }
            }
            if (result) {
                this.trstate = state;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyTxnState", result);
        }
        return result;
    }

    public void join(TransactionParticipant preparedPart, long crashCount) throws CannotJoinException, CrashCountException, RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "join", new Object[]{preparedPart, new Long(crashCount)});
        }
        if (this.getState() != 1) {
            throw new CannotJoinException("not active");
        }
        if (this.getState() == 1 && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotJoinException("Lease expired");
        }
        try {
            ParticipantHandle ph = new ParticipantHandle(preparedPart, crashCount);
            ParticipantHandle phtmp = this.parts.contains(ph) ? this.parts.get(this.parts.indexOf(ph)) : null;
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Retrieved ParticipantHandle: {0}", phtmp);
            }
            if (phtmp != null) {
                long oldcount = phtmp.getCrashCount();
                if (oldcount == crashCount) {
                    return;
                }
                throw new CrashCountException("TxnManagerTransaction: join: old = " + oldcount + " new = " + crashCount);
            }
            this.add(ph);
        }
        catch (InternalManagerException ime) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "TransactionParticipant unable to join", ime);
            }
            throw ime;
        }
        catch (RemoteException re) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "TransactionParticipant unable to be stored", re);
            }
            throw re;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "join");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getState");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getState", new Integer(this.trstate));
            }
            return this.trstate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void commit(long waitFor) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "commit", new Long(waitFor));
        }
        long starttime = System.currentTimeMillis();
        if (this.getState() == 1 && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotCommitException("Lease expired");
        }
        if (this.getState() == 6) {
            throw new CannotCommitException("attempt to commit ABORTED transaction");
        }
        Vector joinvec = this.parthandles();
        if (joinvec == null) {
            if (!this.modifyTxnState(2)) {
                throw new CannotCommitException("attempt to commit ABORTED transaction");
            }
            if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit ABORTED transaction");
            return;
        }
        try {
            Object object;
            Enumeration joined = joinvec.elements();
            int numparts = joinvec.size();
            Object[] phs = new ParticipantHandle[numparts];
            joinvec.copyInto(phs);
            long now = starttime;
            long transpired = 0L;
            long remainder = 0L;
            ClientLog log = this.logmgr.logFor(this.str.id);
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "{0} TransactionParticipants have joined", new Integer(numparts));
            }
            int oldstate = this.getState();
            Integer result = new Integer(6);
            Exception alternateException = null;
            if (this.modifyTxnState(2)) {
                if (oldstate == 1) {
                    log.write(new CommitRecord((ParticipantHandle[])phs));
                }
                object = this.jobLock;
                synchronized (object) {
                    if (this.job == null) {
                        this.job = phs.length == 1 ? new PrepareAndCommitJob((Transaction)this.str, this.threadpool, this.wm, log, (ParticipantHandle)phs[0]) : new PrepareJob((Transaction)this.str, this.threadpool, this.wm, log, (ParticipantHandle[])phs);
                        this.job.scheduleTasks();
                    }
                }
                object = this.jobLock;
                synchronized (object) {
                    if (this.job instanceof PrepareJob || this.job instanceof PrepareAndCommitJob) {
                        try {
                            if (this.job.isCompleted(Long.MAX_VALUE) && (result = (Integer)this.job.computeResult()) == 6 && this.job instanceof PrepareAndCommitJob) {
                                PrepareAndCommitJob pj = (PrepareAndCommitJob)this.job;
                                alternateException = pj.getAlternateException();
                            }
                        }
                        catch (JobNotStartedException jnse) {
                            result = new Integer(4);
                        }
                        catch (ResultNotReadyException rnre) {
                        }
                        catch (JobException je) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.getState() == 6) {
                throw new CannotCommitException("transaction ABORTED");
            }
            if (this.getState() == 5) {
                result = new Integer(5);
            }
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Voting result: {0}", TxnConstants.getName(result));
            }
            switch (result) {
                case 4: {
                    break;
                }
                case 6: {
                    now = System.currentTimeMillis();
                    transpired = now - starttime;
                    remainder = waitFor - transpired;
                    if (remainder >= 0L) {
                        this.doAbort(remainder);
                    } else {
                        this.doAbort(0L);
                    }
                    if (alternateException != null) throw new RemoteException("Problem communicating with participant", alternateException);
                    throw new CannotCommitException("Unable to commit transaction: " + this.getParticipantInfo());
                }
                case 3: {
                    if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit ABORTED transaction");
                    object = this.jobLock;
                    synchronized (object) {
                        this.job = new CommitJob((Transaction)this.str, this.threadpool, this.wm, log, (ParticipantHandle[])phs);
                        this.job.scheduleTasks();
                    }
                }
                case 5: {
                    object = this.jobLock;
                    synchronized (object) {
                        if (this.job instanceof PrepareAndCommitJob) {
                            if (!this.modifyTxnState(5)) {
                                throw new CannotCommitException("transaction ABORTED");
                            }
                            break;
                        }
                        if (this.job instanceof AbortJob) {
                            throw new CannotCommitException("transaction ABORTED");
                        }
                    }
                    if (this.getState() != 5) {
                        throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(result));
                    }
                    now = System.currentTimeMillis();
                    transpired = now - starttime;
                    boolean committed = false;
                    try {
                        remainder = waitFor - transpired;
                        Object je = this.jobLock;
                        synchronized (je) {
                            if (remainder <= 0L || !this.job.isCompleted(remainder)) {
                                this.settler.noteUnsettledTxn(this.str.id);
                                throw new TimeoutExpiredException("timeout expired", true);
                            }
                            result = (Integer)this.job.computeResult();
                            committed = true;
                        }
                    }
                    catch (ResultNotReadyException rnre) {
                    }
                    catch (JobNotStartedException jnse) {
                    }
                    catch (JobException je) {
                        // empty catch block
                    }
                    if (committed) break;
                }
                default: {
                    throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(result));
                }
            }
            log.invalidate();
        }
        catch (RuntimeException rte) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw rte;
            transactionsLogger.log(Level.FINEST, "Problem committing transaction", rte);
            throw rte;
        }
        catch (LogException le) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw new CannotCommitException("Unable to log");
            transactionsLogger.log(Level.FINEST, "Problem persisting transaction", le);
            throw new CannotCommitException("Unable to log");
        }
        if (!operationsLogger.isLoggable(Level.FINER)) return;
        operationsLogger.exiting(TxnManagerTransaction.class.getName(), "commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(long waitFor) throws CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "abort", new Long(waitFor));
        }
        long starttime = System.currentTimeMillis();
        try {
            Vector joinvec = this.parthandles();
            if (joinvec == null) {
                if (this.modifyTxnState(6)) {
                    return;
                }
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            int numparts = joinvec.size();
            Object[] phs = new ParticipantHandle[numparts];
            joinvec.copyInto(phs);
            ClientLog log = this.logmgr.logFor(this.str.id);
            if (this.modifyTxnState(6)) {
                log.write(new AbortRecord((ParticipantHandle[])phs));
                Object object = this.jobLock;
                synchronized (object) {
                    if (!(this.job instanceof AbortJob)) {
                        if (this.job != null) {
                            this.job.stop();
                        }
                        this.job = new AbortJob((Transaction)this.str, this.threadpool, this.wm, log, (ParticipantHandle[])phs);
                        this.job.scheduleTasks();
                    }
                }
            } else {
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            long now = System.currentTimeMillis();
            long transpired = now - starttime;
            Integer result = new Integer(1);
            boolean aborted = false;
            long remainder = waitFor - transpired;
            try {
                Object object = this.jobLock;
                synchronized (object) {
                    if (remainder <= 0L || !this.job.isCompleted(remainder)) {
                        this.settler.noteUnsettledTxn(this.str.id);
                        throw new TimeoutExpiredException("timeout expired", false);
                    }
                    result = (Integer)this.job.computeResult();
                    aborted = true;
                }
            }
            catch (ResultNotReadyException rnre) {
            }
            catch (JobNotStartedException jnse) {
            }
            catch (JobException je) {
                this.settler.noteUnsettledTxn(this.str.id);
                throw new TimeoutExpiredException("timeout expired", false);
            }
            if (!aborted) {
                throw new InternalManagerException("TxnManagerTransaction: abort: AbortJob got bad state: " + TxnConstants.getName(result));
            }
            log.invalidate();
        }
        catch (RuntimeException rte) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "Problem aborting transaction", rte);
            }
            throw new InternalManagerException("TxnManagerTransaction: abort: fatal error");
        }
        catch (LogException le) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem persisting transaction", le);
            }
            throw new CannotAbortException("Unable to log");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "abort");
        }
    }

    public Transaction getTransaction() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getTransaction");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getTransaction", this.str);
        }
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiration() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getExpiration");
        }
        Object object = this.leaseLock;
        synchronized (object) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getExpiration", new Date(this.expires));
            }
            return this.expires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(long newExpiration) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "setExpiration", new Date(newExpiration));
        }
        Object object = this.leaseLock;
        synchronized (object) {
            this.expires = newExpiration;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "setExpiration");
        }
    }

    public Uuid getCookie() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getCookie");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getCookie", this.uuid);
        }
        return this.uuid;
    }

    private void doAbort(long timeout) {
        block8: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(TxnManagerTransaction.class.getName(), "doAbort", new Long(timeout));
            }
            try {
                this.str.abort(timeout);
            }
            catch (RemoteException re) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", re);
                }
            }
            catch (TimeoutExpiredException te) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", te);
                }
            }
            catch (TransactionException bte) {
                if (!transactionsLogger.isLoggable(Levels.HANDLED)) break block8;
                transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", bte);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "doAbort");
        }
    }

    synchronized boolean ensureCurrent() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "ensureCurrent");
        }
        long cur = System.currentTimeMillis();
        boolean result = false;
        long useby = this.getExpiration();
        if (useby > cur) {
            result = true;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "ensureCurrent", result);
        }
        return result;
    }

    private Vector parthandles() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "parthandles");
        }
        if (this.parts == null || this.parts.size() == 0) {
            return null;
        }
        Vector vect = new Vector(this.parts);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved {0} participants", new Integer(vect.size()));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "parthandles");
        }
        return vect;
    }

    private String getParticipantInfo() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getParticipantInfo");
        }
        if (this.parts == null || this.parts.size() == 0) {
            return "No participants";
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "{0} participants joined", new Integer(this.parts.size()));
        }
        StringBuffer sb = new StringBuffer(this.parts.size() + " Participants: ");
        for (int i = 0; i < this.parts.size(); ++i) {
            ParticipantHandle ph = (ParticipantHandle)this.parts.get(i);
            sb.append("{" + i + ", " + ph.getPreParedParticipant().toString() + ", " + TxnConstants.getName(ph.getPrepState()) + "} ");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getParticipantInfo", sb.toString());
        }
        return sb.toString();
    }

    void restoreTransientState(ProxyPreparer preparer) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
        if (this.parts == null || this.parts.size() == 0) {
            return;
        }
        ParticipantHandle[] handles = this.parts.toArray(new ParticipantHandle[this.parts.size()]);
        for (int i = 0; i < handles.length; ++i) {
            handles[i].restoreTransientState(preparer);
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Restored transient state for {0}", handles[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
    }
}

