/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.FileModes;
import com.sun.jini.mahalo.log.Log;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManagerAdmin;
import com.sun.jini.mahalo.log.SimpleLogFile;
import com.sun.jini.mahalo.log.TransientLogFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;

public class MultiLogManager
implements LogManager,
FileModes,
Administrable,
MultiLogManagerAdmin {
    private static final String LOG_FILE = "Log.";
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    private static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");
    private final LogRecovery client;
    private final Map logByID;
    private final Object logByIDLock;
    private boolean destroyed;
    private String directory;
    private static final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(FilenameFilter.class.getName(), "accept", new Object[]{dir, name});
            }
            boolean isLog = name.startsWith(MultiLogManager.LOG_FILE);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(FilenameFilter.class.getName(), "accept", isLog);
            }
            return isLog;
        }
    };
    final LogRemovalManager logMgrRef;

    public MultiLogManager() {
        this.logByID = new HashMap();
        this.logByIDLock = new Object();
        this.destroyed = false;
        this.directory = null;
        this.logMgrRef = new LogRemovalManager(){

            public void release(long cookie) {
                MultiLogManager.this.release(cookie);
            }
        };
        this.directory = null;
        this.client = null;
    }

    public MultiLogManager(LogRecovery client, String path) {
        block7: {
            this.logByID = new HashMap();
            this.logByIDLock = new Object();
            this.destroyed = false;
            this.directory = null;
            this.logMgrRef = new /* invalid duplicate definition of identical inner class */;
            if (path == null) {
                throw new IllegalArgumentException("MultiLogManager: must use non-null path");
            }
            if (client == null) {
                throw new IllegalArgumentException("MultiLogManager: must use non-null recovery client");
            }
            this.client = client;
            this.directory = path;
            if (!this.directory.endsWith(File.separator)) {
                this.directory = this.directory.concat(File.separator);
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "directory = {0}", this.directory);
            }
            File tmpfile = new File(this.directory);
            try {
                if (!tmpfile.exists() && !tmpfile.mkdirs() && persistenceLogger.isLoggable(Level.SEVERE)) {
                    persistenceLogger.log(Level.SEVERE, "Could not create {0}", tmpfile);
                }
            }
            catch (SecurityException se) {
                if (!persistenceLogger.isLoggable(Level.SEVERE)) break block7;
                persistenceLogger.log(Level.SEVERE, "Error accessing Version File", se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientLog logFor(long cookie) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "logFor", new Long(cookie));
        }
        ClientLog cl = null;
        Long key = new Long(cookie);
        ClientLog prev = null;
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                throw new LogException("Manger has been destroyed");
            }
            cl = (ClientLog)this.logByID.get(key);
            if (cl == null) {
                ClientLog clientLog = cl = this.directory == null ? new TransientLogFile(cookie, this.logMgrRef) : new SimpleLogFile(this.directory + LOG_FILE + cookie, cookie, this.logMgrRef);
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Created ClientLog: {0}", this.directory + LOG_FILE + cookie);
                }
                prev = this.logByID.put(key, cl);
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Currently managing {0} logs.", new Integer(this.logByID.size()));
            }
        }
        if (prev != null) {
            throw new LogException("Previous mapping for cookie(" + cookie + ") -- internal table corrupt?");
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Using ClientLog {0} for cookie {1}", new Object[]{cl, new Long(cookie)});
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "logFor", cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(long cookie) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "release", new Long(cookie));
        }
        Object prev = null;
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Releasing ClientLog for cookie {0}", new Long(cookie));
            }
            prev = this.logByID.remove(new Long(cookie));
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Currently managing {0} logs.", new Integer(this.logByID.size()));
            }
        }
        if (persistenceLogger.isLoggable(Level.FINEST) && prev == null) {
            persistenceLogger.log(Level.FINEST, "Note: ClientLog already removed");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "release");
        }
    }

    public void recover() throws LogException {
        block10: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(MultiLogManager.class.getName(), "recover");
            }
            if (this.directory == null) {
                return;
            }
            SimpleLogFile log = null;
            File tmpfile = null;
            String[] filenames = null;
            try {
                tmpfile = new File(this.directory);
                filenames = tmpfile.list(filter);
                if (filenames.length == 0) {
                    return;
                }
                for (int i = 0; i < filenames.length; ++i) {
                    String logName = this.directory + filenames[i];
                    log = new SimpleLogFile(logName, this.logMgrRef);
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "Recovering log: {0}", logName);
                    }
                    try {
                        log.recover(this.client);
                        this.logByID.put(new Long(log.cookie()), log);
                        continue;
                    }
                    catch (LogException le) {
                        if (!persistenceLogger.isLoggable(Level.WARNING)) continue;
                        persistenceLogger.log(Level.WARNING, "Unable to recover log state", le);
                    }
                }
            }
            catch (SecurityException se) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block10;
                persistenceLogger.log(Level.WARNING, "Unable to recover log state", se);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }

    public Object getAdmin() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "getAdmin");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "getAdmin", this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "destroy");
        }
        Object object = this.logByIDLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (this.logByID.size() > 0) {
                Object[] vals = this.logByID.values().toArray();
                Log slf = null;
                for (int i = 0; i < vals.length; ++i) {
                    try {
                        slf = (Log)vals[i];
                        if (slf != null) {
                            slf.invalidate();
                            continue;
                        }
                        if (!persistenceLogger.isLoggable(Level.FINEST)) continue;
                        persistenceLogger.log(Level.FINEST, "Observed a null log file entry for: {0}", slf);
                        continue;
                    }
                    catch (LogException le) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                        persistenceLogger.log(Levels.HANDLED, "Unable to recover log state", le);
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                        persistenceLogger.log(Levels.HANDLED, "Problem enumerating internal log state", nsee);
                    }
                }
                this.logByID.clear();
                this.destroyed = true;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "destroy");
        }
    }

    public static interface LogRemovalManager {
        public void release(long var1);
    }
}

