/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.log.InvalidatedLogException;
import com.sun.jini.mahalo.log.Log;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleLogFile
implements Log {
    private long cookie;
    private ObjectOutputStream out;
    private FileOutputStream outfile;
    private String name;
    private MultiLogManager.LogRemovalManager logMgr;
    private boolean valid = true;
    private boolean readonly = false;
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    private static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");

    public SimpleLogFile(String name, MultiLogManager.LogRemovalManager logMgr) {
        this.init(name, 0L, logMgr);
        this.readonly = true;
    }

    public SimpleLogFile(String name, long cookie, MultiLogManager.LogRemovalManager logMgr) {
        this.init(name, cookie, logMgr);
    }

    private void init(String name, long cookie, MultiLogManager.LogRemovalManager logMgr) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(SimpleLogFile.class.getName(), "init", new Object[]{name, new Long(cookie), logMgr});
        }
        if (name == null) {
            throw new IllegalArgumentException("SimpleLogFile: null name");
        }
        if (logMgr == null) {
            throw new IllegalArgumentException("SimpleLogFile: null log manager");
        }
        this.name = name;
        this.cookie = cookie;
        this.logMgr = logMgr;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(SimpleLogFile.class.getName(), "init");
        }
    }

    public long cookie() {
        return this.cookie;
    }

    public synchronized void write(LogRecord rec) throws LogException {
        block15: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(SimpleLogFile.class.getName(), "write", rec);
            }
            try {
                if (!this.valid) {
                    throw new InvalidatedLogException("Cannot write to to invalidated log");
                }
                if (this.readonly) {
                    throw new LogException("Unable to write to read only log");
                }
                if (this.out == null) {
                    boolean append = true;
                    File log = new File(this.name);
                    this.outfile = new FileOutputStream(this.name, append);
                    this.out = new HeaderlessObjectOutputStream(new BufferedOutputStream(this.outfile));
                    if (log.length() == 0L) {
                        this.out.writeLong(this.cookie);
                    }
                    this.out.reset();
                }
                this.out.writeObject(rec);
                this.out.flush();
                this.outfile.getFD().sync();
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Wrote: {0}", rec);
                }
            }
            catch (InvalidClassException ice) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", ice);
                }
            }
            catch (NotSerializableException nse) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", nse);
                }
            }
            catch (IOException ioe) {
                if (persistenceLogger.isLoggable(Level.WARNING)) {
                    persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", ioe);
                }
            }
            catch (SecurityException se) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block15;
                persistenceLogger.log(Level.WARNING, "Problem persisting LogRecord", se);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(SimpleLogFile.class.getName(), "write", rec);
        }
    }

    public synchronized void invalidate() throws LogException {
        block13: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(MultiLogManager.class.getName(), "invalidate");
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Invalidating log for cookie: {0}", new Long(this.cookie));
            }
            if (this.valid) {
                this.valid = false;
                this.logMgr.release(this.cookie);
            }
            try {
                if (this.out != null) {
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "Closing log file for: {0}", new Long(this.cookie));
                    }
                    this.out.close();
                }
            }
            catch (IOException ioe) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block13;
                persistenceLogger.log(Levels.HANDLED, "Problem closing log file", ioe);
            }
        }
        try {
            File fl = new File(this.name);
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Deleting log file for: {0}", new Long(this.cookie));
            }
            if (!fl.delete() && persistenceLogger.isLoggable(Levels.HANDLED)) {
                persistenceLogger.log(Levels.HANDLED, "Could not delete log file");
            }
        }
        catch (SecurityException se) {
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "SecurityException on log deletion", se);
            }
            throw new LogException("SimpleLogFile: invalidate: cannot delete log file.");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "invalidate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void recover(LogRecovery client) throws LogException {
        block31: {
            ObjectInputStream in;
            block30: {
                block29: {
                    boolean update;
                    ArrayList<LogRecord> recList;
                    block28: {
                        if (operationsLogger.isLoggable(Level.FINER)) {
                            operationsLogger.entering(MultiLogManager.class.getName(), "recover", client);
                        }
                        if (!this.valid) {
                            throw new InvalidatedLogException("Cannot recover from invalidated log");
                        }
                        if (client == null) {
                            throw new IllegalArgumentException("Cannot have a <null> client argument.");
                        }
                        in = null;
                        recList = new ArrayList<LogRecord>();
                        if (persistenceLogger.isLoggable(Level.FINEST)) {
                            persistenceLogger.log(Level.FINEST, "Recovering from: {0}", this.name);
                        }
                        in = new HeaderlessObjectInputStream(new BufferedInputStream(new FileInputStream(this.name)));
                        this.cookie = in.readLong();
                        LogRecord rec = null;
                        boolean done = false;
                        update = true;
                        try {
                            while (!done) {
                                rec = (LogRecord)in.readObject();
                                if (rec != null) {
                                    recList.add(rec);
                                    continue;
                                }
                                update = false;
                                done = true;
                                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                                persistenceLogger.log(Levels.HANDLED, "Log for cookie {0} contained a null record object", new Long(this.cookie));
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            update = false;
                            if (persistenceLogger.isLoggable(Level.WARNING)) {
                                persistenceLogger.log(Level.WARNING, "Problem recovering log file", cnfe);
                            }
                        }
                        catch (ClassCastException cce) {
                            update = false;
                            if (persistenceLogger.isLoggable(Level.WARNING)) {
                                persistenceLogger.log(Level.WARNING, "Problem recovering log file", cce);
                            }
                        }
                        catch (EOFException eofe) {
                        }
                        catch (IOException ioe) {
                            update = false;
                            if (!persistenceLogger.isLoggable(Level.WARNING)) break block28;
                            persistenceLogger.log(Level.WARNING, "Problem recovering log file", ioe);
                        }
                    }
                    if (update) {
                        for (int i = 0; i < recList.size(); ++i) {
                            client.recover(this.cookie, (LogRecord)recList.get(i));
                        }
                        break block29;
                    }
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block29;
                    persistenceLogger.log(Level.WARNING, "Skipping log recovery for", this.name);
                }
                Object var9_14 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe2) {
                    if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block30;
                    persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", ioe2);
                }
            }
            this.readonly = false;
            {
                break block31;
                catch (IOException ioe) {
                    block32: {
                        if (persistenceLogger.isLoggable(Level.WARNING)) {
                            persistenceLogger.log(Level.WARNING, "Problem recovering log file", ioe);
                        }
                        Object var9_15 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ioe2) {
                            if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block32;
                            persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", ioe2);
                        }
                    }
                    this.readonly = false;
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Object var9_16 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block33;
                        persistenceLogger.log(Levels.HANDLED, "Problem closing recovered log file", ioe2);
                    }
                }
                this.readonly = false;
                throw throwable;
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }

    private static class HeaderlessObjectOutputStream
    extends ObjectOutputStream {
        public HeaderlessObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        protected void writeStreamHeader() throws IOException {
        }
    }

    private static class HeaderlessObjectInputStream
    extends ObjectInputStream {
        public HeaderlessObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected void readStreamHeader() throws IOException {
        }
    }
}

