/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.lease.BasicRenewalFailureEvent;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.ClientLeaseMapWrapper;
import com.sun.jini.norm.DeformedClientLeaseMapWrapper;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.UIDGenerator;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.io.MarshalledInstance;
import net.jini.lease.LeaseRenewalSet;
import net.jini.security.ProxyPreparer;

class ClientLeaseWrapper
implements Lease,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private static final Method[] leaseToLeaseMethods;
    private Throwable lastFailure = null;
    private MarshalledInstance marshalledClientLease;
    private long clientLeaseExpiration;
    private long UID;
    private long membershipExpiration;
    private long renewDuration;
    private transient LeaseSet set;
    private transient Lease clientLease;
    private transient ProxyPreparer recoveredLeasePreparer;
    private transient boolean renewalPending = false;
    private transient List renewedList;

    ClientLeaseWrapper(Lease clientLease, long UID, List renewedList, LeaseSet leaseSet, long membershipDuration, long renewDuration, long now) throws IOException {
        this.renewedList = renewedList;
        this.UID = UID;
        this.clientLease = clientLease;
        this.set = leaseSet;
        this.clientLeaseExpiration = clientLease.getExpiration();
        clientLease.setSerialFormat(2);
        this.marshalledClientLease = new MarshalledInstance((Object)clientLease);
        this.renewDuration = renewDuration;
        this.calcMembershipExpiration(membershipDuration, now);
    }

    private void calcMembershipExpiration(long membershipDuration, long now) {
        if (membershipDuration == Long.MAX_VALUE) {
            this.membershipExpiration = Long.MAX_VALUE;
        } else {
            this.membershipExpiration = membershipDuration + now;
            if (this.membershipExpiration < 0L) {
                this.membershipExpiration = Long.MAX_VALUE;
            }
        }
    }

    void update(long membershipDuration, long renewDuration, long now) {
        this.renewDuration = renewDuration;
        this.calcMembershipExpiration(membershipDuration, now);
    }

    long getMembershipExpiration() {
        return this.membershipExpiration;
    }

    long getRenewDuration() {
        return this.renewDuration;
    }

    synchronized void clearRenewed() {
        this.renewalPending = false;
    }

    Lease getClientLease() {
        if (this.clientLease == null) {
            Lease unmarshalledLease = null;
            try {
                unmarshalledLease = (Lease)this.marshalledClientLease.get(false);
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "Problem unmarshalling lease -- will retry later", e);
            }
            catch (ClassNotFoundException e) {
                logger.log(Levels.HANDLED, "Problem unmarshalling lease -- will retry later", e);
            }
            if (unmarshalledLease != null) {
                try {
                    this.clientLease = (Lease)this.recoveredLeasePreparer.prepareProxy((Object)unmarshalledLease);
                }
                catch (RemoteException e) {
                    logger.log(Levels.HANDLED, "Problem preparing lease -- will retry later", e);
                }
                catch (SecurityException e) {
                    logger.log(Levels.HANDLED, "Problem preparing lease -- will retry later", e);
                }
            }
        }
        return this.clientLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MarshalledInstance getMarshalledClientLease() {
        MarshalledInstance marshalledInstance;
        Lease cl = this.getClientLease();
        if (cl == null) {
            return this.marshalledClientLease;
        }
        try {
            cl.setSerialFormat(1);
            marshalledInstance = new MarshalledInstance((Object)cl);
            Object var5_4 = null;
        }
        catch (IOException e) {
            MarshalledInstance marshalledInstance2;
            try {
                marshalledInstance2 = this.marshalledClientLease;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                cl.setSerialFormat(2);
                throw throwable;
            }
            cl.setSerialFormat(2);
            return marshalledInstance2;
        }
        cl.setSerialFormat(2);
        return marshalledInstance;
    }

    public boolean equals(Object that) {
        if (that instanceof ClientLeaseWrapper) {
            return this.UID == ((ClientLeaseWrapper)that).UID;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.UID;
    }

    public String toString() {
        return "CLW:" + this.UID + " exp:" + this.clientLeaseExpiration + " dexp:" + this.membershipExpiration + " dur:" + this.renewDuration + " failure:" + this.lastFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiration() {
        Lease cl = this.getClientLease();
        if (cl == null) {
            ClientLeaseWrapper clientLeaseWrapper = this;
            synchronized (clientLeaseWrapper) {
                return this.clientLeaseExpiration;
            }
        }
        return cl.getExpiration();
    }

    public void cancel() {
        throw new UnsupportedOperationException("ClientLeaseWrapper.cancel:LRS should not being canceling client leases ");
    }

    Throwable getLastFailure() {
        return this.lastFailure;
    }

    private synchronized boolean testAndSetRenewalPending() {
        boolean result = this.renewalPending;
        this.renewalPending = true;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changed() {
        if (!this.testAndSetRenewalPending()) {
            List list = this.renewedList;
            synchronized (list) {
                this.renewedList.add(this);
                this.renewedList.notifyAll();
            }
        }
    }

    boolean ensureCurrent(long now) {
        return this.set.ensureCurrent(now);
    }

    void failedRenewal(Throwable t) {
        this.lastFailure = t;
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void successfulRenewal() {
        this.lastFailure = null;
        try {
            this.marshalledClientLease = new MarshalledInstance((Object)this.clientLease);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while marshalling client lease after renewal", e);
        }
        ClientLeaseWrapper clientLeaseWrapper = this;
        synchronized (clientLeaseWrapper) {
            this.clientLeaseExpiration = this.clientLease.getExpiration();
        }
        this.changed();
    }

    public void renew(long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        if (!this.set.ensureCurrent(System.currentTimeMillis())) {
            throw LRMEventListener.EXPIRED_SET_EXCEPTION;
        }
        if (this.clientLease == null) {
            Lease unmarshalledLease;
            try {
                unmarshalledLease = (Lease)this.marshalledClientLease.get(false);
            }
            catch (IOException e) {
                UnmarshalException t = new UnmarshalException("ClientLeaseWrapper.renew:Could not unmarshal client lease for renewal", e);
                this.failedRenewal(t);
                throw t;
            }
            catch (ClassNotFoundException e) {
                UnmarshalException t = new UnmarshalException("ClientLeaseWrapper.renew:Could not unmarshal client lease for renewal", e);
                this.failedRenewal(t);
                throw t;
            }
            try {
                this.clientLease = (Lease)this.recoveredLeasePreparer.prepareProxy((Object)unmarshalledLease);
            }
            catch (RemoteException e) {
                this.failedRenewal(e);
                throw e;
            }
            catch (SecurityException e) {
                this.failedRenewal(e);
                throw e;
            }
        }
        try {
            this.clientLease.renew(duration);
        }
        catch (LeaseDeniedException e) {
            this.failedRenewal(e);
            throw e;
        }
        catch (UnknownLeaseException e) {
            this.failedRenewal(e);
            throw e;
        }
        catch (RemoteException e) {
            this.failedRenewal(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.failedRenewal(e);
            throw e;
        }
        catch (Error e) {
            this.failedRenewal(e);
            throw e;
        }
        this.successfulRenewal();
    }

    public void setSerialFormat(int format) {
        throw new UnsupportedOperationException("ClientLeaseWrapper.setSerialFormat:LRS should not be setting serial format through the wrapper");
    }

    public int getSerialFormat() {
        throw new UnsupportedOperationException("ClientLeaseWrapper.setSerialFormat:LRS should not be setting serial format through the wrapper");
    }

    public LeaseMap createLeaseMap(long duration) {
        if (this.isDeformed()) {
            return new DeformedClientLeaseMapWrapper(this, duration);
        }
        return new ClientLeaseMapWrapper(this, duration);
    }

    public boolean canBatch(Lease lease) {
        Lease otherClientLease;
        if (!(lease instanceof ClientLeaseWrapper)) {
            return false;
        }
        ClientLeaseWrapper clw = (ClientLeaseWrapper)lease;
        if (this.set.isolateSets() && !this.set.equals(clw.set)) {
            return false;
        }
        if (this.isDeformed() || clw.isDeformed()) {
            return false;
        }
        Lease clientLease = this.getClientLease();
        return ClientLeaseWrapper.sameConstraints(clientLease, otherClientLease = clw.getClientLease()) && clientLease.canBatch(otherClientLease);
    }

    private static boolean sameConstraints(Lease l1, Lease l2) {
        if (!(l1 instanceof RemoteMethodControl)) {
            return !(l2 instanceof RemoteMethodControl);
        }
        if (!(l2 instanceof RemoteMethodControl)) {
            return false;
        }
        return ConstrainableProxyUtil.equivalentConstraints((MethodConstraints)((RemoteMethodControl)l1).getConstraints(), (MethodConstraints)((RemoteMethodControl)l2).getConstraints(), (Method[])leaseToLeaseMethods);
    }

    void recoverTransient(List renewedList, UIDGenerator generator, LeaseSet leaseSet, ProxyPreparer recoveredLeasePreparer) {
        this.renewedList = renewedList;
        this.set = leaseSet;
        generator.inUse(this.UID);
        this.recoveredLeasePreparer = recoveredLeasePreparer;
        this.getClientLease();
        this.set.addToLeaseTable(this);
    }

    boolean isDeformed() {
        return this.getClientLease() == null;
    }

    LeaseSet getLeaseSet() {
        return this.set;
    }

    EventFactory newFailureFactory(LeaseRenewalSet source) throws IOException {
        MarshalledInstance ml = this.getMarshalledClientLease();
        MarshalledInstance mt = null;
        if (this.lastFailure != null) {
            mt = new MarshalledInstance((Object)this.lastFailure);
        }
        return new FailureFactory(source, ml, mt);
    }

    static {
        try {
            Method cancelMethod = Lease.class.getMethod("cancel", new Class[0]);
            Method renewMethod = Lease.class.getMethod("renew", Long.TYPE);
            leaseToLeaseMethods = new Method[]{cancelMethod, cancelMethod, renewMethod, renewMethod};
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    private class FailureFactory
    implements EventFactory {
        private LeaseRenewalSet source;
        private final MarshalledInstance marshalledLease;
        private final MarshalledInstance marshalledThrowable;

        private FailureFactory(LeaseRenewalSet source, MarshalledInstance marshalledLease, MarshalledInstance marshalledThrowable) {
            this.source = source;
            this.marshalledLease = marshalledLease;
            this.marshalledThrowable = marshalledThrowable;
        }

        public RemoteEvent createEvent(long eventID, long seqNum, MarshalledObject handback) {
            return new BasicRenewalFailureEvent(this.source, seqNum, handback, this.marshalledLease, this.marshalledThrowable);
        }
    }
}

