/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.norm.CancelLeaseSet;
import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.LeaseSetOperation;
import com.sun.jini.norm.LeaseTable;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.PersistentStore;
import com.sun.jini.norm.SetProxy;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.norm.event.EventType;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lease.ExpirationWarningEvent;
import net.jini.lease.LeaseRenewalSet;
import net.jini.security.ProxyPreparer;

class LeaseSet
implements Serializable,
LeasedResource {
    private static final long serialVersionUID = 2L;
    private long expiration;
    private transient ExpirationTime expiration2;
    private final Uuid ID;
    private final Set leases = new HashSet();
    private transient LeaseTable leaseTable;
    private long minWarning = -1L;
    private EventType warningEventType;
    private long warningSeqNum;
    private EventType failureEventType;
    private transient PersistentStore store;
    private transient NormServerBaseImpl normServerBaseImpl;

    LeaseSet(Uuid ID, EventTypeGenerator generator, PersistentStore store, NormServerBaseImpl normServerBaseImpl) {
        this.store = store;
        this.normServerBaseImpl = normServerBaseImpl;
        this.ID = ID;
        this.expiration2 = new ExpirationTime(this.expiration);
        this.leaseTable = new LeaseTable();
        SendMonitor sendMonitor = normServerBaseImpl.newSendMonitor(this);
        try {
            this.warningEventType = generator.newEventType(sendMonitor, 1L);
            this.failureEventType = generator.newEventType(sendMonitor, 0L);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.expiration2 = new ExpirationTime(this.expiration);
        this.leaseTable = new LeaseTable();
    }

    Iterator restoreTransientState(EventTypeGenerator generator, PersistentStore store, NormServerBaseImpl normServerBaseImpl, ProxyPreparer recoveredListenerPreparer) {
        this.normServerBaseImpl = normServerBaseImpl;
        this.store = store;
        SendMonitor sendMonitor = normServerBaseImpl.newSendMonitor(this);
        this.warningEventType.restoreTransientState(generator, sendMonitor, recoveredListenerPreparer);
        this.failureEventType.restoreTransientState(generator, sendMonitor, recoveredListenerPreparer);
        this.warningEventType.setLastSequenceNumber(this.warningSeqNum + Integer.MAX_VALUE);
        normServerBaseImpl.updateLeaseCount(this.leases.size());
        return this.leases.iterator();
    }

    ClientLeaseWrapper getClientLeaseWrapper(Lease clientLease) {
        return this.leaseTable.get(clientLease);
    }

    private boolean replace(ClientLeaseWrapper clw) {
        boolean found = this.leases.remove(clw);
        this.leases.add(clw);
        return !found;
    }

    void update(ClientLeaseWrapper clw) {
        boolean added = this.replace(clw);
        this.leaseTable.put(clw);
        UpdateClientLease u = new UpdateClientLease(this, clw);
        this.store.update(u);
        if (added) {
            this.normServerBaseImpl.updateLeaseCount(1);
        }
    }

    void addToLeaseTable(ClientLeaseWrapper clw) {
        this.leaseTable.put(clw);
    }

    boolean doesContainWrapper(ClientLeaseWrapper clw) {
        return this.leases.contains(clw);
    }

    private boolean removeInternal(ClientLeaseWrapper clw) {
        if (this.leases.remove(clw)) {
            this.leaseTable.remove(clw);
            return true;
        }
        return false;
    }

    boolean remove(ClientLeaseWrapper clw) {
        if (!this.removeInternal(clw)) {
            return false;
        }
        RemoveClientLease u = new RemoveClientLease(this, clw);
        this.store.update(u);
        this.normServerBaseImpl.updateLeaseCount(-1);
        return clw.getMembershipExpiration() > System.currentTimeMillis();
    }

    Set destroy() {
        this.setExpiration(-1L);
        CancelLeaseSet u = new CancelLeaseSet(this.getUuid());
        this.store.update(u);
        this.normServerBaseImpl.updateLeaseCount(-this.leases.size());
        return this.leases;
    }

    MarshalledInstance[] getLeases() {
        long now = System.currentTimeMillis();
        Iterator i = this.leases.iterator();
        ArrayList<MarshalledInstance> l = new ArrayList<MarshalledInstance>(this.leases.size());
        while (i.hasNext()) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)i.next();
            if (now > clw.getMembershipExpiration()) continue;
            l.add(clw.getMarshalledClientLease());
        }
        if (l.isEmpty()) {
            return null;
        }
        return l.toArray(new MarshalledInstance[l.size()]);
    }

    EventRegistration setExpirationWarningListener(RemoteEventListener listener, long minWarning, MarshalledObject handback) throws IOException {
        this.minWarning = minWarning;
        this.warningEventType.setListener(listener, handback);
        WarningEventRegistration u = new WarningEventRegistration(this);
        this.store.update(u);
        if (listener == null) {
            return null;
        }
        SetProxy proxy = this.newSetProxy();
        return new EventRegistration(this.warningEventType.getEventID(), (Object)proxy, proxy.getRenewalSetLease(), this.warningEventType.getLastSequenceNumber());
    }

    EventRegistration setRenewalFailureListener(RemoteEventListener listener, MarshalledObject handback) throws IOException {
        this.failureEventType.setListener(listener, handback);
        FailureEventRegistration u = new FailureEventRegistration(this);
        this.store.update(u);
        if (listener == null) {
            return null;
        }
        SetProxy proxy = this.newSetProxy();
        return new EventRegistration(this.failureEventType.getEventID(), (Object)proxy, proxy.getRenewalSetLease(), this.failureEventType.getLastSequenceNumber());
    }

    void renewalFailure(ClientLeaseWrapper clw) {
        long seqNum;
        if (!this.removeInternal(clw)) {
            return;
        }
        try {
            EventFactory factory = clw.newFailureFactory(this.newSetProxy());
            seqNum = this.failureEventType.sendEvent(factory);
        }
        catch (IOException e) {
            seqNum = this.failureEventType.bumpSequenceNumber();
        }
        RenewalFailure u = new RenewalFailure(this, clw, seqNum);
        this.store.update(u);
    }

    void sendWarningEvent() {
        this.warningSeqNum = this.warningEventType.sendEvent(new WarningFactory(this));
    }

    private SetProxy newSetProxy() {
        return this.normServerBaseImpl.newSetProxy(this);
    }

    boolean haveWarningRegistration() {
        return this.warningEventType.haveListener();
    }

    long getWarningTime() {
        return this.expiration - this.minWarning;
    }

    void logRenewal(ClientLeaseWrapper clw) {
        if (!this.leases.contains(clw)) {
            return;
        }
        UpdateClientLease u = new UpdateClientLease(this, clw);
        this.store.update(u);
    }

    public void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
        this.expiration2.set(this.expiration);
    }

    public long getExpiration() {
        return this.expiration;
    }

    boolean ensureCurrent(long now) {
        return this.expiration2.ensureCurrent(now);
    }

    public Uuid getCookie() {
        return this.ID;
    }

    Uuid getUuid() {
        return this.ID;
    }

    void definiteException(EventType type, RemoteEvent ev, long registrationNumber) {
        boolean changed = type.clearListenerIfSequenceMatch(registrationNumber);
        if (changed) {
            LeaseSetOperation u = ev instanceof ExpirationWarningEvent ? new WarningEventRegistration(this) : new FailureEventRegistration(this);
            this.store.update(u);
        }
    }

    protected boolean isolateSets() {
        return this.normServerBaseImpl.isolateSets();
    }

    public String toString() {
        return "LeaseSet" + this.ID;
    }

    private static class FailureEventRegistration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private EventType registration;

        private FailureEventRegistration(LeaseSet set) {
            super(set.getUuid());
            this.registration = set.failureEventType;
        }

        void apply(LeaseSet set) throws StoreException {
            set.failureEventType = this.registration;
        }
    }

    private static class WarningEventRegistration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private long warningTime;
        private EventType registration;

        private WarningEventRegistration(LeaseSet set) {
            super(set.getUuid());
            this.warningTime = set.minWarning;
            this.registration = set.warningEventType;
        }

        void apply(LeaseSet set) throws StoreException {
            set.minWarning = this.warningTime;
            set.warningEventType = this.registration;
        }
    }

    private static class RenewalFailure
    extends RemoveClientLease {
        private static final long serialVersionUID = 1L;
        private long evID;

        private RenewalFailure(LeaseSet set, ClientLeaseWrapper clw, long evID) {
            super(set, clw);
            this.evID = evID;
        }

        void apply(LeaseSet set) {
            super.apply(set);
            set.failureEventType.setLastSequenceNumber(this.evID);
        }
    }

    private static class RemoveClientLease
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private ClientLeaseWrapper clw;

        private RemoveClientLease(LeaseSet set, ClientLeaseWrapper clw) {
            super(set.getUuid());
            this.clw = clw;
        }

        void apply(LeaseSet set) {
            set.leases.remove(this.clw);
        }
    }

    private static class UpdateClientLease
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private ClientLeaseWrapper clw;

        private UpdateClientLease(LeaseSet set, ClientLeaseWrapper clw) {
            super(set.getUuid());
            this.clw = clw;
        }

        void apply(LeaseSet set) {
            set.replace(this.clw);
        }
    }

    static class ChangeSetExpiration
    extends LeaseSetOperation {
        private static final long serialVersionUID = 1L;
        private long expiration;

        ChangeSetExpiration(LeaseSet set, long expiration) {
            super(set.getUuid());
            this.expiration = expiration;
        }

        void apply(LeaseSet set) {
            set.setExpiration(this.expiration);
        }
    }

    private static class ExpirationTime {
        private static final long serialVersionUID = 1L;
        private long expirationTime;

        private ExpirationTime(long initVal) {
            this.expirationTime = initVal;
        }

        private synchronized void set(long newTime) {
            this.expirationTime = newTime;
        }

        private synchronized boolean ensureCurrent(long now) {
            return now <= this.expirationTime;
        }
    }

    private class WarningFactory
    implements EventFactory {
        private static final long serialVersionUID = 1L;
        private final SetProxy proxy;

        WarningFactory(LeaseSet set) {
            this.proxy = set.newSetProxy();
        }

        public RemoteEvent createEvent(long eventID, long seqNum, MarshalledObject handback) {
            return new ExpirationWarningEvent((LeaseRenewalSet)this.proxy, seqNum, handback);
        }
    }
}

