/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.NormServer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.lease.LeaseRenewalService;
import net.jini.lease.LeaseRenewalSet;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class NormProxy
extends AbstractProxy
implements LeaseRenewalService,
Administrable {
    private static final long serialVersionUID = 1L;

    static NormProxy create(NormServer server, Uuid serverUuid) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableNormProxy(server, serverUuid);
        }
        return new NormProxy(server, serverUuid);
    }

    NormProxy(NormServer server, Uuid serverUuid) {
        super(server, serverUuid);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server and uuid must be non-null");
    }

    public LeaseRenewalSet createLeaseRenewalSet(long leaseDuration) throws RemoteException {
        return this.server.createLeaseRenewalSet(leaseDuration);
    }

    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    static final class ConstrainableNormProxy
    extends NormProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        ConstrainableNormProxy(NormServer server, Uuid serverUuid) {
            super(server, serverUuid);
            if (!(server instanceof RemoteMethodControl)) {
                throw new IllegalArgumentException("server must implement RemoteMethodControl");
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("server must implement RemoteMethodControl");
            }
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            NormServer constrainedServer = (NormServer)((RemoteMethodControl)this.server).setConstraints(constraints);
            return new ConstrainableNormProxy(constrainedServer, this.uuid);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }
    }
}

