/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.AdminProxy;
import com.sun.jini.norm.NormProxy;
import com.sun.jini.norm.NormServer;
import com.sun.jini.norm.SetProxy;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl serverProxy;
    private final Uuid serverUuid;

    ProxyVerifier(NormServer serverProxy, Uuid serverUuid) {
        if (!(serverProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement RemoteMethodControl");
        }
        if (!(serverProxy instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        this.serverProxy = (RemoteMethodControl)serverProxy;
        this.serverUuid = serverUuid;
    }

    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        RemoteMethodControl otherServerProxy;
        if (obj == null || ctx == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        if (obj instanceof ConstrainableLandlordLease) {
            return new LandlordProxyVerifier((Landlord)this.serverProxy, this.serverUuid).isTrustedObject(obj, ctx);
        }
        if (obj instanceof SetProxy.ConstrainableSetProxy) {
            if (!this.isTrustedObject(((SetProxy)obj).getRenewalSetLease(), ctx)) {
                return false;
            }
            otherServerProxy = (RemoteMethodControl)((AbstractProxy)obj).server;
        } else if (obj instanceof AdminProxy.ConstrainableAdminProxy || obj instanceof NormProxy.ConstrainableNormProxy) {
            if (!this.serverUuid.equals((Object)((AbstractProxy)obj).uuid)) {
                return false;
            }
            otherServerProxy = (RemoteMethodControl)((AbstractProxy)obj).server;
        } else if (obj instanceof RemoteMethodControl) {
            otherServerProxy = (RemoteMethodControl)obj;
        } else {
            return false;
        }
        MethodConstraints mc = otherServerProxy.getConstraints();
        TrustEquivalence trusted = (TrustEquivalence)this.serverProxy.setConstraints(mc);
        return trusted.checkTrustEquivalence((Object)otherServerProxy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.serverProxy instanceof TrustEquivalence)) {
            throw new InvalidObjectException("serverProxy must implement TrustEquivalence");
        }
    }
}

