/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm.event;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.security.ProxyPreparer;

public class EventType
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private MarshalledObject marshalledListener;
    private transient RemoteEventListener listener;
    private transient ProxyPreparer recoveredListenerPreparer;
    private MarshalledObject handback;
    private long registrationNumber;
    private long lastSeqNum;
    private long evID;
    private transient SendMonitor monitor;
    private transient EventTypeGenerator generator;

    EventType(EventTypeGenerator generator, SendMonitor monitor, long evID, RemoteEventListener listener, MarshalledObject handback) throws IOException {
        if (generator == null) {
            throw new NullPointerException("EventType(): Must create event type objects with a non-null generator");
        }
        if (monitor == null) {
            throw new NullPointerException("EventType(): Must create event type objects with a non-null monitor");
        }
        this.generator = generator;
        this.monitor = monitor;
        this.evID = evID;
        this.setLastSequenceNumber(0L);
        this.setListener(listener, handback);
    }

    private void clearListener() {
        this.listener = null;
        this.handback = null;
        this.marshalledListener = null;
    }

    public synchronized void setListener(RemoteEventListener listener, MarshalledObject handback) throws IOException {
        ++this.registrationNumber;
        if (listener == null) {
            this.clearListener();
        } else {
            this.marshalledListener = new MarshalledObject<RemoteEventListener>(listener);
            this.listener = listener;
            this.handback = handback;
        }
    }

    public boolean haveListener() {
        return this.marshalledListener != null;
    }

    private RemoteEventListener getListener() {
        if (!this.haveListener()) {
            return null;
        }
        if (this.listener != null) {
            return this.listener;
        }
        RemoteEventListener unpreparedListener = null;
        try {
            unpreparedListener = (RemoteEventListener)this.marshalledListener.get();
        }
        catch (IOException e) {
            logger.log(Levels.HANDLED, "Problem unmarshalling listener -- will retry later", e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Levels.HANDLED, "Problem unmarshalling listener -- will retry later", e);
        }
        if (unpreparedListener != null) {
            try {
                this.listener = (RemoteEventListener)this.recoveredListenerPreparer.prepareProxy((Object)unpreparedListener);
            }
            catch (RemoteException e) {
                logger.log(Levels.HANDLED, "Problem preparing listener -- will retry later", e);
            }
            catch (SecurityException e) {
                logger.log(Levels.HANDLED, "Problem preparing listener -- will retry later", e);
            }
        }
        return this.listener;
    }

    public synchronized boolean clearListenerIfSequenceMatch(long oldSequenceNumber) {
        if (oldSequenceNumber == this.registrationNumber) {
            this.clearListener();
            return true;
        }
        return false;
    }

    public void setLastSequenceNumber(long seqNum) {
        this.lastSeqNum = seqNum;
    }

    public synchronized long getLastSequenceNumber() {
        return this.lastSeqNum;
    }

    public long getEventID() {
        return this.evID;
    }

    public synchronized long sendEvent(EventFactory factory) {
        if (this.generator == null) {
            throw new IllegalStateException("EventType.sendEvent:called before state was fully restored");
        }
        ++this.lastSeqNum;
        if (!this.haveListener()) {
            return this.lastSeqNum;
        }
        TaskManager mgr = this.generator.getTaskManager();
        WakeupManager wMgr = this.generator.getWakeupManager();
        mgr.add((TaskManager.Task)new SendTask(mgr, wMgr, factory, this.lastSeqNum));
        return this.lastSeqNum;
    }

    public synchronized long bumpSequenceNumber() {
        return ++this.lastSeqNum;
    }

    public void restoreTransientState(EventTypeGenerator generator, SendMonitor monitor, ProxyPreparer recoveredListenerPreparer) {
        if (generator == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null generator");
        }
        if (monitor == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null monitor");
        }
        if (recoveredListenerPreparer == null) {
            throw new NullPointerException("EventType.restoreTransientState:Must call with a non-null recoveredListenerPreparer");
        }
        this.generator = generator;
        this.monitor = monitor;
        this.recoveredListenerPreparer = recoveredListenerPreparer;
        generator.recoverEventID(this.evID);
    }

    private class SendTask
    extends RetryTask {
        private static final long MAX_TIME = 86400000L;
        private final EventFactory eventFactory;
        private final long seqNum;
        private RemoteEvent event;
        private long eventForRegistrationNumber;

        private SendTask(TaskManager taskManager, WakeupManager wakeupManager, EventFactory eventFactory, long seqNum) {
            super(taskManager, wakeupManager);
            this.eventForRegistrationNumber = -1L;
            this.eventFactory = eventFactory;
            this.seqNum = seqNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            long registrationNumber;
            MarshalledObject handback;
            RemoteEventListener listener;
            long now = System.currentTimeMillis();
            if (now - this.startTime() > 86400000L) {
                return true;
            }
            if (!EventType.this.monitor.isCurrent()) {
                return true;
            }
            EventType eventType = EventType.this;
            synchronized (eventType) {
                if (!EventType.this.haveListener()) {
                    return true;
                }
                listener = EventType.this.getListener();
                if (listener == null) {
                    return false;
                }
                handback = EventType.this.handback;
                registrationNumber = EventType.this.registrationNumber;
            }
            if (this.event == null || this.eventForRegistrationNumber != registrationNumber) {
                this.event = this.eventFactory.createEvent(EventType.this.evID, this.seqNum, handback);
                this.eventForRegistrationNumber = registrationNumber;
            }
            try {
                listener.notify(this.event);
                return true;
            }
            catch (Throwable t) {
                int cat = ThrowableConstants.retryable(t);
                if (cat == 0) {
                    logger.log(Levels.HANDLED, "Problem sending event -- will retry later", t);
                    return false;
                }
                if (cat == 1) {
                    logger.log(Level.INFO, "Problem sending event", t);
                    return true;
                }
                EventType.this.monitor.definiteException(EventType.this, this.event, registrationNumber, t);
                logger.log(Level.INFO, "Problem sending event", t);
                return true;
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }
}

