/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm.event;

import com.sun.jini.norm.event.EventType;
import com.sun.jini.norm.event.SendMonitor;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class EventTypeGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long nextEvID = 1L;
    private transient TaskManager taskManager = new TaskManager();
    private transient WakeupManager wakeupManager = new WakeupManager(new WakeupManager.ThreadDesc(null, true));

    public synchronized EventType newEventType(SendMonitor monitor) throws IOException {
        EventType rslt = new EventType(this, monitor, this.nextEvID, null, null);
        ++this.nextEvID;
        return rslt;
    }

    public EventType newEventType(SendMonitor monitor, long eventID) throws IOException {
        return new EventType(this, monitor, eventID, null, null);
    }

    void recoverEventID(long evID) {
        if (evID >= this.nextEvID) {
            this.nextEvID = evID + 1L;
        }
    }

    TaskManager getTaskManager() {
        return this.taskManager;
    }

    WakeupManager getWakeupManager() {
        return this.wakeupManager;
    }

    public void terminate() {
        this.taskManager.terminate();
        this.wakeupManager.stop();
        this.wakeupManager.cancelAll();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.taskManager = new TaskManager();
        this.wakeupManager = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    }
}

