/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLeaseMap;
import com.sun.jini.lease.AbstractLease;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

public class LandlordLease
extends AbstractLease
implements ReferentUuid {
    static final long serialVersionUID = 2L;
    private final Uuid cookie;
    private final Landlord landlord;
    private final Uuid landlordUuid;

    public LandlordLease(Uuid cookie, Landlord landlord, Uuid landlordUuid, long expiration) {
        super(expiration);
        if (cookie == null) {
            throw new NullPointerException("Can't create a LandlordLease with a null cookie");
        }
        if (landlord == null) {
            throw new NullPointerException("Can't create a LandlordLease with a null landlord");
        }
        if (landlordUuid == null) {
            throw new NullPointerException("Can't create a LandlordLease with a null landlordUuid");
        }
        this.cookie = cookie;
        this.landlord = landlord;
        this.landlordUuid = landlordUuid;
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.landlord.cancel(this.cookie);
    }

    protected long doRenew(long renewDuration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        if (renewDuration < 0L && renewDuration != Long.MAX_VALUE && renewDuration != -1L) {
            throw new IllegalArgumentException("Lease renewal: Asked for a negative duration");
        }
        return this.landlord.renew(this.cookie, renewDuration);
    }

    public Uuid getReferentUuid() {
        return this.cookie;
    }

    public boolean equals(Object other) {
        return ReferentUuids.compare((Object)((Object)this), (Object)other);
    }

    public boolean canBatch(Lease lease) {
        if (lease instanceof LandlordLease) {
            return this.landlordUuid.equals((Object)((LandlordLease)lease).landlordUuid);
        }
        return false;
    }

    Landlord landlord() {
        return this.landlord;
    }

    Uuid landlordUuid() {
        return this.landlordUuid;
    }

    Uuid cookie() {
        return this.cookie;
    }

    void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public LeaseMap createLeaseMap(long duration) {
        return new LandlordLeaseMap(this.landlord, this.landlordUuid, (Lease)this, duration);
    }

    public int hashCode() {
        return this.cookie.hashCode();
    }

    public String toString() {
        return "LandlordLease:" + this.cookie + " landlord:" + this.landlord + " landlordUuid:" + this.landlordUuid + " " + super.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.cookie == null) {
            throw new InvalidObjectException("null cookie reference");
        }
        if (this.landlord == null) {
            throw new InvalidObjectException("null landlord reference");
        }
        if (this.landlordUuid == null) {
            throw new InvalidObjectException("null landlordUuid reference");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("LandlordLease should always have data");
    }
}

