/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.AdminIterator;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.OutriggerAdmin;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.id.Uuid;

class IteratorProxy
implements AdminIterator {
    private final Uuid iterationUuid;
    OutriggerAdmin server;
    private EntryRep[] reps;
    private int next = -1;
    private final int fetchSize;
    private Uuid lastId = null;

    IteratorProxy(Uuid iterationUuid, OutriggerAdmin server, int fetchSize) {
        if (iterationUuid == null) {
            throw new NullPointerException("iterationUuid must be non-null");
        }
        if (server == null) {
            throw new NullPointerException("server must be non-null");
        }
        if (fetchSize <= 0 && fetchSize != -1) {
            throw new IllegalArgumentException("fetchSize must be postive or JavaSpaceAdmin.USE_DEFAULT");
        }
        this.iterationUuid = iterationUuid;
        this.server = server;
        this.fetchSize = fetchSize;
    }

    public Entry next() throws UnusableEntryException, RemoteException {
        this.assertOpen();
        if (this.next < 0 || this.next >= this.reps.length) {
            this.reps = this.server.nextReps(this.iterationUuid, this.fetchSize, this.lastId);
            if (this.reps == null) {
                this.close();
                return null;
            }
            this.lastId = this.reps[this.reps.length - 1].id();
            this.next = 0;
        }
        return this.reps[this.next++].entry();
    }

    public void delete() throws RemoteException {
        if (this.next < 0) {
            throw new IllegalStateException("AdminIterator:Can't call delete before calling next()");
        }
        this.assertOpen();
        this.server.delete(this.iterationUuid, this.reps[this.next - 1].id());
    }

    public void close() throws RemoteException {
        if (this.server != null) {
            OutriggerAdmin it = this.server;
            this.server = null;
            this.reps = null;
            it.close(this.iterationUuid);
        }
    }

    private void assertOpen() throws IllegalStateException {
        if (this.server == null) {
            throw new IllegalStateException("closed AdminIterator");
        }
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.iterationUuid + " (through " + this.server + ")";
    }
}

