/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.MatchSetData;
import com.sun.jini.outrigger.OutriggerServer;
import com.sun.jini.outrigger.SnapshotRep;
import com.sun.jini.outrigger.SpaceProxy2;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;
import net.jini.space.MatchSet;

class MatchSetProxy
implements MatchSet {
    private final OutriggerServer space;
    private final Uuid uuid;
    private final Lease lease;
    private EntryRep[] reps;
    private EntryRep lastRepReturned;
    private int i;
    private boolean unpackFailure = true;

    MatchSetProxy(MatchSetData inital, SpaceProxy2 parent, OutriggerServer space) {
        this.uuid = inital.uuid;
        this.space = space;
        this.lease = this.uuid != null ? parent.newLease(this.uuid, inital.intialLeaseDuration) : null;
        this.reps = inital.reps;
        this.i = 0;
    }

    public Lease getLease() {
        return this.lease;
    }

    public Entry next() throws RemoteException, UnusableEntryException {
        if (this.i >= this.reps.length) {
            this.i = 0;
            this.reps = this.space.nextBatch(this.uuid, this.lastRepReturned.id());
        }
        if (this.reps[this.i] == null) {
            return null;
        }
        this.unpackFailure = true;
        this.lastRepReturned = this.reps[this.i++];
        Entry rslt = this.lastRepReturned.entry();
        this.unpackFailure = false;
        return rslt;
    }

    public Entry getSnapshot() {
        if (this.unpackFailure) {
            throw new IllegalStateException("getSnapshot - need successful next call first");
        }
        return new SnapshotRep(this.lastRepReturned);
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.uuid + " (through " + this.space + ")";
    }
}

