/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.ConstrainableRegistrarProxy;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reggie.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

class RegistrarProxy
implements ServiceRegistrar,
Administrable,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.reggie");
    final Registrar server;
    transient ServiceID registrarID;

    static RegistrarProxy getInstance(Registrar server, ServiceID registrarID) {
        return server instanceof RemoteMethodControl ? new ConstrainableRegistrarProxy(server, registrarID, null) : new RegistrarProxy(server, registrarID);
    }

    RegistrarProxy(Registrar server, ServiceID registrarID) {
        this.server = server;
        this.registrarID = registrarID;
    }

    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    public ServiceRegistration register(ServiceItem srvItem, long leaseDuration) throws RemoteException {
        Item item = new Item(srvItem);
        if (item.serviceID != null) {
            Util.checkRegistrantServiceID(item.serviceID, logger, Level.WARNING);
        }
        return this.server.register(item, leaseDuration);
    }

    public Object lookup(ServiceTemplate tmpl) throws RemoteException {
        MarshalledWrapper wrapper = this.server.lookup(new Template(tmpl));
        if (wrapper == null) {
            return null;
        }
        try {
            return wrapper.get();
        }
        catch (IOException e) {
            throw new UnmarshalException("error unmarshalling return", e);
        }
        catch (ClassNotFoundException e) {
            throw new UnmarshalException("error unmarshalling return", e);
        }
    }

    public ServiceMatches lookup(ServiceTemplate tmpl, int maxMatches) throws RemoteException {
        return this.server.lookup(new Template(tmpl), maxMatches).get();
    }

    public EventRegistration notify(ServiceTemplate tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException {
        return this.server.notify(new Template(tmpl), transitions, listener, handback, leaseDuration);
    }

    public Class[] getEntryClasses(ServiceTemplate tmpl) throws RemoteException {
        return EntryClassBase.toClass(this.server.getEntryClasses(new Template(tmpl)));
    }

    public Object[] getFieldValues(ServiceTemplate tmpl, int setIndex, String field) throws NoSuchFieldException, RemoteException {
        ClassMapper.EntryField[] efields = ClassMapper.getFields(tmpl.attributeSetTemplates[setIndex].getClass());
        int fidx = efields.length;
        while (--fidx >= 0 && !field.equals(efields[fidx].field.getName())) {
        }
        if (fidx < 0) {
            throw new NoSuchFieldException(field);
        }
        Object[] values = this.server.getFieldValues(new Template(tmpl), setIndex, fidx);
        if (values != null && efields[fidx].marshal) {
            int i = values.length;
            while (--i >= 0) {
                try {
                    values[i] = ((MarshalledWrapper)values[i]).get();
                }
                catch (Throwable e) {
                    RegistrarProxy.handleException(e);
                    values[i] = null;
                }
            }
        }
        return values;
    }

    static void handleException(Throwable e) {
        if (e instanceof Error && !(e instanceof LinkageError) && !(e instanceof OutOfMemoryError) && !(e instanceof StackOverflowError)) {
            throw (Error)e;
        }
        logger.log(Level.INFO, "unmarshalling failure", e);
    }

    public Class[] getServiceTypes(ServiceTemplate tmpl, String prefix) throws RemoteException {
        return ServiceTypeBase.toClass(this.server.getServiceTypes(new Template(tmpl), prefix));
    }

    public ServiceID getServiceID() {
        return this.registrarID;
    }

    public LookupLocator getLocator() throws RemoteException {
        return this.server.getLocator();
    }

    public String[] getGroups() throws RemoteException {
        return this.server.getMemberGroups();
    }

    public Uuid getReferentUuid() {
        return UuidFactory.create((long)this.registrarID.getMostSignificantBits(), (long)this.registrarID.getLeastSignificantBits());
    }

    public int hashCode() {
        return this.registrarID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare((Object)this, (Object)obj);
    }

    public String toString() {
        return this.getClass().getName() + "[registrar=" + this.registrarID + " " + this.server + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.registrarID.writeBytes((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.registrarID = new ServiceID((DataInput)in);
        if (this.server == null) {
            throw new InvalidObjectException("null server");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

