/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.MarshalException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.WeakHashMap;

class ClassMapper {
    private static final WeakHashMap serviceMap = new WeakHashMap(23);
    private static final WeakHashMap entryMap = new WeakHashMap(17);
    private static final WeakHashMap fieldMap = new WeakHashMap(17);
    private static final FieldComparator comparator = new FieldComparator();
    private static final ServiceType[] empty = new ServiceType[0];
    private static final Class[] noArg = new Class[0];

    private ClassMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceTypeBase toServiceTypeBase(Class cls) throws MarshalException {
        WeakHashMap weakHashMap = serviceMap;
        synchronized (weakHashMap) {
            return ClassMapper.toServiceTypeBase(cls, true);
        }
    }

    private static ServiceTypeBase toServiceTypeBase(Class cls, boolean needCodebase) throws MarshalException {
        if (cls == null) {
            return null;
        }
        SoftReference cref = (SoftReference)serviceMap.get(cls);
        ServiceTypeBase stype = null;
        if (cref != null) {
            stype = (ServiceTypeBase)cref.get();
        }
        if (stype == null) {
            stype = new ServiceTypeBase(new ServiceType(cls, ClassMapper.toServiceType(cls.getSuperclass()), ClassMapper.toServiceType(cls.getInterfaces())), null);
            serviceMap.put(cls, new SoftReference<ServiceTypeBase>(stype));
        }
        if (needCodebase && stype.codebase == null) {
            stype.setCodebase(cls);
        }
        return stype;
    }

    private static ServiceType toServiceType(Class cls) throws MarshalException {
        if (cls != null) {
            return ClassMapper.toServiceTypeBase((Class)cls, (boolean)false).type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceType[] toServiceType(Class[] classes) throws MarshalException {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return empty;
        }
        ServiceType[] stypes = new ServiceType[classes.length];
        WeakHashMap weakHashMap = serviceMap;
        synchronized (weakHashMap) {
            int i = classes.length;
            while (--i >= 0) {
                stypes[i] = ClassMapper.toServiceType(classes[i]);
            }
        }
        return stypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryClassBase toEntryClassBase(Class cls) throws MarshalException {
        WeakHashMap weakHashMap = entryMap;
        synchronized (weakHashMap) {
            return ClassMapper.toEntryClassBase(cls, true);
        }
    }

    private static EntryClassBase toEntryClassBase(Class cls, boolean base) throws MarshalException {
        if (cls == null) {
            return null;
        }
        SoftReference cref = (SoftReference)entryMap.get(cls);
        EntryClassBase eclass = null;
        if (cref != null) {
            eclass = (EntryClassBase)cref.get();
        }
        if (eclass == null) {
            if (base) {
                if (!Modifier.isPublic(cls.getModifiers())) {
                    throw new IllegalArgumentException("entry class " + cls.getName() + " is not public");
                }
                try {
                    cls.getConstructor(noArg);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("entry class " + cls.getName() + " does not have a public no-arg constructor");
                }
            }
            eclass = new EntryClassBase(new EntryClass(cls, ClassMapper.toEntryClass(cls.getSuperclass())), null);
            entryMap.put(cls, new SoftReference<EntryClassBase>(eclass));
        }
        if (base && eclass.codebase == null) {
            eclass.setCodebase(cls);
        }
        return eclass;
    }

    private static EntryClass toEntryClass(Class cls) throws MarshalException {
        if (cls != null) {
            return ClassMapper.toEntryClassBase((Class)cls, (boolean)false).eclass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryField[] getFields(Class cls) {
        WeakHashMap weakHashMap = fieldMap;
        synchronized (weakHashMap) {
            SoftReference cref = (SoftReference)fieldMap.get(cls);
            EntryField[] efields = null;
            if (cref != null) {
                efields = (EntryField[])cref.get();
            }
            if (efields == null) {
                Field[] fields = cls.getFields();
                Arrays.sort(fields, comparator);
                int len = 0;
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 0x98) != 0) continue;
                    if (fields[i].getType().isPrimitive()) {
                        throw new IllegalArgumentException("entry class " + cls.getName() + " has a primitive field");
                    }
                    fields[len++] = fields[i];
                }
                efields = new EntryField[len];
                while (--len >= 0) {
                    efields[len] = new EntryField(fields[len]);
                }
                fieldMap.put(cls, new SoftReference<EntryField[]>(efields));
            }
            return efields;
        }
    }

    private static class FieldComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Field f1 = (Field)o1;
            Field f2 = (Field)o2;
            if (f1 == f2) {
                return 0;
            }
            if (f1.getDeclaringClass() == f2.getDeclaringClass()) {
                return f1.getName().compareTo(f2.getName());
            }
            if (f1.getDeclaringClass().isAssignableFrom(f2.getDeclaringClass())) {
                return -1;
            }
            return 1;
        }
    }

    static class EntryField {
        public final Field field;
        public final boolean marshal;

        public EntryField(Field field) {
            this.field = field;
            Class<?> c = field.getType();
            this.marshal = c != String.class && c != Integer.class && c != Boolean.class && c != Character.class && c != Long.class && c != Float.class && c != Double.class && c != Byte.class && c != Short.class;
        }
    }
}

