/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ConstrainableServiceLease;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarLease;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;

class ServiceLease
extends RegistrarLease {
    private static final long serialVersionUID = 2L;
    private static final String LEASE_TYPE = "service";
    transient ServiceID serviceID;

    static ServiceLease getInstance(Registrar server, ServiceID registrarID, ServiceID serviceID, Uuid leaseID, long expiration) {
        return server instanceof RemoteMethodControl ? new ConstrainableServiceLease(server, registrarID, serviceID, leaseID, expiration, null) : new ServiceLease(server, registrarID, serviceID, leaseID, expiration);
    }

    ServiceLease(Registrar server, ServiceID registrarID, ServiceID serviceID, Uuid leaseID, long expiration) {
        super(server, registrarID, leaseID, expiration);
        this.serviceID = serviceID;
    }

    public void cancel() throws UnknownLeaseException, RemoteException {
        this.server.cancelServiceLease(this.serviceID, this.leaseID);
    }

    protected long doRenew(long duration) throws UnknownLeaseException, RemoteException {
        return this.server.renewServiceLease(this.serviceID, this.leaseID, duration);
    }

    ServiceID getServiceID() {
        return this.serviceID;
    }

    Object getRegID() {
        return this.serviceID;
    }

    String getLeaseType() {
        return LEASE_TYPE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.serviceID.writeBytes((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serviceID = new ServiceID((DataInput)in);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

