/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.RegistrarProxy;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;

class EntryRep
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    public EntryClass eclass;
    public String codebase;
    public Object[] fields;

    public EntryRep(Entry entry) throws RemoteException {
        EntryClassBase ecb = ClassMapper.toEntryClassBase(entry.getClass());
        this.eclass = ecb.eclass;
        this.codebase = ecb.codebase;
        try {
            ClassMapper.EntryField[] efields = ClassMapper.getFields(entry.getClass());
            this.fields = new Object[efields.length];
            int i = efields.length;
            while (--i >= 0) {
                ClassMapper.EntryField f = efields[i];
                Object val = f.field.get(entry);
                if (f.marshal && val != null) {
                    val = new MarshalledWrapper(val);
                }
                this.fields[i] = val;
            }
        }
        catch (IOException e) {
            throw new MarshalException("error marshalling arguments", e);
        }
        catch (IllegalAccessException e) {
            throw new MarshalException("error marshalling arguments", e);
        }
    }

    public Entry get() {
        try {
            Class clazz = this.eclass.toClass(this.codebase);
            ClassMapper.EntryField[] efields = ClassMapper.getFields(clazz);
            Entry entry = (Entry)clazz.newInstance();
            int i = efields.length;
            while (--i >= 0) {
                Object val = this.fields[i];
                ClassMapper.EntryField f = efields[i];
                Field rf = f.field;
                try {
                    if (f.marshal && val != null) {
                        val = ((MarshalledWrapper)val).get();
                    }
                    rf.set(entry, val);
                }
                catch (Throwable e) {
                    if (e instanceof IllegalArgumentException) {
                        String msg = "unable to assign " + (val != null ? "value of type " + val.getClass().getName() : "null") + " to field " + rf.getDeclaringClass().getName() + "." + rf.getName() + " of type " + rf.getType().getName();
                        e = new ClassCastException(msg).initCause(e);
                    }
                    RegistrarProxy.handleException(e);
                }
            }
            return entry;
        }
        catch (Throwable e) {
            RegistrarProxy.handleException(e);
            return null;
        }
    }

    public int hashCode() {
        return this.eclass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntryRep) {
            EntryRep entry = (EntryRep)obj;
            if (!this.eclass.equals(entry.eclass) || this.fields.length != entry.fields.length) {
                return false;
            }
            int i = this.fields.length;
            while (--i >= 0) {
                if ((this.fields[i] != null || entry.fields[i] == null) && (this.fields[i] == null || this.fields[i].equals(entry.fields[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            EntryRep entry = (EntryRep)super.clone();
            entry.fields = (Object[])entry.fields.clone();
            return entry;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static EntryRep[] toEntryRep(Entry[] entries, boolean needCodebase) throws RemoteException {
        EntryRep[] reps = null;
        if (entries != null) {
            reps = new EntryRep[entries.length];
            int i = entries.length;
            while (--i >= 0) {
                if (entries[i] == null) continue;
                reps[i] = new EntryRep(entries[i]);
                if (needCodebase) continue;
                reps[i].codebase = null;
            }
        }
        return reps;
    }

    public static Entry[] toEntry(EntryRep[] reps) {
        Entry[] entries = null;
        if (reps != null) {
            entries = new Entry[reps.length];
            int i = reps.length;
            while (--i >= 0) {
                entries[i] = reps[i].get();
            }
        }
        return entries;
    }
}

