/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.AdminProxy;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.EventLease;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Matches;
import com.sun.jini.reggie.ProxyVerifier;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarEvent;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import com.sun.jini.reggie.RenewResults;
import com.sun.jini.reggie.ServiceLease;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reggie.Util;
import com.sun.jini.reggie.UuidGenerator;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.TaskManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.Constants;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalledInstance;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class RegistrarImpl
implements Registrar,
ProxyAccessor,
ServerProxyTrust {
    private static final long MAX_LEASE = 31536000000000L;
    private static final long MAX_RENEW = 31536000000L;
    private static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final int DEFAULT_MULTICAST_TTL = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final int LOG_VERSION = 3;
    private static final String COMPONENT = "com.sun.jini.reggie";
    private static final Uuid myLeaseID = UuidFactory.create((long)0L, (long)0L);
    private static final Logger logger = Logger.getLogger("com.sun.jini.reggie");
    private static final Entry[] baseAttrs = new Entry[]{new ServiceInfo("Lookup", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.3", "", ""), new BasicServiceType("Lookup")};
    private static final EntryRep[] emptyAttrs = new EntryRep[0];
    private RegistrarProxy proxy;
    private Exporter serverExporter;
    private Registrar myRef;
    private ServiceID myServiceID;
    private volatile LookupLocator myLocator;
    private LoginContext loginContext;
    private LifeCycle lifeCycle;
    private ServerSocketFactory serverSocketFactory;
    private SocketFactory socketFactory;
    private final HashMap serviceByID = new HashMap();
    private final TreeMap serviceByTime = new TreeMap();
    private final HashMap serviceByTypeName = new HashMap();
    private final HashMap serviceByAttr = new HashMap(23);
    private final HashMap serviceByEmptyAttr = new HashMap(11);
    private final ArrayList entryClasses = new ArrayList();
    private final HashMap eventByID = new HashMap(11);
    private final TreeMap eventByTime = new TreeMap();
    private final HashMap subEventByService = new HashMap(11);
    private final HashMap subEventByID = new HashMap(11);
    private UuidGenerator resourceIdGenerator;
    private UuidGenerator serviceIdGenerator = this.resourceIdGenerator = new UuidGenerator();
    private long eventID = 0L;
    private final Random random = new Random();
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredListenerPreparer = this.listenerPreparer = new BasicProxyPreparer();
    private ProxyPreparer locatorPreparer = this.listenerPreparer;
    private ProxyPreparer recoveredLocatorPreparer = this.listenerPreparer;
    private final ArrayList newNotifies = new ArrayList();
    private long maxServiceLease;
    private long maxEventLease;
    private long minSvcExpiration = Long.MAX_VALUE;
    private long minEventExpiration = Long.MAX_VALUE;
    private DiscoveryManagement discoer;
    private JoinManager joiner;
    private TaskManager tasker;
    private Thread serviceExpirer;
    private Thread eventExpirer;
    private UnicastThread unicaster;
    private Thread multicaster;
    private Thread announcer;
    private Thread snapshotter;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private final Object serviceNotifier = new Object();
    private final Object eventNotifier = new Object();
    private final Object snapshotNotifier = new Object();
    private ServiceType objectServiceType;
    private ReliableLog log;
    private boolean inRecovery;
    private boolean recoveredSnapshot = false;
    private int logFileSize = 0;
    private int persistenceSnapshotThreshold = 200;
    private float persistenceSnapshotWeight = 10.0f;
    private long minMaxServiceLease = 300000L;
    private long minMaxEventLease = 1800000L;
    private long minRenewalInterval = 100L;
    private int unicastPort = 0;
    private volatile String[] memberGroups = new String[]{""};
    private String[] lookupGroups = DiscoveryGroupManagement.NO_GROUPS;
    private LookupLocator[] lookupLocators = new LookupLocator[0];
    private Entry[] lookupAttrs;
    private long multicastAnnouncementInterval = 120000L;
    private volatile long announcementSeqNo = 0L;
    private NetworkInterface[] multicastInterfaces;
    private boolean multicastInterfacesSpecified;
    private int multicastInterfaceRetryInterval = 300000;
    private Discovery protocol2;
    private InvocationConstraints rawUnicastDiscoveryConstraints;
    private DiscoveryConstraints multicastRequestConstraints;
    private DiscoveryConstraints multicastAnnouncementConstraints;
    private DiscoveryConstraints unicastDiscoveryConstraints;
    private ClientSubjectChecker multicastRequestSubjectChecker;
    private volatile long unexportTimeout = 120000L;
    private volatile long unexportWait = 1000L;
    private ClientSubjectChecker unicastDiscoverySubjectChecker;
    private final ReadyState ready = new ReadyState();

    RegistrarImpl(String[] configArgs, boolean persistent, LifeCycle lifeCycle) throws Exception {
        try {
            Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)this.getClass().getClassLoader());
            this.loginAndRun(config, persistent, lifeCycle);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Reggie initialization failed", t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    RegistrarImpl(Configuration config, boolean persistent, LifeCycle lifeCycle) throws Exception {
        try {
            this.loginAndRun(config, persistent, lifeCycle);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Reggie initialization failed", t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    private void loginAndRun(final Configuration config, final boolean persistent, final LifeCycle lifeCycle) throws Throwable {
        this.loginContext = (LoginContext)config.getEntry(COMPONENT, "loginContext", LoginContext.class, null);
        PrivilegedExceptionAction init = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                RegistrarImpl.this.init(config, persistent, lifeCycle);
                return null;
            }
        };
        if (this.loginContext != null) {
            this.loginContext.login();
            try {
                Subject.doAsPrivileged(this.loginContext.getSubject(), init, null);
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        } else {
            init.run();
        }
    }

    public Object getServiceProxy() throws NoSuchObjectException {
        this.ready.check();
        return this.proxy;
    }

    public Object getProxy() {
        return this.myRef;
    }

    public TrustVerifier getProxyVerifier() throws NoSuchObjectException {
        this.ready.check();
        return new ProxyVerifier(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration register(Item nitem, long leaseDuration) throws NoSuchObjectException {
        ServiceRegistration serviceRegistration;
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            ServiceRegistration reg = this.registerDo(nitem, leaseDuration);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered instance of {0} as {1}", new Object[]{nitem.serviceType.getName(), reg.getServiceID()});
            }
            serviceRegistration = reg;
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return serviceRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledWrapper lookup(Template tmpl) throws NoSuchObjectException {
        MarshalledWrapper marshalledWrapper;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            marshalledWrapper = this.lookupDo(tmpl);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return marshalledWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matches lookup(Template tmpl, int maxMatches) throws NoSuchObjectException {
        Matches matches;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            matches = this.lookupDo(tmpl, maxMatches);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventRegistration notify(Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException {
        EventRegistration eventRegistration;
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            EventRegistration reg = this.notifyDo(tmpl, transitions, listener, handback, leaseDuration);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered event listener {0} as {1}", new Object[]{listener, ((ReferentUuid)reg.getLease()).getReferentUuid()});
            }
            eventRegistration = reg;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return eventRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryClassBase[] getEntryClasses(Template tmpl) throws NoSuchObjectException {
        EntryClassBase[] entryClassBaseArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            entryClassBaseArray = this.getEntryClassesDo(tmpl);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return entryClassBaseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getFieldValues(Template tmpl, int setIndex, int field) throws NoSuchObjectException {
        Object[] objectArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            objectArray = this.getFieldValuesDo(tmpl, setIndex, field);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTypeBase[] getServiceTypes(Template tmpl, String prefix) throws NoSuchObjectException {
        ServiceTypeBase[] serviceTypeBaseArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            serviceTypeBaseArray = this.getServiceTypesDo(tmpl, prefix);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return serviceTypeBaseArray;
    }

    public LookupLocator getLocator() throws NoSuchObjectException {
        this.ready.check();
        return this.myLocator;
    }

    public Object getAdmin() throws NoSuchObjectException {
        this.ready.check();
        return AdminProxy.getInstance(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.addAttributesDo(serviceID, leaseID, attrSets);
            this.addLogRecord(new AttrsAddedLogObj(serviceID, leaseID, attrSets));
            this.queueEvents();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSetTmpls, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.modifyAttributesDo(serviceID, leaseID, attrSetTmpls, attrSets);
            this.addLogRecord(new AttrsModifiedLogObj(serviceID, leaseID, attrSetTmpls, attrSets));
            this.queueEvents();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.setAttributesDo(serviceID, leaseID, attrSets);
            this.addLogRecord(new AttrsSetLogObj(serviceID, leaseID, attrSets));
            this.queueEvents();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServiceLease(ServiceID serviceID, Uuid leaseID) throws NoSuchObjectException, UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            this.cancelServiceLeaseDo(serviceID, leaseID);
            this.addLogRecord(new ServiceLeaseCancelledLogObj(serviceID, leaseID));
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{serviceID});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewServiceLease(ServiceID serviceID, Uuid leaseID, long renewDuration) throws NoSuchObjectException, UnknownLeaseException {
        long l;
        this.concurrentObj.priorityWriteLock();
        try {
            this.ready.check();
            l = this.renewServiceLeaseDo(serviceID, leaseID, renewDuration);
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEventLease(long eventID, Uuid leaseID) throws NoSuchObjectException, UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            this.cancelEventLeaseDo(eventID, leaseID);
            this.addLogRecord(new EventLeaseCancelledLogObj(eventID, leaseID));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{leaseID});
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewEventLease(long eventID, Uuid leaseID, long renewDuration) throws NoSuchObjectException, UnknownLeaseException {
        long l;
        this.concurrentObj.priorityWriteLock();
        try {
            this.ready.check();
            l = this.renewEventLeaseDo(eventID, leaseID, renewDuration);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenewResults renewLeases(Object[] regIDs, Uuid[] leaseIDs, long[] renewDurations) throws NoSuchObjectException {
        RenewResults renewResults;
        this.concurrentObj.priorityWriteLock();
        try {
            this.ready.check();
            renewResults = this.renewLeasesDo(regIDs, leaseIDs, renewDurations);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return renewResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] cancelLeases(Object[] regIDs, Uuid[] leaseIDs) throws NoSuchObjectException {
        Exception[] exceptionArray;
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            Exception[] exceptions = this.cancelLeasesDo(regIDs, leaseIDs);
            this.addLogRecord(new LeasesCancelledLogObj(regIDs, leaseIDs));
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                for (int i = 0; i < regIDs.length; ++i) {
                    if (exceptions != null && exceptions[i] != null) continue;
                    if (regIDs[i] instanceof ServiceID) {
                        logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{regIDs[i]});
                        continue;
                    }
                    logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{leaseIDs[i]});
                }
            }
            exceptionArray = exceptions;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
        return exceptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getLookupAttributes() throws NoSuchObjectException {
        Entry[] entryArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            entryArray = this.lookupAttrs;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return entryArray;
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                this.ready.check();
                EntryRep[] attrs = EntryRep.toEntryRep(attrSets, true);
                this.addAttributesDo(this.myServiceID, myLeaseID, attrs);
                this.joiner.addAttributes(attrSets);
                this.lookupAttrs = this.joiner.getAttributes();
                this.addLogRecord(new LookupAttributesChangedLogObj(this.lookupAttrs));
                this.queueEvents();
            }
            catch (UnknownLeaseException e) {
                throw new AssertionError((Object)"Self-registration never expires");
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                this.ready.check();
                EntryRep[] tmpls = EntryRep.toEntryRep(attrSetTemplates, false);
                EntryRep[] attrs = EntryRep.toEntryRep(attrSets, false);
                this.modifyAttributesDo(this.myServiceID, myLeaseID, tmpls, attrs);
                this.joiner.modifyAttributes(attrSetTemplates, attrSets, true);
                this.lookupAttrs = this.joiner.getAttributes();
                this.addLogRecord(new LookupAttributesChangedLogObj(this.lookupAttrs));
                this.queueEvents();
            }
            catch (UnknownLeaseException e) {
                throw new AssertionError((Object)"Self-registration never expires");
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLookupGroups() throws NoSuchObjectException {
        String[] stringArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            stringArray = this.lookupGroups;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)this.discoer;
            try {
                dgm.addGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = dgm.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup groups {0}", new Object[]{Arrays.asList(groups)});
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)this.discoer;
            dgm.removeGroups(groups);
            this.lookupGroups = dgm.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup groups {0}", new Object[]{Arrays.asList(groups)});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)this.discoer;
            try {
                dgm.setGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = dgm.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup groups {0}", new Object[]{groups != null ? Arrays.asList(groups) : null});
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupLocator[] getLookupLocators() throws NoSuchObjectException {
        LookupLocator[] lookupLocatorArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            lookupLocatorArray = this.lookupLocators;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return lookupLocatorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        locators = RegistrarImpl.prepareLocators(locators, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)this.discoer;
            dlm.addLocators(locators);
            this.lookupLocators = dlm.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        locators = RegistrarImpl.prepareLocators(locators, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)this.discoer;
            dlm.removeLocators(locators);
            this.lookupLocators = dlm.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        locators = RegistrarImpl.prepareLocators(locators, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)this.discoer;
            dlm.setLocators(locators);
            this.lookupLocators = dlm.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            for (int i = 0; i < groups.length; ++i) {
                if (RegistrarImpl.indexOf(this.memberGroups, groups[i]) >= 0) continue;
                this.memberGroups = (String[])RegistrarImpl.arrayAdd(this.memberGroups, groups[i]);
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added member groups {0}", new Object[]{Arrays.asList(groups)});
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            for (int i = 0; i < groups.length; ++i) {
                int j = RegistrarImpl.indexOf(this.memberGroups, groups[i]);
                if (j < 0) continue;
                this.memberGroups = (String[])RegistrarImpl.arrayDel(this.memberGroups, j);
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed member groups {0}", new Object[]{Arrays.asList(groups)});
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMemberGroups() throws NoSuchObjectException {
        String[] stringArray;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            stringArray = this.memberGroups;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberGroups(String[] groups) throws NoSuchObjectException {
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            this.memberGroups = (String[])RegistrarImpl.removeDups(groups);
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set member groups {0}", new Object[]{Arrays.asList(groups)});
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnicastPort() throws NoSuchObjectException {
        int n;
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            n = this.unicastPort;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
        this.concurrentObj.readUnlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUnicastPort(int port) throws IOException, RemoteException {
        block11: {
            block10: {
                block9: {
                    this.concurrentObj.writeLock();
                    try {
                        this.ready.check();
                        if (port == this.unicastPort) {
                            Object var6_2 = null;
                            break block9;
                        }
                        if (port == 0 && this.unicaster.port == 4160 || port == this.unicaster.port) {
                            this.unicastPort = port;
                            this.addLogRecord(new UnicastPortSetLogObj(port));
                            break block10;
                        }
                        UnicastThread newUnicaster = new UnicastThread(port);
                        this.unicaster.interrupt();
                        try {
                            this.unicaster.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.unicaster = newUnicaster;
                        this.unicaster.start();
                        this.unicastPort = port;
                        this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator(this.myLocator.getHost(), this.unicaster.port, null) : new LookupLocator(this.myLocator.getHost(), this.unicaster.port);
                        Thread thread = this.announcer;
                        synchronized (thread) {
                            this.announcer.notify();
                        }
                        this.addLogRecord(new UnicastPortSetLogObj(port));
                        if (logger.isLoggable(Level.CONFIG)) {
                            logger.log(Level.CONFIG, "changed unicast discovery port to {0}", new Object[]{new Integer(this.unicaster.port)});
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        this.concurrentObj.writeUnlock();
                        throw throwable;
                    }
                }
                this.concurrentObj.writeUnlock();
                return;
            }
            Object var6_3 = null;
            this.concurrentObj.writeUnlock();
            return;
        }
        Object var6_4 = null;
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws RemoteException {
        this.concurrentObj.priorityWriteLock();
        try {
            this.ready.check();
            logger.info("starting Reggie shutdown");
            this.ready.shutdown();
            new DestroyThread().start();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        this.concurrentObj.writeUnlock();
    }

    private static Object[] arrayAdd(Object[] array, Object elt) {
        int len = array.length;
        Object[] narray = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, narray, 0, len);
        narray[len] = elt;
        return narray;
    }

    private static Object[] arrayDel(Object[] array, int i) {
        int len = array.length - 1;
        Object[] narray = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        System.arraycopy(array, 0, narray, 0, i);
        System.arraycopy(array, i + 1, narray, i, len - i);
        return narray;
    }

    private static int indexOf(Object[] array, Object elt) {
        return RegistrarImpl.indexOf(array, array.length, elt);
    }

    private static int indexOf(Object[] array, int len, Object elt) {
        for (int i = 0; i < len; ++i) {
            if (!elt.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static boolean overlap(Object[] arr1, Object[] arr2) {
        int i = arr1.length;
        while (--i >= 0) {
            if (RegistrarImpl.indexOf(arr2, arr1[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean allNull(Object[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    private static Object[] removeDups(Object[] arr) {
        int i = arr.length;
        while (--i >= 0) {
            if (RegistrarImpl.indexOf(arr, i, arr[i]) < 0) continue;
            arr = RegistrarImpl.arrayDel(arr, i);
        }
        return arr;
    }

    private static EntryRep[] deleteSet(Item item, int i) {
        item.attributeSets = (EntryRep[])RegistrarImpl.arrayDel(item.attributeSets, i);
        return item.attributeSets;
    }

    private static Item copyItem(Item item) {
        item = (Item)item.clone();
        item.serviceType = null;
        item.codebase = null;
        EntryRep[] attrSets = item.attributeSets;
        int i = attrSets.length;
        while (--i >= 0) {
            attrSets[i].eclass = attrSets[i].eclass.getReplacement();
        }
        return item;
    }

    private static EntryClass getDefiningClass(EntryClass eclass, int fldidx) {
        EntryClass sup;
        while ((sup = eclass.getSuperclass()).getNumFields() > fldidx) {
            eclass = sup;
        }
        return eclass;
    }

    private void addServiceByTypes(ServiceType type, SvcReg reg) {
        HashMap<ServiceID, SvcReg> map = (HashMap<ServiceID, SvcReg>)this.serviceByTypeName.get(type.getName());
        if (map == null) {
            map = new HashMap<ServiceID, SvcReg>();
            this.serviceByTypeName.put(type.getName(), map);
        }
        map.put(reg.item.serviceID, reg);
        ServiceType[] ifaces = type.getInterfaces();
        int i = ifaces.length;
        while (--i >= 0) {
            this.addServiceByTypes(ifaces[i], reg);
        }
        ServiceType sup = type.getSuperclass();
        if (sup != null) {
            this.addServiceByTypes(sup, reg);
        }
    }

    private void deleteServiceFromTypes(ServiceType type, SvcReg reg) {
        Map map = (Map)this.serviceByTypeName.get(type.getName());
        if (map != null) {
            map.remove(reg.item.serviceID);
            if (map.isEmpty() && !type.equals(this.objectServiceType)) {
                this.serviceByTypeName.remove(type.getName());
            }
            ServiceType[] ifaces = type.getInterfaces();
            int j = ifaces.length;
            while (--j >= 0) {
                this.deleteServiceFromTypes(ifaces[j], reg);
            }
            ServiceType sup = type.getSuperclass();
            if (sup != null) {
                this.deleteServiceFromTypes(sup, reg);
            }
        }
    }

    private static boolean matchItem(Template tmpl, Item item) {
        return (tmpl.serviceID == null || tmpl.serviceID.equals((Object)item.serviceID)) && RegistrarImpl.matchType(tmpl.serviceTypes, item.serviceType) && RegistrarImpl.matchAttributes(tmpl, item);
    }

    private static boolean matchType(ServiceType[] types, ServiceType type) {
        if (types != null) {
            int i = types.length;
            while (--i >= 0) {
                if (types[i].isAssignableFrom(type)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchEntry(EntryRep tmpl, EntryRep entry) {
        if (!tmpl.eclass.isAssignableFrom(entry.eclass) || tmpl.fields.length > entry.fields.length) {
            return false;
        }
        int i = tmpl.fields.length;
        while (--i >= 0) {
            if (tmpl.fields[i] == null || tmpl.fields[i].equals(entry.fields[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAttributes(Template tmpl, Item item) {
        EntryRep[] tmpls = tmpl.attributeSetTemplates;
        if (tmpls != null) {
            EntryRep[] entries = item.attributeSets;
            int i = tmpls.length;
            block0: while (--i >= 0) {
                EntryRep etmpl = tmpls[i];
                int j = entries.length;
                while (--j >= 0) {
                    if (!RegistrarImpl.matchEntry(etmpl, entries[j])) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean attrMatch(EntryRep[] tmpls, EntryRep attrSet) {
        boolean good = true;
        if (tmpls != null) {
            int i = tmpls.length;
            while (--i >= 0) {
                EntryRep tmpl = tmpls[i];
                if (!RegistrarImpl.matchEntry(tmpl, attrSet)) continue;
                if (tmpl.eclass.isAssignableFrom(attrSet.eclass) && !tmpl.eclass.equals(attrSet.eclass)) {
                    return true;
                }
                good = false;
            }
        }
        return good;
    }

    private static boolean hasAttr(SvcReg reg, EntryClass eclass, int fldidx, Object value) {
        EntryRep[] sets = reg.item.attributeSets;
        int i = sets.length;
        while (--i >= 0) {
            EntryRep set = sets[i];
            if (!eclass.isAssignableFrom(set.eclass) || (value != null || set.fields[fldidx] != null) && (value == null || !value.equals(set.fields[fldidx]))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEmptyAttr(SvcReg reg, EntryClass eclass) {
        EntryRep[] sets = reg.item.attributeSets;
        int i = sets.length;
        while (--i >= 0) {
            if (!eclass.equals(sets[i].eclass)) continue;
            return true;
        }
        return false;
    }

    private static void addTypes(ArrayList types, ArrayList codebases, ServiceType[] bases, String prefix, ServiceType type, String codebase) {
        if (types.contains(type)) {
            return;
        }
        if (bases != null) {
            int i = bases.length;
            while (--i >= 0) {
                if (!type.isAssignableFrom(bases[i])) continue;
                return;
            }
        }
        if (prefix == null || type.getName().startsWith(prefix)) {
            types.add(type);
            codebases.add(codebase);
            return;
        }
        ServiceType[] ifs = type.getInterfaces();
        int i = ifs.length;
        while (--i >= 0) {
            RegistrarImpl.addTypes(types, codebases, bases, prefix, ifs[i], codebase);
        }
        ServiceType sup = type.getSuperclass();
        if (sup != null) {
            RegistrarImpl.addTypes(types, codebases, bases, prefix, sup, codebase);
        }
    }

    private static long limitDuration(long leaseDuration, long limit) {
        if (leaseDuration == -1L || leaseDuration > limit) {
            leaseDuration = limit;
        } else if (leaseDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return leaseDuration;
    }

    private static void marshalAttributes(Entry[] attrs, ObjectOutputStream out) throws IOException {
        for (int i = 0; i < attrs.length; ++i) {
            out.writeObject(new MarshalledInstance((Object)attrs[i]));
        }
        out.writeObject(null);
    }

    private static Entry[] unmarshalAttributes(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ArrayList<Entry> attributes = new ArrayList<Entry>();
        MarshalledInstance mi = null;
        while ((mi = (MarshalledInstance)in.readObject()) != null) {
            try {
                attributes.add((Entry)mi.get(false));
            }
            catch (Throwable e) {
                if (e instanceof Error && ThrowableConstants.retryable(e) == 2) {
                    throw (Error)e;
                }
                logger.log(Level.WARNING, "failed to recover LUS attribute", e);
            }
        }
        Entry[] attrs = new Entry[attributes.size()];
        return attributes.toArray(attrs);
    }

    private static void marshalLocators(LookupLocator[] locators, ObjectOutputStream out) throws IOException {
        for (int i = 0; i < locators.length; ++i) {
            out.writeObject(new MarshalledInstance((Object)locators[i]));
        }
        out.writeObject(null);
    }

    private static LookupLocator[] unmarshalLocators(ObjectInputStream in) throws IOException, ClassNotFoundException {
        MarshalledInstance mi;
        ArrayList<LookupLocator> l = new ArrayList<LookupLocator>();
        while ((mi = (MarshalledInstance)in.readObject()) != null) {
            try {
                l.add((LookupLocator)mi.get(false));
            }
            catch (Throwable e) {
                if (e instanceof Error && ThrowableConstants.retryable(e) == 2) {
                    throw (Error)e;
                }
                logger.log(Level.WARNING, "failed to recover lookup locator", e);
            }
        }
        return l.toArray(new LookupLocator[l.size()]);
    }

    private static LookupLocator[] prepareLocators(LookupLocator[] locators, ProxyPreparer preparer, boolean tolerateFailures) throws RemoteException {
        ArrayList<LookupLocator> l = new ArrayList<LookupLocator>();
        for (int i = 0; i < locators.length; ++i) {
            try {
                l.add((LookupLocator)preparer.prepareProxy((Object)locators[i]));
                continue;
            }
            catch (Exception e) {
                if (!tolerateFailures) {
                    if (e instanceof RemoteException) {
                        throw (RemoteException)e;
                    }
                    throw (RuntimeException)e;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                RegistrarImpl.logThrow(Level.WARNING, RegistrarImpl.class.getName(), "prepareLocators", "failed to prepare lookup locator {0}", new Object[]{locators[i]}, e);
            }
        }
        return l.toArray(new LookupLocator[l.size()]);
    }

    private static void logThrow(Level level, String className, String methodName, String message, Object[] args, Throwable thrown) {
        java.util.logging.LogRecord lr = new java.util.logging.LogRecord(level, message);
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(className);
        lr.setSourceMethodName(methodName);
        lr.setParameters(args);
        lr.setThrown(thrown);
        logger.log(lr);
    }

    private void addService(SvcReg reg) {
        this.serviceByID.put(reg.item.serviceID, reg);
        this.serviceByTime.put(reg, reg);
        this.addServiceByTypes(reg.item.serviceType, reg);
        EntryRep[] entries = reg.item.attributeSets;
        int i = entries.length;
        while (--i >= 0) {
            this.addAttrs(reg, entries[i]);
        }
        this.computeMaxLeases();
    }

    private void deleteService(SvcReg reg, long now) {
        Item item = reg.item;
        this.generateEvents(item, null, now);
        this.serviceByID.remove(item.serviceID);
        this.serviceByTime.remove(reg);
        this.deleteServiceFromTypes(item.serviceType, reg);
        EntryRep[] entries = item.attributeSets;
        int i = entries.length;
        while (--i >= 0) {
            this.deleteAttrs(reg, entries[i], false);
        }
        this.computeMaxLeases();
    }

    private void addEvent(EventReg reg) {
        if (reg.listener == null) {
            return;
        }
        EntryRep[] tmpls = reg.tmpl.attributeSetTemplates;
        if (tmpls != null) {
            int i = tmpls.length;
            while (--i >= 0) {
                EntryClass eclass = tmpls[i].eclass;
                eclass.setNumTemplates(eclass.getNumTemplates() + 1);
            }
        }
        Long id = new Long(reg.eventID);
        this.eventByID.put(id, reg);
        this.eventByTime.put(reg, reg);
        if (reg.tmpl.serviceID != null) {
            Object val = this.subEventByService.get(reg.tmpl.serviceID);
            val = val == null ? reg : (val instanceof EventReg ? new EventReg[]{(EventReg)val, reg} : RegistrarImpl.arrayAdd((EventReg[])val, reg));
            this.subEventByService.put(reg.tmpl.serviceID, val);
        } else {
            this.subEventByID.put(id, reg);
        }
        this.computeMaxLeases();
    }

    private void deleteEvent(EventReg reg) {
        EntryRep[] tmpls = reg.tmpl.attributeSetTemplates;
        if (tmpls != null) {
            int i = tmpls.length;
            while (--i >= 0) {
                EntryClass eclass = tmpls[i].eclass;
                eclass.setNumTemplates(eclass.getNumTemplates() - 1);
            }
        }
        Long id = new Long(reg.eventID);
        this.eventByID.remove(id);
        this.eventByTime.remove(reg);
        if (reg.tmpl.serviceID != null) {
            Object val = this.subEventByService.get(reg.tmpl.serviceID);
            if (val == reg) {
                this.subEventByService.remove(reg.tmpl.serviceID);
            } else {
                Object[] array = (EventReg[])val;
                val = (array = RegistrarImpl.arrayDel(array, RegistrarImpl.indexOf(array, reg))).length == 1 ? array[0] : array;
                this.subEventByService.put(reg.tmpl.serviceID, val);
            }
        } else {
            this.subEventByID.remove(id);
        }
        this.computeMaxLeases();
    }

    private void addAttrs(SvcReg reg, EntryRep entry) {
        EntryClass eclass = entry.eclass;
        this.addInstance(eclass);
        Object[] fields = entry.fields;
        if (fields.length > 0) {
            int i = fields.length;
            while (--i >= 0) {
                eclass = RegistrarImpl.getDefiningClass(eclass, i);
                this.addAttr(reg, eclass, i, fields[i]);
            }
            return;
        }
        ArrayList<SvcReg> regs = (ArrayList<SvcReg>)this.serviceByEmptyAttr.get(eclass);
        if (regs == null) {
            regs = new ArrayList<SvcReg>(2);
            regs.add(reg);
            this.serviceByEmptyAttr.put(eclass, regs);
        } else if (!regs.contains(reg)) {
            regs.add(reg);
        }
    }

    private void deleteAttrs(SvcReg reg, EntryRep entry, boolean checkDups) {
        EntryClass eclass = entry.eclass;
        this.deleteInstance(eclass);
        Object[] fields = entry.fields;
        if (fields.length == 0) {
            ArrayList regs = (ArrayList)this.serviceByEmptyAttr.get(eclass);
            if (regs == null || checkDups && RegistrarImpl.hasEmptyAttr(reg, eclass)) {
                return;
            }
            int idx = regs.indexOf(reg);
            if (idx >= 0) {
                regs.remove(idx);
                if (regs.isEmpty()) {
                    this.serviceByEmptyAttr.remove(eclass);
                }
            }
            return;
        }
        int fldidx = fields.length;
        while (--fldidx >= 0) {
            int idx;
            Object value;
            HashMap map;
            ArrayList regs;
            Object[] attrMaps = (HashMap[])this.serviceByAttr.get(eclass = RegistrarImpl.getDefiningClass(eclass, fldidx));
            if (attrMaps == null || attrMaps[fldidx] == null || checkDups && RegistrarImpl.hasAttr(reg, eclass, fldidx, fields[fldidx]) || (regs = (ArrayList)(map = attrMaps[fldidx]).get(value = fields[fldidx])) == null || (idx = regs.indexOf(reg)) < 0) continue;
            regs.remove(idx);
            if (!regs.isEmpty()) continue;
            map.remove(value);
            if (!map.isEmpty()) continue;
            attrMaps[fldidx] = null;
            if (!RegistrarImpl.allNull(attrMaps)) continue;
            this.serviceByAttr.remove(eclass);
        }
    }

    private void updateAttrs(SvcReg reg, EntryRep entry, Object[] values) {
        EntryClass eclass = entry.eclass;
        int fldidx = values.length;
        while (--fldidx >= 0) {
            Object oval = entry.fields[fldidx];
            Object nval = values[fldidx];
            if (nval == null || nval.equals(oval)) continue;
            eclass = RegistrarImpl.getDefiningClass(eclass, fldidx);
            HashMap map = this.addAttr(reg, eclass, fldidx, nval);
            entry.fields[fldidx] = nval;
            if (RegistrarImpl.hasAttr(reg, eclass, fldidx, oval)) continue;
            ArrayList regs = (ArrayList)map.get(oval);
            regs.remove(regs.indexOf(reg));
            if (!regs.isEmpty()) continue;
            map.remove(oval);
        }
    }

    private HashMap addAttr(SvcReg reg, EntryClass eclass, int fldidx, Object value) {
        ArrayList<SvcReg> regs;
        HashMap map;
        HashMap[] attrMaps = (HashMap[])this.serviceByAttr.get(eclass);
        if (attrMaps == null) {
            attrMaps = new HashMap[eclass.getNumFields()];
            this.serviceByAttr.put(eclass, attrMaps);
        }
        if ((map = attrMaps[fldidx]) == null) {
            attrMaps[fldidx] = map = new HashMap(11);
        }
        if ((regs = (ArrayList<SvcReg>)map.get(value)) == null) {
            regs = new ArrayList<SvcReg>(3);
            map.put(value, regs);
        } else if (regs.contains(reg)) {
            return map;
        }
        regs.add(reg);
        return map;
    }

    private void addInstance(EntryClass eclass) {
        int idx = this.entryClasses.indexOf(eclass);
        if (idx < 0) {
            this.entryClasses.add(eclass);
            idx = this.entryClasses.size() - 1;
        }
        eclass = (EntryClass)this.entryClasses.get(idx);
        eclass.setNumInstances(eclass.getNumInstances() + 1);
    }

    private void deleteInstance(EntryClass eclass) {
        int idx = this.entryClasses.indexOf(eclass);
        int num = (eclass = (EntryClass)this.entryClasses.get(idx)).getNumInstances() - 1;
        if (num == 0) {
            this.entryClasses.remove(idx);
        }
        eclass.setNumInstances(num);
    }

    private ItemIter matchingItems(Template tmpl) {
        if (tmpl.serviceID != null) {
            return new IDItemIter(tmpl);
        }
        if (!RegistrarImpl.isEmpty(tmpl.serviceTypes)) {
            return new SvcIterator(tmpl);
        }
        Object[] sets = tmpl.attributeSetTemplates;
        if (RegistrarImpl.isEmpty(sets)) {
            return new AllItemIter();
        }
        int i = sets.length;
        while (--i >= 0) {
            Object[] fields = ((EntryRep)sets[i]).fields;
            if (fields.length == 0) {
                EntryClass eclass = this.getEmptyEntryClass(((EntryRep)sets[i]).eclass);
                if (eclass == null) continue;
                return new EmptyAttrItemIter(tmpl, eclass);
            }
            int j = fields.length;
            while (--j >= 0) {
                if (fields[j] == null) continue;
                return new AttrItemIter(tmpl, i, j);
            }
        }
        return new ClassItemIter(tmpl);
    }

    private EntryClass getEmptyEntryClass(EntryClass eclass) {
        EntryClass match = null;
        int i = this.entryClasses.size();
        while (--i >= 0) {
            EntryClass cand = (EntryClass)this.entryClasses.get(i);
            if (!eclass.isAssignableFrom(cand)) continue;
            if (cand.getNumFields() != 0 || match != null) {
                return null;
            }
            match = cand;
        }
        return match;
    }

    private ArrayList matchingServices(ServiceType[] types) {
        ArrayList matches = new ArrayList();
        if (RegistrarImpl.isEmpty(types)) {
            Map map = (Map)this.serviceByTypeName.get(this.objectServiceType.getName());
            matches.addAll(map.values());
        } else {
            Map map = (Map)this.serviceByTypeName.get(types[0].getName());
            if (map != null) {
                matches.addAll(map.values());
            }
            if (types.length > 1) {
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    SvcReg reg = (SvcReg)it.next();
                    if (RegistrarImpl.matchType(types, reg.item.serviceType)) continue;
                    it.remove();
                }
            }
        }
        return matches;
    }

    private String pickCodebase(EntryClass eclass, long now) throws ClassNotFoundException {
        if (eclass.getNumFields() == 0) {
            return this.pickCodebase(eclass, (ArrayList)this.serviceByEmptyAttr.get(eclass), now);
        }
        int fldidx = eclass.getNumFields() - 1;
        HashMap[] attrMaps = (HashMap[])this.serviceByAttr.get(RegistrarImpl.getDefiningClass(eclass, fldidx));
        Iterator iter = attrMaps[fldidx].values().iterator();
        while (iter.hasNext()) {
            try {
                return this.pickCodebase(eclass, (ArrayList)iter.next(), now);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(EntryClass eclass, ArrayList svcs, long now) throws ClassNotFoundException {
        int i = svcs.size();
        while (--i >= 0) {
            SvcReg reg = (SvcReg)svcs.get(i);
            if (reg.leaseExpiration <= now) continue;
            EntryRep[] sets = reg.item.attributeSets;
            int j = sets.length;
            while (--j >= 0) {
                if (!eclass.equals(sets[j].eclass)) continue;
                return sets[j].codebase;
            }
        }
        throw new ClassNotFoundException();
    }

    private void computeMaxLeases() {
        if (this.inRecovery) {
            return;
        }
        this.maxServiceLease = Math.max(this.minMaxServiceLease, this.minRenewalInterval * ((long)this.serviceByID.size() + (long)this.eventByID.size() * this.minMaxServiceLease / this.minMaxEventLease));
        this.maxEventLease = Math.max(this.minMaxEventLease, this.maxServiceLease * this.minMaxEventLease / this.minMaxServiceLease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respond(Socket socket) throws Exception {
        try {
            block7: {
                try {
                    socket.setTcpNoDelay(true);
                    socket.setKeepAlive(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block7;
                    logger.log(Levels.HANDLED, "problem setting socket options", e);
                }
            }
            socket.setSoTimeout(this.unicastDiscoveryConstraints.getUnicastSocketTimeout(60000));
            int pv = new DataInputStream(socket.getInputStream()).readInt();
            this.unicastDiscoveryConstraints.checkProtocolVersion(pv);
            this.getDiscovery(pv).handleUnicastDiscovery(new UnicastResponse(this.myLocator.getHost(), this.myLocator.getPort(), this.memberGroups, (ServiceRegistrar)this.proxy), socket, this.unicastDiscoveryConstraints.getUnfulfilledConstraints(), this.unicastDiscoverySubjectChecker, (Collection)Collections.EMPTY_LIST);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "exception closing socket", e);
            }
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            logger.log(Levels.HANDLED, "exception closing socket", e);
        }
    }

    private Discovery getDiscovery(int version) throws DiscoveryProtocolException {
        switch (version) {
            case 1: {
                return Discovery.getProtocol1();
            }
            case 2: {
                return this.protocol2;
            }
        }
        throw new DiscoveryProtocolException("unsupported protocol version: " + version);
    }

    private void closeRequestSockets(ArrayList tasks) {
        int i = tasks.size();
        while (--i >= 0) {
            Object obj = tasks.get(i);
            if (!(obj instanceof SocketTask)) continue;
            try {
                ((SocketTask)obj).socket.close();
            }
            catch (IOException e) {}
        }
    }

    private void init(Configuration config, boolean persistent, LifeCycle lifeCycle) throws IOException, ConfigurationException {
        String unicastDiscoveryHost;
        MethodConstraints discoveryConstraints;
        this.lifeCycle = lifeCycle;
        this.serverSocketFactory = (ServerSocketFactory)config.getEntry(COMPONENT, "serverSocketFactory", ServerSocketFactory.class, (Object)ServerSocketFactory.getDefault(), Configuration.NO_DATA);
        this.socketFactory = (SocketFactory)config.getEntry(COMPONENT, "socketFactory", SocketFactory.class, (Object)SocketFactory.getDefault(), Configuration.NO_DATA);
        if (persistent) {
            this.persistenceSnapshotThreshold = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"persistenceSnapshotThreshold", (int)this.persistenceSnapshotThreshold, (int)0, (int)Integer.MAX_VALUE);
            String persistenceDirectory = (String)config.getEntry(COMPONENT, "persistenceDirectory", String.class);
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"recoveredListenerPreparer", ProxyPreparer.class, (Object)this.recoveredListenerPreparer);
            this.recoveredLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"recoveredLocatorPreparer", ProxyPreparer.class, (Object)this.recoveredLocatorPreparer);
            this.persistenceSnapshotWeight = Config.getFloatEntry((Configuration)config, (String)COMPONENT, (String)"persistenceSnapshotWeight", (float)this.persistenceSnapshotWeight, (float)0.0f, (float)Float.MAX_VALUE);
            this.log = new ReliableLog(persistenceDirectory, (LogHandler)new LocalLogHandler());
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "using persistence directory {0}", new Object[]{persistenceDirectory});
            }
            this.inRecovery = true;
            this.log.recover();
            this.inRecovery = false;
        } else {
            this.log = null;
        }
        this.serverExporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"serverExporter", Exporter.class, (Object)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory()));
        if (!this.recoveredSnapshot) {
            Entry[] initialLookupAttributes = (Entry[])config.getEntry(COMPONENT, "initialLookupAttributes", Entry[].class, (Object)new Entry[0]);
            this.lookupGroups = (String[])config.getEntry(COMPONENT, "initialLookupGroups", String[].class, (Object)this.lookupGroups);
            this.lookupLocators = (LookupLocator[])config.getEntry(COMPONENT, "initialLookupLocators", LookupLocator[].class, (Object)this.lookupLocators);
            this.memberGroups = (String[])config.getEntry(COMPONENT, "initialMemberGroups", String[].class, (Object)this.memberGroups);
            if (this.memberGroups == null) {
                throw new ConfigurationException("member groups cannot be ALL_GROUPS (null)");
            }
            this.memberGroups = (String[])RegistrarImpl.removeDups(this.memberGroups);
            this.unicastPort = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"initialUnicastDiscoveryPort", (int)this.unicastPort, (int)0, (int)65535);
            if (initialLookupAttributes != null && initialLookupAttributes.length > 0) {
                ArrayList<Entry> l = new ArrayList<Entry>(Arrays.asList(baseAttrs));
                l.addAll(Arrays.asList(initialLookupAttributes));
                this.lookupAttrs = l.toArray(new Entry[l.size()]);
            } else {
                this.lookupAttrs = baseAttrs;
            }
        }
        if ((discoveryConstraints = (MethodConstraints)config.getEntry(COMPONENT, "discoveryConstraints", MethodConstraints.class, null)) == null) {
            discoveryConstraints = new BasicMethodConstraints(InvocationConstraints.EMPTY);
        }
        try {
            this.discoer = (DiscoveryManagement)config.getEntry(COMPONENT, "discoveryManager", DiscoveryManagement.class);
        }
        catch (NoSuchEntryException e) {
            this.discoer = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, null, null, config);
        }
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"listenerPreparer", ProxyPreparer.class, (Object)this.listenerPreparer);
        this.locatorPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"locatorPreparer", ProxyPreparer.class, (Object)this.locatorPreparer);
        this.minMaxEventLease = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minMaxEventLease", (long)this.minMaxEventLease, (long)1L, (long)31536000000000L);
        this.minMaxServiceLease = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minMaxServiceLease", (long)this.minMaxServiceLease, (long)1L, (long)31536000000000L);
        this.minRenewalInterval = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minRenewalInterval", (long)this.minRenewalInterval, (long)0L, (long)31536000000L);
        this.multicastAnnouncementInterval = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"multicastAnnouncementInterval", (long)this.multicastAnnouncementInterval, (long)1L, (long)Long.MAX_VALUE);
        this.multicastInterfaceRetryInterval = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"multicastInterfaceRetryInterval", (int)this.multicastInterfaceRetryInterval, (int)1, (int)Integer.MAX_VALUE);
        try {
            this.multicastInterfaces = (NetworkInterface[])config.getEntry(COMPONENT, "multicastInterfaces", NetworkInterface[].class);
            this.multicastInterfacesSpecified = true;
        }
        catch (NoSuchEntryException e) {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> l = en != null ? Collections.list(en) : Collections.EMPTY_LIST;
            this.multicastInterfaces = l.toArray(new NetworkInterface[l.size()]);
            this.multicastInterfacesSpecified = false;
        }
        if (this.multicastInterfaces == null) {
            logger.config("using system default interface for multicast");
        } else if (this.multicastInterfaces.length == 0) {
            if (this.multicastInterfacesSpecified) {
                logger.config("multicast disabled");
            } else {
                logger.severe("no network interfaces detected");
            }
        } else if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "multicasting on interfaces {0}", new Object[]{Arrays.asList(this.multicastInterfaces)});
        }
        try {
            this.multicastRequestSubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"multicastRequestSubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException e) {
            // empty catch block
        }
        this.resourceIdGenerator = (UuidGenerator)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"resourceIdGenerator", UuidGenerator.class, (Object)this.resourceIdGenerator);
        this.serviceIdGenerator = (UuidGenerator)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"serviceIdGenerator", UuidGenerator.class, (Object)this.serviceIdGenerator);
        this.tasker = (TaskManager)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"taskManager", TaskManager.class, (Object)new TaskManager(50, 15000L, 1.0f));
        this.unexportTimeout = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"unexportTimeout", (long)this.unexportTimeout, (long)0L, (long)Long.MAX_VALUE);
        this.unexportWait = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"unexportWait", (long)this.unexportWait, (long)0L, (long)Long.MAX_VALUE);
        try {
            unicastDiscoveryHost = (String)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"unicastDiscoveryHost", String.class);
        }
        catch (NoSuchEntryException e) {
            unicastDiscoveryHost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        try {
            this.unicastDiscoverySubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"unicastDiscoverySubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException e) {
            // empty catch block
        }
        this.objectServiceType = new ServiceType(Object.class, null, null);
        this.computeMaxLeases();
        this.protocol2 = Discovery.getProtocol2(null);
        this.rawUnicastDiscoveryConstraints = discoveryConstraints.getConstraints(DiscoveryConstraints.unicastDiscoveryMethod);
        this.multicastRequestConstraints = DiscoveryConstraints.process((InvocationConstraints)discoveryConstraints.getConstraints(DiscoveryConstraints.multicastRequestMethod));
        this.multicastAnnouncementConstraints = DiscoveryConstraints.process((InvocationConstraints)discoveryConstraints.getConstraints(DiscoveryConstraints.multicastAnnouncementMethod));
        this.unicastDiscoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)this.rawUnicastDiscoveryConstraints);
        this.serviceExpirer = new ServiceExpireThread();
        this.eventExpirer = new EventExpireThread();
        this.unicaster = new UnicastThread(this.unicastPort);
        this.multicaster = new MulticastThread();
        this.announcer = new AnnounceThread();
        this.snapshotter = new SnapshotThread();
        if (this.myServiceID == null) {
            this.myServiceID = this.newServiceID();
        }
        this.myRef = (Registrar)this.serverExporter.export((Remote)this);
        this.proxy = RegistrarProxy.getInstance(this.myRef, this.myServiceID);
        this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator(unicastDiscoveryHost, this.unicaster.port, null) : new LookupLocator(unicastDiscoveryHost, this.unicaster.port);
        Item item = new Item(new ServiceItem(this.myServiceID, (Object)this.proxy, this.lookupAttrs));
        SvcReg reg = new SvcReg(item, myLeaseID, Long.MAX_VALUE);
        this.addService(reg);
        if (this.log != null) {
            this.log.snapshot();
        }
        try {
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)this.discoer;
            String[] groups = dgm.getGroups();
            if (groups == null || groups.length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no groups");
            }
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)this.discoer;
            if (dlm.getLocators().length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no locators");
            }
            dgm.setGroups(this.lookupGroups);
            dlm.setLocators(this.lookupLocators);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(null, (Throwable)e);
        }
        this.joiner = new JoinManager((Object)this.proxy, this.lookupAttrs, this.myServiceID, this.discoer, null, config);
        this.serviceExpirer.start();
        this.eventExpirer.start();
        this.unicaster.start();
        this.multicaster.start();
        this.announcer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    RegistrarImpl.this.announcer.interrupt();
                    RegistrarImpl.this.announcer.join();
                }
                catch (Throwable t) {
                    RegistrarImpl.logThrow(Level.FINEST, this.getClass().getName(), "run", "exception shutting announcer down", new Object[0], t);
                }
            }
        }));
        this.snapshotter.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "started Reggie: {0}, {1}, {2}", new Object[]{this.myServiceID, Arrays.asList(this.memberGroups), this.myLocator});
        }
        this.ready.ready();
    }

    private ServiceRegistration registerDo(Item nitem, long leaseDuration) {
        SvcReg reg;
        if (nitem.service == null) {
            throw new NullPointerException("null service");
        }
        if (this.myServiceID.equals((Object)nitem.serviceID)) {
            throw new IllegalArgumentException("reserved service id");
        }
        nitem.attributeSets = nitem.attributeSets == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(nitem.attributeSets);
        leaseDuration = RegistrarImpl.limitDuration(leaseDuration, this.maxServiceLease);
        long now = System.currentTimeMillis();
        if (nitem.serviceID == null) {
            Map svcs = (Map)this.serviceByTypeName.get(nitem.serviceType.getName());
            if (svcs != null) {
                for (SvcReg reg2 : svcs.values()) {
                    if (!nitem.service.equals((Object)reg2.item.service)) continue;
                    nitem.serviceID = reg2.item.serviceID;
                    this.deleteService(reg2, now);
                    break;
                }
            }
            if (nitem.serviceID == null) {
                nitem.serviceID = this.newServiceID();
            }
        } else {
            reg = (SvcReg)this.serviceByID.get(nitem.serviceID);
            if (reg != null) {
                this.deleteService(reg, now);
            }
        }
        Util.checkRegistrantServiceID(nitem.serviceID, logger, Level.FINE);
        reg = new SvcReg(nitem, this.newLeaseID(), now + leaseDuration);
        this.addService(reg);
        this.generateEvents(null, nitem, now);
        this.addLogRecord(new SvcRegisteredLogObj(reg));
        this.queueEvents();
        if (reg.leaseExpiration < this.minSvcExpiration) {
            this.minSvcExpiration = reg.leaseExpiration;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return Registration.getInstance(this.myRef, ServiceLease.getInstance(this.myRef, this.myServiceID, nitem.serviceID, reg.leaseID, reg.leaseExpiration));
    }

    private MarshalledWrapper lookupDo(Template tmpl) {
        if (RegistrarImpl.isEmpty(tmpl.serviceTypes) || tmpl.serviceID != null) {
            ItemIter iter = this.matchingItems(tmpl);
            if (iter.hasNext()) {
                return iter.next().service;
            }
            return null;
        }
        ArrayList services = this.matchingServices(tmpl.serviceTypes);
        long now = System.currentTimeMillis();
        int slen = services.size();
        if (slen == 0) {
            return null;
        }
        int srand = Math.abs(this.random.nextInt()) % slen;
        for (int i = 0; i < slen; ++i) {
            SvcReg reg = (SvcReg)services.get((i + srand) % slen);
            if (reg.leaseExpiration <= now || !RegistrarImpl.matchAttributes(tmpl, reg.item)) continue;
            return reg.item.service;
        }
        return null;
    }

    private Matches lookupDo(Template tmpl, int maxMatches) {
        if (maxMatches < 0) {
            throw new IllegalArgumentException("negative maxMatches");
        }
        int totalMatches = 0;
        ArrayList<Item> matches = null;
        ItemIter iter = this.matchingItems(tmpl);
        if (maxMatches > 0 || iter.dupsPossible) {
            matches = new ArrayList<Item>();
        }
        if (iter.dupsPossible) {
            while (iter.hasNext()) {
                Item item = iter.next();
                if (matches.contains(item)) continue;
                matches.add(item);
            }
            totalMatches = matches.size();
            if (maxMatches > 0) {
                int i = matches.size();
                while (--i >= maxMatches) {
                    matches.remove(i);
                }
                i = matches.size();
                while (--i >= 0) {
                    matches.set(i, RegistrarImpl.copyItem((Item)matches.get(i)));
                }
            } else {
                matches = null;
            }
        } else {
            while (iter.hasNext()) {
                Item item = iter.next();
                ++totalMatches;
                if (--maxMatches < 0) continue;
                matches.add(RegistrarImpl.copyItem(item));
            }
        }
        return new Matches(matches, totalMatches);
    }

    private EventRegistration notifyDo(Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException {
        if (transitions == 0 || transitions != (transitions & 7)) {
            throw new IllegalArgumentException("invalid transitions");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        listener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)listener);
        leaseDuration = RegistrarImpl.limitDuration(leaseDuration, this.maxEventLease);
        long now = System.currentTimeMillis();
        EventReg reg = new EventReg(this.eventID, this.newLeaseID(), tmpl, transitions, listener, handback, now + leaseDuration);
        ++this.eventID;
        this.addEvent(reg);
        this.addLogRecord(new EventRegisteredLogObj(reg));
        if (reg.leaseExpiration < this.minEventExpiration) {
            this.minEventExpiration = reg.leaseExpiration;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return new EventRegistration(reg.eventID, (Object)this.proxy, (Lease)EventLease.getInstance(this.myRef, this.myServiceID, reg.eventID, reg.leaseID, reg.leaseExpiration), reg.seqNo);
    }

    private EntryClassBase[] getEntryClassesDo(Template tmpl) {
        int i;
        ArrayList<EntryClass> classes = new ArrayList<EntryClass>();
        ArrayList<String> codebases = new ArrayList<String>();
        if (tmpl.serviceID == null && RegistrarImpl.isEmpty(tmpl.serviceTypes) && RegistrarImpl.isEmpty(tmpl.attributeSetTemplates)) {
            long now = System.currentTimeMillis();
            i = this.entryClasses.size();
            while (--i >= 0) {
                EntryClass eclass = (EntryClass)this.entryClasses.get(i);
                try {
                    codebases.add(this.pickCodebase(eclass, now));
                    classes.add(eclass);
                }
                catch (ClassNotFoundException e) {}
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                i = item.attributeSets.length;
                while (--i >= 0) {
                    EntryRep attrSet = item.attributeSets[i];
                    if (!RegistrarImpl.attrMatch(tmpl.attributeSetTemplates, attrSet) || classes.contains(attrSet.eclass)) continue;
                    classes.add(attrSet.eclass);
                    codebases.add(attrSet.codebase);
                }
            }
        }
        if (classes.isEmpty()) {
            return null;
        }
        EntryClassBase[] vals = new EntryClassBase[classes.size()];
        int i2 = vals.length;
        while (--i2 >= 0) {
            vals[i2] = new EntryClassBase(((EntryClass)classes.get(i2)).getReplacement(), (String)codebases.get(i2));
        }
        return vals;
    }

    private Object[] getFieldValuesDo(Template tmpl, int setidx, int fldidx) {
        ArrayList<Object> values = new ArrayList<Object>();
        EntryRep etmpl = tmpl.attributeSetTemplates[setidx];
        if (tmpl.serviceID == null && RegistrarImpl.isEmpty(tmpl.serviceTypes) && tmpl.attributeSetTemplates.length == 1 && RegistrarImpl.allNull(etmpl.fields)) {
            long now = System.currentTimeMillis();
            EntryClass eclass = RegistrarImpl.getDefiningClass(etmpl.eclass, fldidx);
            boolean checkAttr = !eclass.equals(etmpl.eclass);
            HashMap[] attrMaps = (HashMap[])this.serviceByAttr.get(eclass);
            if (attrMaps != null && attrMaps[fldidx] != null) {
                block0: for (Map.Entry ent : attrMaps[fldidx].entrySet()) {
                    ArrayList regs = (ArrayList)ent.getValue();
                    Object value = ent.getKey();
                    int i = regs.size();
                    while (--i >= 0) {
                        SvcReg reg = (SvcReg)regs.get(i);
                        if (reg.leaseExpiration <= now || checkAttr && !RegistrarImpl.hasAttr(reg, etmpl.eclass, fldidx, value)) continue;
                        values.add(value);
                        continue block0;
                    }
                }
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                int j = item.attributeSets.length;
                while (--j >= 0) {
                    Object value;
                    if (!RegistrarImpl.matchEntry(etmpl, item.attributeSets[j]) || values.contains(value = item.attributeSets[j].fields[fldidx])) continue;
                    values.add(value);
                }
            }
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray();
    }

    private ServiceTypeBase[] getServiceTypesDo(Template tmpl, String prefix) {
        ArrayList classes = new ArrayList();
        ArrayList codebases = new ArrayList();
        if (tmpl.serviceID == null && RegistrarImpl.isEmpty(tmpl.attributeSetTemplates)) {
            ArrayList services = this.matchingServices(tmpl.serviceTypes);
            Iterator it = services.iterator();
            while (it.hasNext()) {
                Item item = ((SvcReg)it.next()).item;
                RegistrarImpl.addTypes(classes, codebases, tmpl.serviceTypes, prefix, item.serviceType, item.codebase);
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                RegistrarImpl.addTypes(classes, codebases, tmpl.serviceTypes, prefix, item.serviceType, item.codebase);
            }
        }
        if (classes.isEmpty()) {
            return null;
        }
        ServiceTypeBase[] vals = new ServiceTypeBase[classes.size()];
        int i = vals.length;
        while (--i >= 0) {
            vals[i] = new ServiceTypeBase(((ServiceType)classes.get(i)).getReplacement(), (String)codebases.get(i));
        }
        return vals;
    }

    private void addAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws UnknownLeaseException {
        long now = System.currentTimeMillis();
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        Object[] sets = reg.item.attributeSets;
        int i = 0;
        for (int j = 0; j < attrSets.length; ++j) {
            EntryRep set = attrSets[j];
            if (RegistrarImpl.indexOf(sets, set) >= 0 || RegistrarImpl.indexOf(attrSets, j, set) >= 0) continue;
            attrSets[i++] = set;
            this.addAttrs(reg, set);
        }
        if (i > 0) {
            int len = sets.length;
            EntryRep[] nsets = new EntryRep[len + i];
            System.arraycopy(sets, 0, nsets, 0, len);
            System.arraycopy(attrSets, 0, nsets, len, i);
            reg.item.attributeSets = nsets;
        }
        this.generateEvents(pre, reg.item, now);
    }

    private void modifyAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSetTmpls, EntryRep[] attrSets) throws UnknownLeaseException {
        if (attrSetTmpls.length != attrSets.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int i = attrSets.length;
        while (--i >= 0) {
            if (attrSets[i] == null || attrSets[i].eclass.isAssignableFrom(attrSetTmpls[i].eclass)) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        long now = System.currentTimeMillis();
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        EntryRep[] preSets = pre.attributeSets;
        Object[] sets = reg.item.attributeSets;
        int i2 = preSets.length;
        block1: while (--i2 >= 0) {
            EntryRep preSet = preSets[i2];
            EntryRep set = sets[i2];
            int j = attrSetTmpls.length;
            while (--j >= 0) {
                if (!RegistrarImpl.matchEntry(attrSetTmpls[j], preSet)) continue;
                EntryRep attrs = attrSets[j];
                if (attrs == null) {
                    sets = RegistrarImpl.deleteSet(reg.item, i2);
                    this.deleteAttrs(reg, set, true);
                    continue block1;
                }
                this.updateAttrs(reg, set, attrs.fields);
            }
        }
        i2 = sets.length;
        while (--i2 >= 0) {
            EntryRep set = sets[i2];
            if (RegistrarImpl.indexOf(sets, i2, set) < 0) continue;
            sets = RegistrarImpl.deleteSet(reg.item, i2);
            this.deleteInstance(set.eclass);
        }
        reg.item.attributeSets = sets;
        this.generateEvents(pre, reg.item, now);
    }

    private void setAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws UnknownLeaseException {
        attrSets = attrSets == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(attrSets);
        long now = System.currentTimeMillis();
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        EntryRep[] entries = reg.item.attributeSets;
        int i = entries.length;
        while (--i >= 0) {
            this.deleteAttrs(reg, entries[i], false);
        }
        reg.item.attributeSets = attrSets;
        i = attrSets.length;
        while (--i >= 0) {
            this.addAttrs(reg, attrSets[i]);
        }
        this.generateEvents(pre, reg.item, now);
    }

    private void cancelServiceLeaseDo(ServiceID serviceID, Uuid leaseID) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        long now = System.currentTimeMillis();
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        this.deleteService(reg, now);
        if (reg.leaseExpiration == this.minSvcExpiration) {
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
    }

    private long renewServiceLeaseDo(ServiceID serviceID, Uuid leaseID, long renewDuration) throws UnknownLeaseException {
        long now = System.currentTimeMillis();
        long renewExpiration = this.renewServiceLeaseInt(serviceID, leaseID, renewDuration, now);
        this.addLogRecord(new ServiceLeaseRenewedLogObj(serviceID, leaseID, renewExpiration));
        return renewExpiration - now;
    }

    private long renewServiceLeaseInt(ServiceID serviceID, Uuid leaseID, long renewDuration, long now) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        if (renewDuration == -1L) {
            renewDuration = this.maxServiceLease;
        } else if (renewDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        if (renewDuration > this.maxServiceLease && renewDuration > reg.leaseExpiration - now) {
            renewDuration = Math.max(reg.leaseExpiration - now, this.maxServiceLease);
        }
        long renewExpiration = now + renewDuration;
        this.serviceByTime.remove(reg);
        reg.leaseExpiration = renewExpiration;
        this.serviceByTime.put(reg, reg);
        if (renewExpiration < this.minSvcExpiration) {
            this.minSvcExpiration = renewExpiration;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return renewExpiration;
    }

    private void renewServiceLeaseAbs(ServiceID serviceID, Uuid leaseID, long renewExpiration) {
        SvcReg reg = (SvcReg)this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID)) {
            return;
        }
        this.serviceByTime.remove(reg);
        reg.leaseExpiration = renewExpiration;
        this.serviceByTime.put(reg, reg);
    }

    private void cancelEventLeaseDo(long eventID, Uuid leaseID) throws UnknownLeaseException {
        long now = System.currentTimeMillis();
        EventReg reg = (EventReg)this.eventByID.get(new Long(eventID));
        if (reg == null || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        this.deleteEvent(reg);
        if (reg.leaseExpiration == this.minEventExpiration) {
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
    }

    private long renewEventLeaseDo(long eventID, Uuid leaseID, long renewDuration) throws UnknownLeaseException {
        long now = System.currentTimeMillis();
        long renewExpiration = this.renewEventLeaseInt(eventID, leaseID, renewDuration, now);
        this.addLogRecord(new EventLeaseRenewedLogObj(eventID, leaseID, renewExpiration));
        return renewExpiration - now;
    }

    private long renewEventLeaseInt(long eventID, Uuid leaseID, long renewDuration, long now) throws UnknownLeaseException {
        if (renewDuration == -1L) {
            renewDuration = this.maxEventLease;
        } else if (renewDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        EventReg reg = (EventReg)this.eventByID.get(new Long(eventID));
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        if (renewDuration > this.maxEventLease && renewDuration > reg.leaseExpiration - now) {
            renewDuration = Math.max(reg.leaseExpiration - now, this.maxEventLease);
        }
        long renewExpiration = now + renewDuration;
        this.eventByTime.remove(reg);
        reg.leaseExpiration = renewExpiration;
        this.eventByTime.put(reg, reg);
        if (renewExpiration < this.minEventExpiration) {
            this.minEventExpiration = renewExpiration;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return renewExpiration;
    }

    private void renewEventLeaseAbs(long eventID, Uuid leaseID, long renewExpiration) {
        EventReg reg = (EventReg)this.eventByID.get(new Long(eventID));
        if (reg == null || !reg.leaseID.equals((Object)leaseID)) {
            return;
        }
        this.eventByTime.remove(reg);
        reg.leaseExpiration = renewExpiration;
        this.eventByTime.put(reg, reg);
    }

    private RenewResults renewLeasesDo(Object[] regIDs, Uuid[] leaseIDs, long[] renewals) {
        int i;
        long now = System.currentTimeMillis();
        Exception[] exceptions = null;
        for (i = 0; i < regIDs.length; ++i) {
            Object id = regIDs[i];
            try {
                if (id instanceof ServiceID) {
                    renewals[i] = this.renewServiceLeaseInt((ServiceID)id, leaseIDs[i], renewals[i], now);
                    continue;
                }
                renewals[i] = this.renewEventLeaseInt((Long)id, leaseIDs[i], renewals[i], now);
                continue;
            }
            catch (Exception e) {
                renewals[i] = -1L;
                exceptions = exceptions == null ? new Exception[]{e} : (Exception[])RegistrarImpl.arrayAdd(exceptions, e);
            }
        }
        this.addLogRecord(new LeasesRenewedLogObj(regIDs, leaseIDs, renewals));
        i = regIDs.length;
        while (--i >= 0) {
            if (renewals[i] < 0L) continue;
            int n = i;
            renewals[n] = renewals[n] - now;
        }
        return new RenewResults(renewals, exceptions);
    }

    private void renewLeasesAbs(Object[] regIDs, Uuid[] leaseIDs, long[] renewExpirations) {
        int i = regIDs.length;
        while (--i >= 0) {
            long expiration = renewExpirations[i];
            if (expiration < 0L) continue;
            Object id = regIDs[i];
            if (id instanceof ServiceID) {
                this.renewServiceLeaseAbs((ServiceID)id, leaseIDs[i], expiration);
                continue;
            }
            this.renewEventLeaseAbs((Long)id, leaseIDs[i], expiration);
        }
    }

    private Exception[] cancelLeasesDo(Object[] regIDs, Uuid[] leaseIDs) {
        Exception[] exceptions = null;
        int i = regIDs.length;
        while (--i >= 0) {
            Object id = regIDs[i];
            try {
                if (id instanceof ServiceID) {
                    this.cancelServiceLeaseDo((ServiceID)id, leaseIDs[i]);
                    continue;
                }
                this.cancelEventLeaseDo((Long)id, leaseIDs[i]);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new Exception[regIDs.length];
                }
                exceptions[i] = e;
            }
        }
        return exceptions;
    }

    private void generateEvents(Item pre, Item post, long now) {
        if (this.inRecovery) {
            return;
        }
        ServiceID sid = pre != null ? pre.serviceID : post.serviceID;
        Object val = this.subEventByService.get(sid);
        if (val instanceof EventReg) {
            this.generateEvent((EventReg)val, pre, post, sid, now);
        } else if (val != null) {
            EventReg[] regs = (EventReg[])val;
            int i = regs.length;
            while (--i >= 0) {
                this.generateEvent(regs[i], pre, post, sid, now);
            }
        }
        Iterator iter = this.subEventByID.values().iterator();
        while (iter.hasNext()) {
            this.generateEvent((EventReg)iter.next(), pre, post, sid, now);
        }
    }

    private void generateEvent(EventReg reg, Item pre, Item post, ServiceID sid, long now) {
        if (reg.leaseExpiration <= now) {
            return;
        }
        if ((reg.transitions & 2) != 0 && (pre == null || !RegistrarImpl.matchItem(reg.tmpl, pre)) && post != null && RegistrarImpl.matchItem(reg.tmpl, post)) {
            this.pendingEvent(reg, sid, post, 2);
        } else if ((reg.transitions & 1) != 0 && pre != null && RegistrarImpl.matchItem(reg.tmpl, pre) && (post == null || !RegistrarImpl.matchItem(reg.tmpl, post))) {
            this.pendingEvent(reg, sid, post, 1);
        } else if ((reg.transitions & 4) != 0 && pre != null && RegistrarImpl.matchItem(reg.tmpl, pre) && post != null && RegistrarImpl.matchItem(reg.tmpl, post)) {
            this.pendingEvent(reg, sid, post, 4);
        }
    }

    private void pendingEvent(EventReg reg, ServiceID sid, Item item, int transition) {
        if (item != null) {
            item = RegistrarImpl.copyItem(item);
        }
        this.newNotifies.add(new EventTask(reg, sid, item, transition));
    }

    private void queueEvents() {
        if (!this.newNotifies.isEmpty()) {
            this.tasker.addAll((Collection)this.newNotifies);
            this.newNotifies.clear();
        }
    }

    private ServiceID newServiceID() {
        Uuid uuid = this.serviceIdGenerator.generate();
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private Uuid newLeaseID() {
        return this.resourceIdGenerator.generate();
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF(this.getClass().getName());
        stream.writeInt(3);
        stream.writeObject(this.myServiceID);
        stream.writeLong(this.eventID);
        stream.writeInt(this.unicastPort);
        stream.writeObject(this.memberGroups);
        stream.writeObject(this.lookupGroups);
        stream.writeLong(this.announcementSeqNo);
        RegistrarImpl.marshalAttributes(this.lookupAttrs, stream);
        RegistrarImpl.marshalLocators(this.lookupLocators, stream);
        for (Map.Entry entry : this.serviceByID.entrySet()) {
            if (this.myServiceID == entry.getKey()) continue;
            stream.writeObject(entry.getValue());
        }
        stream.writeObject(null);
        Iterator iter = this.eventByID.values().iterator();
        while (iter.hasNext()) {
            stream.writeObject(iter.next());
        }
        stream.writeObject(null);
        stream.flush();
        logger.finer("wrote state snapshot");
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream stream = new ObjectInputStream(in);
        if (!this.getClass().getName().equals(stream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        int logVersion = stream.readInt();
        if (logVersion != 3) {
            throw new IOException("wrong log format version");
        }
        this.myServiceID = (ServiceID)stream.readObject();
        this.eventID = stream.readLong();
        this.unicastPort = stream.readInt();
        this.memberGroups = (String[])stream.readObject();
        this.lookupGroups = (String[])stream.readObject();
        this.announcementSeqNo = stream.readLong() + Integer.MAX_VALUE;
        this.lookupAttrs = RegistrarImpl.unmarshalAttributes(stream);
        this.lookupLocators = RegistrarImpl.prepareLocators(RegistrarImpl.unmarshalLocators(stream), this.recoveredLocatorPreparer, true);
        this.recoverServiceRegistrations(stream, logVersion);
        this.recoverEventRegistrations(stream);
        this.recoveredSnapshot = true;
        logger.finer("recovered state from snapshot");
    }

    private void recoverServiceRegistrations(ObjectInputStream stream, int logVersion) throws IOException, ClassNotFoundException {
        SvcReg sReg;
        while ((sReg = (SvcReg)stream.readObject()) != null) {
            this.addService(sReg);
        }
    }

    private void recoverEventRegistrations(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        EventReg eReg;
        while ((eReg = (EventReg)stream.readObject()) != null) {
            eReg.prepareListener(this.recoveredListenerPreparer);
            eReg.seqNo += Integer.MAX_VALUE;
            this.addEvent(eReg);
        }
    }

    private void addLogRecord(LogRecord rec) {
        block5: {
            if (this.log == null) {
                return;
            }
            try {
                int snapshotSize;
                this.log.update((Object)rec, true);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "wrote log record {0}", new Object[]{rec});
                }
                if (++this.logFileSize >= this.persistenceSnapshotThreshold && (float)this.logFileSize >= this.persistenceSnapshotWeight * (float)(snapshotSize = this.serviceByID.size() + this.eventByID.size())) {
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) break block5;
                logger.log(Level.WARNING, "log update failed", e);
            }
        }
    }

    static /* synthetic */ String[] access$1902(RegistrarImpl x0, String[] x1) {
        x0.lookupGroups = x1;
        return x1;
    }

    static /* synthetic */ LookupLocator[] access$2002(RegistrarImpl x0, LookupLocator[] x1) {
        x0.lookupLocators = x1;
        return x1;
    }

    static /* synthetic */ String[] access$2502(RegistrarImpl x0, String[] x1) {
        x0.memberGroups = x1;
        return x1;
    }

    static /* synthetic */ Entry[] access$2602(RegistrarImpl x0, Entry[] x1) {
        x0.lookupAttrs = x1;
        return x1;
    }

    static /* synthetic */ Object access$8300(RegistrarImpl x0) {
        return x0.snapshotNotifier;
    }

    static /* synthetic */ int access$8402(RegistrarImpl x0, int x1) {
        x0.logFileSize = x1;
        return x0.logFileSize;
    }

    private class SnapshotThread
    extends InterruptedStatusThread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class AnnounceThread
    extends InterruptedStatusThread {
        private final MulticastSocket socket;
        private DatagramPacket[] dataPackets;
        private LookupLocator lastLocator;
        private String[] lastGroups;

        public AnnounceThread() throws IOException {
            super("discovery announcement");
            this.dataPackets = null;
            this.setDaemon(true);
            if (RegistrarImpl.this.multicastInterfaces == null || RegistrarImpl.this.multicastInterfaces.length > 0) {
                this.socket = new MulticastSocket();
                this.socket.setTimeToLive(RegistrarImpl.this.multicastAnnouncementConstraints.getMulticastTimeToLive(15));
            } else {
                this.socket = null;
            }
        }

        public synchronized void run() {
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted() && this.announce(RegistrarImpl.this.memberGroups)) {
                    ((Object)((Object)this)).wait(RegistrarImpl.this.multicastAnnouncementInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (RegistrarImpl.this.memberGroups.length > 0) {
                this.announce(new String[0]);
            }
            this.socket.close();
        }

        private boolean announce(String[] groups) {
            if (this.dataPackets == null || !this.lastLocator.equals((Object)RegistrarImpl.this.myLocator) || !Arrays.equals(this.lastGroups, groups)) {
                Discovery disco;
                ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
                try {
                    disco = RegistrarImpl.this.getDiscovery(RegistrarImpl.this.multicastAnnouncementConstraints.chooseProtocolVersion());
                }
                catch (DiscoveryProtocolException e) {
                    throw new AssertionError((Object)e);
                }
                EncodeIterator ei = disco.encodeMulticastAnnouncement(new MulticastAnnouncement(RegistrarImpl.this.announcementSeqNo++, RegistrarImpl.this.myLocator.getHost(), RegistrarImpl.this.myLocator.getPort(), groups, RegistrarImpl.this.myServiceID), RegistrarImpl.this.multicastAnnouncementConstraints.getMulticastMaxPacketSize(512), RegistrarImpl.this.multicastAnnouncementConstraints.getUnfulfilledConstraints());
                while (ei.hasNext()) {
                    try {
                        packets.addAll(Arrays.asList(ei.next()));
                    }
                    catch (Exception e) {
                        logger.log(e instanceof UnsupportedConstraintException ? Levels.HANDLED : Level.INFO, "exception encoding multicast announcement", e);
                    }
                }
                this.lastLocator = RegistrarImpl.this.myLocator;
                this.lastGroups = groups;
                this.dataPackets = packets.toArray(new DatagramPacket[packets.size()]);
            }
            try {
                this.send(this.dataPackets);
            }
            catch (InterruptedIOException e) {
                return false;
            }
            catch (IOException e) {
                logger.log(Level.INFO, "exception sending multicast announcement", e);
            }
            return true;
        }

        private void send(DatagramPacket[] packets) throws InterruptedIOException {
            if (RegistrarImpl.this.multicastInterfaces != null) {
                Level failureLogLevel = RegistrarImpl.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                for (int i = 0; i < RegistrarImpl.this.multicastInterfaces.length; ++i) {
                    this.send(packets, RegistrarImpl.this.multicastInterfaces[i], failureLogLevel);
                }
            } else {
                this.send(packets, null, Level.WARNING);
            }
        }

        private void send(DatagramPacket[] packets, NetworkInterface nic, Level failureLogLevel) throws InterruptedIOException {
            if (nic != null) {
                try {
                    this.socket.setNetworkInterface(nic);
                }
                catch (SocketException e) {
                    if (logger.isLoggable(failureLogLevel)) {
                        RegistrarImpl.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "send", "exception setting {0}", new Object[]{nic}, e);
                    }
                    return;
                }
            }
            for (int i = 0; i < packets.length; ++i) {
                try {
                    this.socket.send(packets[i]);
                    continue;
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (nic != null) {
                        if (!logger.isLoggable(failureLogLevel)) continue;
                        RegistrarImpl.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "send", "exception sending packet on {0}", new Object[]{nic}, e);
                        continue;
                    }
                    logger.log(failureLogLevel, "exception sending packet on default interface", e);
                }
            }
        }
    }

    private class UnicastThread
    extends InterruptedStatusThread {
        private ServerSocket listen;
        public int port;

        public UnicastThread(int port) throws IOException {
            super("unicast request");
            this.setDaemon(true);
            if (port == 0) {
                try {
                    this.listen = RegistrarImpl.this.serverSocketFactory.createServerSocket(4160);
                }
                catch (IOException e) {
                    logger.log(Levels.HANDLED, "failed to bind to default port", e);
                }
            }
            if (this.listen == null) {
                this.listen = RegistrarImpl.this.serverSocketFactory.createServerSocket(port);
            }
            this.port = this.listen.getLocalPort();
        }

        public void run() {
            while (!this.hasBeenInterrupted()) {
                try {
                    Socket socket = this.listen.accept();
                    if (this.hasBeenInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            logger.log(Levels.HANDLED, "exception closing socket", e);
                        }
                        break;
                    }
                    RegistrarImpl.this.tasker.add((TaskManager.Task)new SocketTask(socket));
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    logger.log(Levels.HANDLED, "exception listening on socket", e);
                }
            }
            try {
                this.listen.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "exception closing server socket", e);
            }
        }

        public synchronized void interrupt() {
            try {
                Socket s = RegistrarImpl.this.socketFactory.createSocket(InetAddress.getLocalHost(), this.port);
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.interrupt();
        }
    }

    private class MulticastThread
    extends InterruptedStatusThread {
        private final InetAddress requestAddr;
        private final MulticastSocket socket;
        private final List failedInterfaces;

        public MulticastThread() throws IOException {
            super("multicast request");
            this.failedInterfaces = new ArrayList();
            this.setDaemon(true);
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                this.requestAddr = null;
                this.socket = null;
                return;
            }
            this.requestAddr = Constants.getRequestAddress();
            this.socket = new MulticastSocket(4160);
            if (RegistrarImpl.this.multicastInterfaces != null) {
                Level failureLogLevel = RegistrarImpl.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                for (int i = 0; i < RegistrarImpl.this.multicastInterfaces.length; ++i) {
                    NetworkInterface nic = RegistrarImpl.this.multicastInterfaces[i];
                    try {
                        this.socket.setNetworkInterface(nic);
                        this.socket.joinGroup(this.requestAddr);
                        continue;
                    }
                    catch (IOException e) {
                        this.failedInterfaces.add(nic);
                        if (!logger.isLoggable(failureLogLevel)) continue;
                        RegistrarImpl.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "<init>", "exception enabling {0}", new Object[]{nic}, e);
                    }
                }
            } else {
                try {
                    this.socket.joinGroup(this.requestAddr);
                }
                catch (IOException e) {
                    this.failedInterfaces.add(null);
                    logger.log(Level.WARNING, "exception enabling default interface", e);
                }
            }
        }

        public void run() {
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                return;
            }
            byte[] buf = new byte[RegistrarImpl.this.multicastRequestConstraints.getMulticastMaxPacketSize(512)];
            DatagramPacket dgram = new DatagramPacket(buf, buf.length);
            long retryTime = System.currentTimeMillis() + (long)RegistrarImpl.this.multicastInterfaceRetryInterval;
            while (!this.hasBeenInterrupted()) {
                try {
                    int pv;
                    int timeout = 0;
                    if (!this.failedInterfaces.isEmpty() && (timeout = (int)(retryTime - System.currentTimeMillis())) <= 0) {
                        this.retryFailedInterfaces();
                        if (this.failedInterfaces.isEmpty()) {
                            timeout = 0;
                        } else {
                            timeout = RegistrarImpl.this.multicastInterfaceRetryInterval;
                            retryTime = System.currentTimeMillis() + (long)timeout;
                        }
                    }
                    this.socket.setSoTimeout(timeout);
                    dgram.setLength(buf.length);
                    try {
                        this.socket.receive(dgram);
                    }
                    catch (NullPointerException e) {
                        break;
                    }
                    try {
                        pv = ByteBuffer.wrap(dgram.getData(), dgram.getOffset(), dgram.getLength()).getInt();
                    }
                    catch (BufferUnderflowException e) {
                        throw new DiscoveryProtocolException(null, (Throwable)e);
                    }
                    RegistrarImpl.this.multicastRequestConstraints.checkProtocolVersion(pv);
                    RegistrarImpl.this.tasker.add((TaskManager.Task)new DecodeRequestTask(dgram, RegistrarImpl.this.getDiscovery(pv)));
                    buf = new byte[buf.length];
                    dgram = new DatagramPacket(buf, buf.length);
                }
                catch (SocketTimeoutException e) {
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    if (this.hasBeenInterrupted()) break;
                    logger.log(Levels.HANDLED, "exception receiving multicast request", e);
                }
            }
            this.socket.close();
        }

        public synchronized void interrupt() {
            if (this.socket != null) {
                this.socket.close();
            }
            super.interrupt();
        }

        private void retryFailedInterfaces() {
            Iterator i = this.failedInterfaces.iterator();
            while (i.hasNext()) {
                NetworkInterface nic = (NetworkInterface)i.next();
                try {
                    Level l;
                    if (nic != null) {
                        this.socket.setNetworkInterface(nic);
                    }
                    this.socket.joinGroup(this.requestAddr);
                    i.remove();
                    Level level = l = RegistrarImpl.this.multicastInterfacesSpecified ? Level.INFO : Level.FINE;
                    if (!logger.isLoggable(l)) continue;
                    if (nic != null) {
                        logger.log(l, "enabled {0}", new Object[]{nic});
                        continue;
                    }
                    logger.log(l, "enabled default interface");
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class DestroyThread
    extends InterruptedStatusThread {
        public DestroyThread() {
            super("destroy");
            this.setDaemon(false);
        }

        public void run() {
            long now = System.currentTimeMillis();
            long endTime = now + RegistrarImpl.this.unexportTimeout;
            if (endTime < 0L) {
                endTime = Long.MAX_VALUE;
            }
            boolean unexported = false;
            while (!unexported && now < endTime) {
                unexported = RegistrarImpl.this.serverExporter.unexport(false);
                if (unexported) continue;
                try {
                    long sleepTime = Math.min(RegistrarImpl.this.unexportWait, endTime - now);
                    DestroyThread.sleep((long)sleepTime);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    logger.log(Levels.HANDLED, "exception during unexport wait", e);
                }
            }
            if (!unexported) {
                RegistrarImpl.this.serverExporter.unexport(true);
            }
            RegistrarImpl.this.serviceExpirer.interrupt();
            RegistrarImpl.this.eventExpirer.interrupt();
            RegistrarImpl.this.unicaster.interrupt();
            RegistrarImpl.this.multicaster.interrupt();
            RegistrarImpl.this.announcer.interrupt();
            RegistrarImpl.this.snapshotter.interrupt();
            RegistrarImpl.this.tasker.terminate();
            RegistrarImpl.this.joiner.terminate();
            RegistrarImpl.this.discoer.terminate();
            try {
                RegistrarImpl.this.serviceExpirer.join();
                RegistrarImpl.this.eventExpirer.join();
                RegistrarImpl.this.unicaster.join();
                RegistrarImpl.this.multicaster.join();
                RegistrarImpl.this.announcer.join();
                RegistrarImpl.this.snapshotter.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            RegistrarImpl.this.closeRequestSockets(RegistrarImpl.this.tasker.getPending());
            if (RegistrarImpl.this.log != null) {
                RegistrarImpl.this.log.deletePersistentStore();
                logger.finer("deleted persistence directory");
            }
            if (RegistrarImpl.this.lifeCycle != null) {
                RegistrarImpl.this.lifeCycle.unregister((Object)RegistrarImpl.this);
            }
            if (RegistrarImpl.this.loginContext != null) {
                try {
                    RegistrarImpl.this.loginContext.logout();
                }
                catch (LoginException e) {
                    logger.log(Level.INFO, "logout failed", e);
                }
            }
            logger.info("Reggie shutdown completed");
        }
    }

    private class EventExpireThread
    extends InterruptedStatusThread {
        public EventExpireThread() {
            super("event expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    long now = System.currentTimeMillis();
                    RegistrarImpl.this.minEventExpiration = Long.MAX_VALUE;
                    while (!RegistrarImpl.this.eventByTime.isEmpty()) {
                        EventReg reg = (EventReg)RegistrarImpl.this.eventByTime.firstKey();
                        if (reg.leaseExpiration > now) {
                            RegistrarImpl.this.minEventExpiration = reg.leaseExpiration;
                            break;
                        }
                        RegistrarImpl.this.deleteEvent(reg);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "expired event registration {0} for {1}", new Object[]{reg.leaseID, reg.listener});
                    }
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.eventNotifier, RegistrarImpl.this.minEventExpiration - now);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        Object var5_5 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
            RegistrarImpl.this.concurrentObj.writeUnlock();
        }
    }

    private class ServiceExpireThread
    extends InterruptedStatusThread {
        public ServiceExpireThread() {
            super("service expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    long now = System.currentTimeMillis();
                    while (true) {
                        SvcReg reg = (SvcReg)RegistrarImpl.this.serviceByTime.firstKey();
                        RegistrarImpl.this.minSvcExpiration = reg.leaseExpiration;
                        if (RegistrarImpl.this.minSvcExpiration > now) break;
                        RegistrarImpl.this.deleteService(reg, now);
                        RegistrarImpl.this.addLogRecord(new ServiceLeaseCancelledLogObj(reg.item.serviceID, reg.leaseID));
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "expired service registration {0}", new Object[]{reg.item.serviceID});
                    }
                    RegistrarImpl.this.queueEvents();
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.serviceNotifier, RegistrarImpl.this.minSvcExpiration - now);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        Object var5_5 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
            RegistrarImpl.this.concurrentObj.writeUnlock();
        }
    }

    private final class SocketTask
    implements TaskManager.Task {
        public final Socket socket;

        public SocketTask(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            block2: {
                try {
                    RegistrarImpl.this.respond(this.socket);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block2;
                    RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception handling unicast discovery from {0}:{1}", new Object[]{this.socket.getInetAddress(), new Integer(this.socket.getPort())}, e);
                }
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class AddressTask
    implements TaskManager.Task {
        public final String host;
        public final int port;

        public AddressTask(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddressTask)) {
                return false;
            }
            AddressTask ua = (AddressTask)obj;
            return this.host.equals(ua.host) && this.port == ua.port;
        }

        public void run() {
            block12: {
                InetAddress[] addr = new InetAddress[]{};
                try {
                    int timeout;
                    block11: {
                        try {
                            addr = InetAddress.getAllByName(this.host);
                            if (addr == null) {
                                addr = new InetAddress[]{};
                            }
                        }
                        catch (UnknownHostException e) {
                            if (!logger.isLoggable(Level.INFO)) break block11;
                            RegistrarImpl.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to resolve host {0}; connection will still be attempted", new Object[]{this.host}, e);
                        }
                    }
                    long deadline = DiscoveryConstraints.process((InvocationConstraints)RegistrarImpl.this.rawUnicastDiscoveryConstraints).getConnectionDeadline(Long.MAX_VALUE);
                    long now = System.currentTimeMillis();
                    if (deadline <= now) {
                        throw new SocketTimeoutException("timeout expired before connection attempt");
                    }
                    long timeLeft = deadline - now;
                    int n = timeout = timeLeft >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeLeft;
                    if (addr.length == 0) {
                        this.attemptResponse(new InetSocketAddress(this.host, this.port), timeout);
                        return;
                    }
                    for (int i = 0; i < addr.length; ++i) {
                        try {
                            this.attemptResponse(new InetSocketAddress(addr[i], this.port), timeout);
                            return;
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Levels.HANDLED)) {
                                RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception responding to {0}:{1}", new Object[]{addr[i], new Integer(this.port)}, e);
                            }
                            int n2 = timeout = (timeLeft = deadline - System.currentTimeMillis()) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeLeft;
                            if (timeLeft > 0L) continue;
                            throw new SocketTimeoutException("timeout expired before successful response");
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.INFO)) break block12;
                    RegistrarImpl.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to respond to {0} on port {1}", new Object[]{Arrays.asList(addr), new Integer(this.port)}, e);
                }
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attemptResponse(InetSocketAddress addr, int timeout) throws Exception {
            Socket s = RegistrarImpl.this.socketFactory.createSocket();
            try {
                s.connect(addr, timeout);
                RegistrarImpl.this.respond(s);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    s.close();
                }
                catch (IOException e) {
                    logger.log(Levels.HANDLED, "exception closing socket", e);
                }
                throw throwable;
            }
            try {
                s.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "exception closing socket", e);
            }
        }
    }

    private final class DecodeRequestTask
    implements TaskManager.Task {
        private final DatagramPacket datagram;
        private final Discovery decoder;

        public DecodeRequestTask(DatagramPacket datagram, Discovery decoder) {
            this.datagram = datagram;
            this.decoder = decoder;
        }

        public void run() {
            MulticastRequest req;
            try {
                req = this.decoder.decodeMulticastRequest(this.datagram, RegistrarImpl.this.multicastRequestConstraints.getUnfulfilledConstraints(), RegistrarImpl.this.multicastRequestSubjectChecker, true);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedIOException) && logger.isLoggable(Levels.HANDLED)) {
                    RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception decoding multicast request from {0}:{1}", new Object[]{this.datagram.getAddress(), new Integer(this.datagram.getPort())}, e);
                }
                return;
            }
            Object[] groups = req.getGroups();
            if ((groups.length == 0 || RegistrarImpl.overlap(RegistrarImpl.this.memberGroups, groups)) && RegistrarImpl.indexOf(req.getServiceIDs(), RegistrarImpl.this.myServiceID) < 0) {
                try {
                    req.checkConstraints();
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedIOException) && logger.isLoggable(Levels.HANDLED)) {
                        RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception decoding multicast request from {0}:{1}", new Object[]{this.datagram.getAddress(), new Integer(this.datagram.getPort())}, e);
                    }
                    return;
                }
                RegistrarImpl.this.tasker.addIfNew((TaskManager.Task)new AddressTask(req.getHost(), req.getPort()));
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class EventTask
    implements TaskManager.Task {
        public final EventReg reg;
        public final long seqNo;
        public final ServiceID sid;
        public final Item item;
        public final int transition;

        public EventTask(EventReg reg, ServiceID sid, Item item, int transition) {
            this.reg = reg;
            this.seqNo = ++reg.seqNo;
            this.sid = sid;
            this.item = item;
            this.transition = transition;
        }

        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "notifying listener {0} of event {1}", new Object[]{this.reg.listener, new Long(this.reg.eventID)});
            }
            try {
                this.reg.listener.notify((RemoteEvent)new RegistrarEvent(RegistrarImpl.this.proxy, this.reg.eventID, this.seqNo, this.reg.handback, this.sid, this.transition, this.item));
            }
            catch (Throwable e) {
                switch (ThrowableConstants.retryable(e)) {
                    case 2: {
                        if (e instanceof Error) {
                            logger.log(Levels.HANDLED, "exception sending event", e);
                            throw (Error)e;
                        }
                    }
                    case 1: 
                    case 3: {
                        logger.log(Level.INFO, "exception sending event", e);
                        try {
                            RegistrarImpl.this.cancelEventLease(this.reg.eventID, this.reg.leaseID);
                            break;
                        }
                        catch (UnknownLeaseException ee) {
                            logger.log(Levels.HANDLED, "exception canceling event lease", e);
                            break;
                        }
                        catch (RemoteException ee) {
                            logger.log(Levels.HANDLED, "The server has been shutdown", e);
                        }
                    }
                }
            }
        }

        public boolean runAfter(List tasks, int size) {
            int i = size;
            while (--i >= 0) {
                Object obj = tasks.get(i);
                if (!(obj instanceof EventTask) || !this.reg.listener.equals(((EventTask)obj).reg.listener)) continue;
                return true;
            }
            return false;
        }
    }

    private class IDItemIter
    extends ItemIter {
        public IDItemIter(Template tmpl) {
            super(tmpl);
            this.reg = (SvcReg)RegistrarImpl.this.serviceByID.get(tmpl.serviceID);
            if (!(this.reg == null || this.reg.leaseExpiration > this.now && RegistrarImpl.matchItem(tmpl, this.reg.item))) {
                this.reg = null;
            }
        }

        protected void step() {
            this.reg = null;
        }
    }

    private class ClassItemIter
    extends ItemIter {
        private final EntryClass eclass;
        private int classidx;
        private Iterator iter;
        private ArrayList svcs;
        private int svcidx;

        public ClassItemIter(Template tmpl) {
            super(tmpl);
            this.svcidx = 0;
            this.dupsPossible = true;
            this.eclass = tmpl.attributeSetTemplates[0].eclass;
            this.classidx = RegistrarImpl.this.entryClasses.size();
            this.step();
        }

        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepValue()) break;
            }
            this.reg = null;
        }

        private boolean stepValue() {
            do {
                if (this.iter != null && this.iter.hasNext()) {
                    this.svcs = (ArrayList)this.iter.next();
                    this.svcidx = this.svcs.size();
                    return true;
                }
                if (this.stepClass()) continue;
                return false;
            } while (this.iter != null);
            return true;
        }

        private boolean stepClass() {
            while (--this.classidx >= 0) {
                EntryClass cand = (EntryClass)RegistrarImpl.this.entryClasses.get(this.classidx);
                if (!this.eclass.isAssignableFrom(cand)) continue;
                if (cand.getNumFields() > 0) {
                    cand = RegistrarImpl.getDefiningClass(cand, cand.getNumFields() - 1);
                    HashMap[] attrMaps = (HashMap[])RegistrarImpl.this.serviceByAttr.get(cand);
                    this.iter = attrMaps[attrMaps.length - 1].values().iterator();
                } else {
                    this.iter = null;
                    this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(cand);
                    this.svcidx = this.svcs.size();
                }
                return true;
            }
            return false;
        }
    }

    private class EmptyAttrItemIter
    extends AttrItemIter {
        public EmptyAttrItemIter(Template tmpl, EntryClass eclass) {
            super(tmpl);
            this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(eclass);
            if (this.svcs != null) {
                this.svcidx = this.svcs.size();
                this.step();
            }
        }
    }

    private class AttrItemIter
    extends ItemIter {
        protected ArrayList svcs;
        protected int svcidx;

        public AttrItemIter(Template tmpl, int setidx, int fldidx) {
            super(tmpl);
            EntryRep set = tmpl.attributeSetTemplates[setidx];
            HashMap[] attrMaps = (HashMap[])RegistrarImpl.this.serviceByAttr.get(RegistrarImpl.getDefiningClass(set.eclass, fldidx));
            if (attrMaps != null && attrMaps[fldidx] != null) {
                this.svcs = (ArrayList)attrMaps[fldidx].get(set.fields[fldidx]);
                if (this.svcs != null) {
                    this.svcidx = this.svcs.size();
                    this.step();
                }
            }
        }

        protected AttrItemIter(Template tmpl) {
            super(tmpl);
        }

        protected void step() {
            while (--this.svcidx >= 0) {
                this.reg = (SvcReg)this.svcs.get(this.svcidx);
                if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                return;
            }
            this.reg = null;
        }
    }

    private class SvcIterator
    extends ItemIter {
        private final Iterator services;

        public SvcIterator(Template tmpl) {
            super(tmpl);
            Map map = (Map)RegistrarImpl.this.serviceByTypeName.get(tmpl.serviceTypes[0].getName());
            this.services = map != null ? map.values().iterator() : Collections.EMPTY_LIST.iterator();
            this.step();
        }

        protected void step() {
            if (this.tmpl.serviceTypes.length > 1) {
                while (this.services.hasNext()) {
                    this.reg = (SvcReg)this.services.next();
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchType(this.tmpl.serviceTypes, this.reg.item.serviceType) || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
            } else {
                while (this.services.hasNext()) {
                    this.reg = (SvcReg)this.services.next();
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
            }
            this.reg = null;
        }
    }

    private class AllItemIter
    extends ItemIter {
        private final Iterator iter;

        public AllItemIter() {
            super(null);
            this.iter = RegistrarImpl.this.serviceByID.values().iterator();
            this.step();
        }

        protected void step() {
            while (this.iter.hasNext()) {
                this.reg = (SvcReg)this.iter.next();
                if (this.reg.leaseExpiration <= this.now) continue;
                return;
            }
            this.reg = null;
        }
    }

    private abstract class ItemIter {
        public final long now = System.currentTimeMillis();
        public boolean dupsPossible = false;
        protected final Template tmpl;
        protected SvcReg reg;

        protected ItemIter(Template tmpl) {
            this.tmpl = tmpl;
        }

        public boolean hasNext() {
            return this.reg != null;
        }

        public Item next() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            Item item = this.reg.item;
            this.step();
            return item;
        }

        public SvcReg nextReg() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            SvcReg cur = this.reg;
            this.step();
            return cur;
        }

        protected abstract void step();
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream out) throws IOException {
            RegistrarImpl.this.takeSnapshot(out);
        }

        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            RegistrarImpl.this.recoverSnapshot(in);
        }

        public void applyUpdate(Object logRecObj) {
            ((LogRecord)logRecObj).apply(RegistrarImpl.this);
        }
    }

    private static class LookupAttributesChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private transient Entry[] attrs;

        public LookupAttributesChangedLogObj(Entry[] attrs) {
            this.attrs = attrs;
        }

        public void apply(RegistrarImpl regImpl) {
            RegistrarImpl.access$2602(regImpl, this.attrs);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            RegistrarImpl.marshalAttributes(this.attrs, stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.attrs = RegistrarImpl.unmarshalAttributes(stream);
        }
    }

    private static class MemberGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private String[] groups;

        public MemberGroupsChangedLogObj(String[] groups) {
            this.groups = groups;
        }

        public void apply(RegistrarImpl regImpl) {
            RegistrarImpl.access$2502(regImpl, this.groups);
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private transient LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] locators) {
            this.locators = locators;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                RegistrarImpl.access$2002(regImpl, RegistrarImpl.prepareLocators(this.locators, regImpl.recoveredLocatorPreparer, true));
            }
            catch (RemoteException e) {
                throw new AssertionError((Object)e);
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            RegistrarImpl.marshalLocators(this.locators, stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.locators = RegistrarImpl.unmarshalLocators(stream);
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] groups) {
            this.groups = groups;
        }

        public void apply(RegistrarImpl regImpl) {
            RegistrarImpl.access$1902(regImpl, this.groups);
        }
    }

    private static class UnicastPortSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private int newPort;

        public UnicastPortSetLogObj(int newPort) {
            this.newPort = newPort;
        }

        public void apply(RegistrarImpl regImpl) {
            regImpl.unicastPort = this.newPort;
        }
    }

    private static class LeasesCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Object[] regIDs;
        private Uuid[] leaseIDs;

        public LeasesCancelledLogObj(Object[] regIDs, Uuid[] leaseIDs) {
            this.regIDs = regIDs;
            this.leaseIDs = leaseIDs;
        }

        public void apply(RegistrarImpl regImpl) {
            regImpl.cancelLeasesDo(this.regIDs, this.leaseIDs);
        }
    }

    private static class LeasesRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Object[] regIDs;
        private Uuid[] leaseIDs;
        private long[] leaseExpTimes;

        public LeasesRenewedLogObj(Object[] regIDs, Uuid[] leaseIDs, long[] leaseExpTimes) {
            this.regIDs = regIDs;
            this.leaseIDs = leaseIDs;
            this.leaseExpTimes = leaseExpTimes;
        }

        public void apply(RegistrarImpl regImpl) {
            regImpl.renewLeasesAbs(this.regIDs, this.leaseIDs, this.leaseExpTimes);
        }
    }

    private static class EventLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private long eventID;
        private Uuid leaseID;
        private long leaseExpTime;

        public EventLeaseRenewedLogObj(long eventID, Uuid leaseID, long leaseExpTime) {
            this.eventID = eventID;
            this.leaseID = leaseID;
            this.leaseExpTime = leaseExpTime;
        }

        public void apply(RegistrarImpl regImpl) {
            regImpl.renewEventLeaseAbs(this.eventID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class EventLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private long eventID;
        private Uuid leaseID;

        public EventLeaseCancelledLogObj(long eventID, Uuid leaseID) {
            this.eventID = eventID;
            this.leaseID = leaseID;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                regImpl.cancelEventLeaseDo(this.eventID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class ServiceLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private long leaseExpTime;

        public ServiceLeaseRenewedLogObj(ServiceID serviceID, Uuid leaseID, long leaseExpTime) {
            this.serviceID = serviceID;
            this.leaseID = leaseID;
            this.leaseExpTime = leaseExpTime;
        }

        public void apply(RegistrarImpl regImpl) {
            regImpl.renewServiceLeaseAbs(this.serviceID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class ServiceLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;

        public ServiceLeaseCancelledLogObj(ServiceID serviceID, Uuid leaseID) {
            this.serviceID = serviceID;
            this.leaseID = leaseID;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                regImpl.cancelServiceLeaseDo(this.serviceID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class EventRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private EventReg eventReg;

        public EventRegisteredLogObj(EventReg eventReg) {
            this.eventReg = eventReg;
        }

        public void apply(RegistrarImpl regImpl) {
            this.eventReg.prepareListener(regImpl.recoveredListenerPreparer);
            this.eventReg.seqNo += Integer.MAX_VALUE;
            regImpl.addEvent(this.eventReg);
            regImpl.eventID++;
        }
    }

    private static class AttrsSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSets;

        public AttrsSetLogObj(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) {
            this.serviceID = serviceID;
            this.leaseID = leaseID;
            this.attrSets = attrSets;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                regImpl.setAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class AttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSetTmpls;
        private EntryRep[] attrSets;

        public AttrsModifiedLogObj(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSetTmpls, EntryRep[] attrSets) {
            this.serviceID = serviceID;
            this.leaseID = leaseID;
            this.attrSetTmpls = attrSetTmpls;
            this.attrSets = attrSets;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                regImpl.modifyAttributesDo(this.serviceID, this.leaseID, this.attrSetTmpls, this.attrSets);
            }
            catch (UnknownLeaseException e) {
                throw new AssertionError((Object)"an UnknownLeaseException should never occur during recovery");
            }
        }
    }

    private static class AttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSets;

        public AttrsAddedLogObj(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) {
            this.serviceID = serviceID;
            this.leaseID = leaseID;
            this.attrSets = attrSets;
        }

        public void apply(RegistrarImpl regImpl) {
            try {
                regImpl.addAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException e) {
                throw new AssertionError((Object)"an UnknownLeaseException should never occur during recovery");
            }
        }
    }

    private static class SvcRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private SvcReg reg;

        public SvcRegisteredLogObj(SvcReg reg) {
            this.reg = reg;
        }

        public void apply(RegistrarImpl regImpl) {
            SvcReg oldReg = (SvcReg)regImpl.serviceByID.get(this.reg.item.serviceID);
            if (oldReg != null) {
                regImpl.deleteService(oldReg, 0L);
            }
            regImpl.addService(this.reg);
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(RegistrarImpl var1);
    }

    private static final class EventReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final long eventID;
        public final Uuid leaseID;
        public final Template tmpl;
        public final int transitions;
        public long seqNo;
        public transient RemoteEventListener listener;
        public final MarshalledObject handback;
        public long leaseExpiration;

        public EventReg(long eventID, Uuid leaseID, Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseExpiration) {
            this.eventID = eventID;
            this.leaseID = leaseID;
            this.tmpl = tmpl;
            this.transitions = transitions;
            this.seqNo = 0L;
            this.listener = listener;
            this.handback = handback;
            this.leaseExpiration = leaseExpiration;
        }

        public int compareTo(Object obj) {
            EventReg reg = (EventReg)obj;
            if (this == reg) {
                return 0;
            }
            if (this.leaseExpiration < reg.leaseExpiration || this.leaseExpiration == reg.leaseExpiration && this.eventID < reg.eventID) {
                return -1;
            }
            return 1;
        }

        public void prepareListener(ProxyPreparer preparer) {
            if (this.listener != null) {
                try {
                    this.listener = (RemoteEventListener)preparer.prepareProxy((Object)this.listener);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        RegistrarImpl.logThrow(Level.WARNING, this.getClass().getName(), "prepareListener", "failed to prepare event listener {0}", new Object[]{this.listener}, e);
                    }
                    this.listener = null;
                }
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(new MarshalledInstance((Object)this.listener));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            MarshalledInstance mi = (MarshalledInstance)stream.readObject();
            try {
                this.listener = (RemoteEventListener)mi.get(false);
            }
            catch (Throwable e) {
                if (e instanceof Error && ThrowableConstants.retryable(e) == 2) {
                    throw (Error)e;
                }
                logger.log(Level.WARNING, "failed to recover event listener", e);
            }
        }
    }

    private static final class SvcReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final Item item;
        public final Uuid leaseID;
        public long leaseExpiration;

        public SvcReg(Item item, Uuid leaseID, long leaseExpiration) {
            this.item = item;
            this.leaseID = leaseID;
            this.leaseExpiration = leaseExpiration;
        }

        public int compareTo(Object obj) {
            SvcReg reg = (SvcReg)obj;
            if (this == reg) {
                return 0;
            }
            int i = SvcReg.compare(this.leaseExpiration, reg.leaseExpiration);
            if (i != 0) {
                return i;
            }
            i = SvcReg.compare(this.leaseID.getMostSignificantBits(), reg.leaseID.getMostSignificantBits());
            if (i != 0) {
                return i;
            }
            return SvcReg.compare(this.leaseID.getLeastSignificantBits(), reg.leaseID.getLeastSignificantBits());
        }

        private static int compare(long l1, long l2) {
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
    }
}

