/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import net.jini.loader.ClassLoading;

class ServiceType
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final ServiceType[] empty = new ServiceType[0];
    private String name;
    protected long hash;
    protected ServiceType superclass;
    protected ServiceType[] interfaces;
    protected transient ServiceType replacement;
    private transient boolean integrity = false;

    public ServiceType(Class clazz, ServiceType superclass, ServiceType[] interfaces) throws MarshalException {
        if (!Proxy.isProxyClass(clazz)) {
            this.name = clazz.getName();
        } else if (interfaces.length == 0) {
            this.name = ";";
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < interfaces.length; ++i) {
                buf.append(';');
                buf.append(interfaces[i].getName());
            }
            this.name = buf.toString();
        }
        this.superclass = superclass;
        if (clazz != Object.class) {
            this.interfaces = interfaces;
        }
        try {
            this.computeHash();
        }
        catch (Exception e) {
            throw new MarshalException("unable to calculate the type hash for " + this.name, e);
        }
    }

    private ServiceType(ServiceType stype) {
        this.name = stype.name;
    }

    public String getName() {
        return this.name;
    }

    public ServiceType getSuperclass() {
        return this.superclass;
    }

    public ServiceType[] getInterfaces() {
        if (this.interfaces != null) {
            return this.interfaces;
        }
        return empty;
    }

    public synchronized ServiceType getReplacement() {
        if (this.replacement == null) {
            this.replacement = new ServiceType(this);
        }
        return this.replacement;
    }

    private boolean isAssignableFrom(ServiceType[] ifaces) {
        int i = ifaces.length;
        while (--i >= 0) {
            if (this.hash != ifaces[i].hash && !this.isAssignableFrom(ifaces[i].interfaces)) continue;
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return this.superclass == null && this.interfaces != null;
    }

    public boolean isAssignableFrom(ServiceType cls) {
        if (this.hash == cls.hash) {
            return true;
        }
        if (this.isInterface()) {
            if (cls.interfaces != null && this.isAssignableFrom(cls.interfaces)) {
                return true;
            }
            ServiceType sup = cls.superclass;
            while (sup != null && sup.interfaces != null) {
                if (this.isAssignableFrom(sup.interfaces)) {
                    return true;
                }
                sup = sup.superclass;
            }
        } else {
            ServiceType sup = cls.superclass;
            while (sup != null) {
                if (this.hash == sup.hash) {
                    return true;
                }
                sup = sup.superclass;
            }
        }
        return false;
    }

    public Class toClass(String codebase) throws IOException, ClassNotFoundException {
        if (this.name.charAt(0) != ';') {
            return ClassLoading.loadClass((String)codebase, (String)this.name, null, (boolean)this.integrity, null);
        }
        StringTokenizer st = new StringTokenizer(this.name, ";");
        String[] ifs = new String[st.countTokens()];
        for (int i = 0; i < ifs.length; ++i) {
            ifs[i] = st.nextToken();
        }
        return ClassLoading.loadProxyClass((String)codebase, (String[])ifs, null, (boolean)this.integrity, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceType)) {
            return false;
        }
        ServiceType t = (ServiceType)o;
        return this.hash == t.hash;
    }

    public int hashCode() {
        return (int)(this.hash ^ this.hash >>> 32);
    }

    public String toString() {
        return this.getClass() + "[name=" + this.getName() + "]";
    }

    private void computeHash() throws IOException, NoSuchAlgorithmException {
        this.hash = 0L;
        MessageDigest md = MessageDigest.getInstance("SHA");
        DataOutputStream out = new DataOutputStream(new DigestOutputStream(new ByteArrayOutputStream(127), md));
        out.writeUTF(this.name);
        out.flush();
        byte[] digest = md.digest();
        int i = Math.min(8, digest.length);
        while (--i >= 0) {
            this.hash += (long)(digest[i] & 0xFF) << i * 8;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.name == null) {
            throw new InvalidObjectException("name cannot be null");
        }
        this.integrity = MarshalledWrapper.integrityEnforced((ObjectInputStream)in);
        if (this.hash == 0L) {
            try {
                this.computeHash();
            }
            catch (Exception e) {
                throw new UnmarshalException("unable to calculate the type hash for " + this.name, e);
            }
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data");
    }
}

