/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.net.URL;
import java.util.Arrays;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.loader.pref.PreferredClassLoader;

public class ExportClassLoader
extends PreferredClassLoader {
    private final URL[] exportURLs;
    private final Uuid id = UuidFactory.generate();

    public ExportClassLoader(URL[] importURLs, URL[] exportURLs, ClassLoader parent) {
        super(importURLs, parent, ExportClassLoader.urlsToPath(exportURLs), false);
        this.exportURLs = exportURLs == null ? importURLs : exportURLs;
    }

    public URL[] getURLs() {
        return (URL[])this.exportURLs.clone();
    }

    public String toString() {
        URL[] urls = super.getURLs();
        return ((Object)((Object)this)).getClass().getName() + "[importURLs=" + (urls == null ? null : Arrays.asList(urls)) + "," + "exportURLs=" + (this.exportURLs == null ? null : Arrays.asList(this.exportURLs)) + "," + "parent=" + this.getParent() + "," + "id=" + this.id + "]";
    }

    private static String urlsToPath(URL[] urls) {
        if (urls == null) {
            return null;
        }
        if (urls.length == 0) {
            return "";
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }
}

