/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.config.Config;
import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.ExportClassLoader;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import com.sun.jini.start.ServiceStarter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.export.ProxyAccessor;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;

public class NonActivatableServiceDescriptor
implements ServiceDescriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class[] actTypes = new Class[]{String[].class, LifeCycle.class};
    private final String codebase;
    private final String policy;
    private final String classpath;
    private final String implClassName;
    private final String[] serverConfigArgs;
    private final Configuration configuration;
    private transient LifeCycle lifeCycle;
    private transient ProxyPreparer servicePreparer;
    protected transient boolean descCreated = false;
    protected transient Object descCreatedLock = new Object();
    private static LifeCycle NoOpLifeCycle = new LifeCycle(){

        public boolean unregister(Object impl) {
            return false;
        }
    };
    private static AggregatePolicyProvider globalPolicy = null;
    private static Policy initialGlobalPolicy = null;
    private static final Logger logger = ServiceStarter.logger;
    private static String servicePolicyProvider = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Security.getProperty("com.sun.jini.start.servicePolicyProvider");
        }
    });
    private static final Class[] policyTypes = new Class[]{Policy.class};

    public NonActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String[] serverConfigArgs, LifeCycle lifeCycle, ProxyPreparer preparer) {
        if (exportCodebase == null || policy == null || importCodebase == null || implClassName == null) {
            throw new NullPointerException("export codebase, policy, import codebase, and implementation cannot be null");
        }
        this.codebase = exportCodebase;
        this.policy = policy;
        this.classpath = importCodebase;
        this.implClassName = implClassName;
        this.serverConfigArgs = serverConfigArgs;
        this.configuration = null;
        this.lifeCycle = lifeCycle == null ? NoOpLifeCycle : lifeCycle;
        this.servicePreparer = preparer;
    }

    public NonActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, Configuration config, LifeCycle lifeCycle, ProxyPreparer preparer) {
        if (exportCodebase == null || policy == null || importCodebase == null || implClassName == null) {
            throw new NullPointerException("export codebase, policy, import codebase, and implementation cannot be null");
        }
        this.codebase = exportCodebase;
        this.policy = policy;
        this.classpath = importCodebase;
        this.implClassName = implClassName;
        this.serverConfigArgs = null;
        this.configuration = config;
        this.lifeCycle = lifeCycle == null ? NoOpLifeCycle : lifeCycle;
        this.servicePreparer = preparer;
    }

    public NonActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String[] serverConfigArgs, LifeCycle lifeCycle) {
        this(exportCodebase, policy, importCodebase, implClassName, serverConfigArgs, lifeCycle, null);
    }

    public NonActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String[] serverConfigArgs) {
        this(exportCodebase, policy, importCodebase, implClassName, serverConfigArgs, null, null);
    }

    public NonActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String[] serverConfigArgs, ProxyPreparer preparer) {
        this(exportCodebase, policy, importCodebase, implClassName, serverConfigArgs, null, preparer);
    }

    public final String getExportCodebase() {
        return this.codebase;
    }

    public final String getPolicy() {
        return this.policy;
    }

    public final String getImportCodebase() {
        return this.classpath;
    }

    public final String getImplClassName() {
        return this.implClassName;
    }

    public final String[] getServerConfigArgs() {
        return this.serverConfigArgs != null ? (String[])this.serverConfigArgs.clone() : null;
    }

    public final LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLifeCycle(LifeCycle lc) {
        Object object = this.descCreatedLock;
        synchronized (object) {
            if (this.descCreated) {
                throw new IllegalStateException("Can't set LifeCycle after descriptor creation");
            }
            this.lifeCycle = lc;
        }
    }

    public final ProxyPreparer getServicePreparer() {
        return this.servicePreparer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setServicePreparer(ProxyPreparer serviceProxyPreparer) {
        Object object = this.descCreatedLock;
        synchronized (object) {
            if (this.descCreated) {
                throw new IllegalStateException("Can't set ProxyPreparer after descriptor creation");
            }
            this.servicePreparer = serviceProxyPreparer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Configuration config) throws Exception {
        ServiceStarter.ensureSecurityManager();
        logger.entering(NonActivatableServiceDescriptor.class.getName(), "create", new Object[]{config});
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        Object object = this.descCreatedLock;
        synchronized (object) {
            this.descCreated = true;
        }
        if (this.servicePreparer == null) {
            this.servicePreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.start", (String)"servicePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        }
        HTTPDStatus.httpdWarning(this.getExportCodebase());
        Object proxy = null;
        Object impl = null;
        Thread curThread = Thread.currentThread();
        ClassLoader oldClassLoader = curThread.getContextClassLoader();
        logger.log(Level.FINEST, "Saved current context class loader: {0}", oldClassLoader);
        ExportClassLoader newClassLoader = null;
        try {
            newClassLoader = new ExportClassLoader(ClassLoaderUtil.getImportCodebaseURLs(this.getImportCodebase()), ClassLoaderUtil.getCodebaseURLs(this.getExportCodebase()), oldClassLoader);
            logger.log(Level.FINEST, "Created ExportClassLoader: {0}", (Object)newClassLoader);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "classloader.problem", new Object[]{this.getImportCodebase(), this.getExportCodebase()});
            throw ioe;
        }
        Class<NonActivatableServiceDescriptor> ioe = NonActivatableServiceDescriptor.class;
        synchronized (NonActivatableServiceDescriptor.class) {
            if (globalPolicy == null) {
                initialGlobalPolicy = Policy.getPolicy();
                if (!(initialGlobalPolicy instanceof DynamicPolicy)) {
                    initialGlobalPolicy = new DynamicPolicyProvider(initialGlobalPolicy);
                }
                globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                Policy.setPolicy(globalPolicy);
                logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
            }
            Policy service_policy = NonActivatableServiceDescriptor.getServicePolicyProvider((Policy)new PolicyFileProvider(this.getPolicy()));
            Policy backstop_policy = NonActivatableServiceDescriptor.getServicePolicyProvider(initialGlobalPolicy);
            LoaderSplitPolicyProvider split_service_policy = new LoaderSplitPolicyProvider((ClassLoader)((Object)newClassLoader), service_policy, backstop_policy);
            split_service_policy.grant(this.getClass(), null, new Permission[]{new AllPermission()});
            globalPolicy.setPolicy((ClassLoader)((Object)newClassLoader), split_service_policy);
            // ** MonitorExit[ioe] (shouldn't be in output)
            logger.finest("Attempting to get implementation class");
            Class<?> implClass = null;
            implClass = Class.forName(this.getImplClassName(), false, (ClassLoader)((Object)newClassLoader));
            logger.finest("Setting context class loader");
            curThread.setContextClassLoader((ClassLoader)((Object)newClassLoader));
            try {
                logger.finest("Attempting to get implementation constructor");
                Object[] argParms = new Object[]{this.getServerConfigArgs(), this.lifeCycle};
                Class[] argTypes = actTypes;
                if (this.configuration != null) {
                    if (this.getServerConfigArgs() != null) {
                        logger.severe("both configArgs and configuration specified, using configuration");
                    }
                    argParms = new Object[]{this.configuration, this.lifeCycle};
                    argTypes = new Class[]{Configuration.class, LifeCycle.class};
                }
                Constructor<?> constructor = implClass.getDeclaredConstructor(argTypes);
                logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                constructor.setAccessible(true);
                impl = constructor.newInstance(argParms);
                logger.log(Level.FINEST, "Obtained implementation instance: {0}", (Object)impl);
                proxy = impl instanceof ServiceProxyAccessor ? ((ServiceProxyAccessor)impl).getServiceProxy() : (impl instanceof ProxyAccessor ? ((ProxyAccessor)impl).getProxy() : null);
                logger.log(Level.FINEST, "Proxy =  {0}", proxy);
                curThread.setContextClassLoader(oldClassLoader);
                proxy = new MarshalledObject<Object>(proxy).get();
                Object var13_14 = null;
                curThread.setContextClassLoader(oldClassLoader);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                curThread.setContextClassLoader(oldClassLoader);
                throw throwable;
            }
            if (proxy != null) {
                proxy = this.servicePreparer.prepareProxy(proxy);
            }
            Created created = new Created(impl, proxy);
            logger.exiting(NonActivatableServiceDescriptor.class.getName(), "create", created);
            return created;
        }
    }

    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>(7);
        fields.add(this.codebase);
        fields.add(this.policy);
        fields.add(this.classpath);
        fields.add(this.implClassName);
        fields.add(this.serverConfigArgs == null ? null : Arrays.asList(this.serverConfigArgs));
        fields.add(this.lifeCycle);
        fields.add(this.servicePreparer);
        return fields.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.codebase == null) {
            throw new InvalidObjectException("null export codebase");
        }
        if (this.policy == null) {
            throw new InvalidObjectException("null policy");
        }
        if (this.classpath == null) {
            throw new InvalidObjectException("null import codebase");
        }
        if (this.implClassName == null) {
            throw new InvalidObjectException("null implementation class name");
        }
        this.lifeCycle = NoOpLifeCycle;
        this.servicePreparer = null;
        this.descCreated = false;
        this.descCreatedLock = new Object();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }

    static Policy getServicePolicyProvider(Policy service_policy) throws Exception {
        Object servicePolicyWrapper = null;
        if (servicePolicyProvider != null) {
            Class<?> sp = Class.forName(servicePolicyProvider);
            logger.log(Level.FINEST, "Obtained custom service policy implementation class: {0}", sp);
            Constructor<?> constructor = sp.getConstructor(policyTypes);
            logger.log(Level.FINEST, "Obtained custom service policy implementation constructor: {0}", constructor);
            servicePolicyWrapper = (Policy)constructor.newInstance(service_policy);
            logger.log(Level.FINEST, "Obtained custom service policy implementation instance: {0}", servicePolicyWrapper);
        } else {
            servicePolicyWrapper = new DynamicPolicyProvider(service_policy);
            logger.log(Level.FINEST, "Using default service policy implementation instance: {0}", servicePolicyWrapper);
        }
        return servicePolicyWrapper;
    }

    public static class Created {
        public final Object proxy;
        public final Object impl;

        public Created(Object impl, Object proxy) {
            this.proxy = proxy;
            this.impl = impl;
        }
    }
}

